/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.shared.graphics;

import io.openmobilemaps.mapscore.shared.graphics.common.Color;
import io.openmobilemaps.mapscore.shared.graphics.common.RectI;
import io.openmobilemaps.mapscore.shared.graphics.common.Vec2I;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0004H&J\b\u0010\n\u001a\u00020\u0004H&J\b\u0010\u000b\u001a\u00020\u0004H&J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH&J\b\u0010\u0011\u001a\u00020\u0004H&\u00a8\u0006\u0013"}, d2={"Lio/openmobilemaps/mapscore/shared/graphics/RenderingContextInterface;", "", "()V", "applyScissorRect", "", "scissorRect", "Lio/openmobilemaps/mapscore/shared/graphics/common/RectI;", "getViewportSize", "Lio/openmobilemaps/mapscore/shared/graphics/common/Vec2I;", "onSurfaceCreated", "postRenderStencilMask", "preRenderStencilMask", "setBackgroundColor", "color", "Lio/openmobilemaps/mapscore/shared/graphics/common/Color;", "setViewportSize", "size", "setupDrawFrame", "CppProxy", "mapscore_release"})
public abstract class RenderingContextInterface {
    public abstract void onSurfaceCreated();

    public abstract void setViewportSize(@NotNull Vec2I var1);

    @NotNull
    public abstract Vec2I getViewportSize();

    public abstract void setBackgroundColor(@NotNull Color var1);

    public abstract void setupDrawFrame();

    public abstract void preRenderStencilMask();

    public abstract void postRenderStencilMask();

    public abstract void applyScissorRect(@Nullable RectI var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0011\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u001b\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0082 J\u0011\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\u0011\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\u0011\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\u0011\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\u0019\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0082 J\u0019\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000eH\u0082 J\u0011\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\b\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/openmobilemaps/mapscore/shared/graphics/RenderingContextInterface$CppProxy;", "Lio/openmobilemaps/mapscore/shared/graphics/RenderingContextInterface;", "nativeRef", "", "(J)V", "destroyed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_djinni_private_destroy", "", "applyScissorRect", "scissorRect", "Lio/openmobilemaps/mapscore/shared/graphics/common/RectI;", "finalize", "getViewportSize", "Lio/openmobilemaps/mapscore/shared/graphics/common/Vec2I;", "nativeDestroy", "native_applyScissorRect", "_nativeRef", "native_getViewportSize", "native_onSurfaceCreated", "native_postRenderStencilMask", "native_preRenderStencilMask", "native_setBackgroundColor", "color", "Lio/openmobilemaps/mapscore/shared/graphics/common/Color;", "native_setViewportSize", "size", "native_setupDrawFrame", "onSurfaceCreated", "postRenderStencilMask", "preRenderStencilMask", "setBackgroundColor", "setViewportSize", "setupDrawFrame", "mapscore_release"})
    private static final class CppProxy
    extends RenderingContextInterface {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private final native void nativeDestroy(long var1);

        public final void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected final void finalize() {
            this._djinni_private_destroy();
        }

        @Override
        public void onSurfaceCreated() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_onSurfaceCreated(this.nativeRef);
        }

        private final native void native_onSurfaceCreated(long var1);

        @Override
        public void setViewportSize(@NotNull Vec2I size) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_setViewportSize(this.nativeRef, size);
        }

        private final native void native_setViewportSize(long var1, Vec2I var3);

        @Override
        @NotNull
        public Vec2I getViewportSize() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.native_getViewportSize(this.nativeRef);
        }

        private final native Vec2I native_getViewportSize(long var1);

        @Override
        public void setBackgroundColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_setBackgroundColor(this.nativeRef, color);
        }

        private final native void native_setBackgroundColor(long var1, Color var3);

        @Override
        public void setupDrawFrame() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_setupDrawFrame(this.nativeRef);
        }

        private final native void native_setupDrawFrame(long var1);

        @Override
        public void preRenderStencilMask() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_preRenderStencilMask(this.nativeRef);
        }

        private final native void native_preRenderStencilMask(long var1);

        @Override
        public void postRenderStencilMask() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_postRenderStencilMask(this.nativeRef);
        }

        private final native void native_postRenderStencilMask(long var1);

        @Override
        public void applyScissorRect(@Nullable RectI scissorRect) {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_applyScissorRect(this.nativeRef, scissorRect);
        }

        private final native void native_applyScissorRect(long var1, RectI var3);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                String string = "nativeRef is zero";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.nativeRef = nativeRef;
        }
    }
}

