/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.opengl.GLUtils;
import io.openmobilemaps.mapscore.shared.graphics.objects.TextureHolderInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/openmobilemaps/mapscore/graphics/BitmapTextureHolder;", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextureHolderInterface;", "drawable", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "targetWidth", "", "targetHeight", "(Landroid/graphics/drawable/Drawable;II)V", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "imageHeight", "imageWidth", "textureHeight", "textureWidth", "attachToGraphics", "", "getImageHeight", "getImageWidth", "getTextureHeight", "getTextureWidth", "Companion", "mapscore_release"})
public final class BitmapTextureHolder
extends TextureHolderInterface {
    @NotNull
    private final Bitmap bitmap;
    private int imageWidth;
    private int imageHeight;
    private int textureWidth;
    private int textureHeight;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Override
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Override
    public void attachToGraphics() {
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.bitmap, (int)0);
    }

    public BitmapTextureHolder(@NotNull Bitmap bitmap) {
        int height;
        int width;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap bitmap2 = bitmap;
        for (width = 2; width < bitmap2.getWidth(); width *= 2) {
        }
        for (height = 2; height < bitmap2.getHeight(); height *= 2) {
        }
        this.imageWidth = bitmap2.getWidth();
        this.imageHeight = bitmap2.getHeight();
        this.textureWidth = width;
        this.textureHeight = height;
        if (bitmap2.getWidth() != width || bitmap2.getHeight() != height) {
            Bitmap large = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(large);
            c.drawBitmap(bitmap2, 0.0f, 0.0f, null);
            c.save();
            c.scale(1.0f, -1.0f, 0.0f, (float)bitmap2.getHeight());
            c.drawBitmap(bitmap2, 0.0f, 0.0f, null);
            c.restore();
            c.save();
            c.scale(-1.0f, 1.0f, (float)bitmap2.getWidth(), 0.0f);
            c.drawBitmap(bitmap2, 0.0f, 0.0f, null);
            c.restore();
            c.scale(-1.0f, -1.0f, (float)bitmap2.getWidth(), (float)bitmap2.getHeight());
            c.drawBitmap(bitmap2, 0.0f, 0.0f, null);
            bitmap2.recycle();
            Bitmap bitmap3 = large;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"large");
            bitmap2 = bitmap3;
        }
        this.bitmap = bitmap2;
    }

    public BitmapTextureHolder(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this(BitmapTextureHolder.Companion.createBitmapFromDrawable(drawable));
    }

    public BitmapTextureHolder(@NotNull Drawable drawable, int targetWidth, int targetHeight) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        this(BitmapTextureHolder.Companion.createBitmapFromDrawable(drawable, targetWidth, targetHeight));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lio/openmobilemaps/mapscore/graphics/BitmapTextureHolder$Companion;", "", "()V", "createBitmapFromDrawable", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "targetWidth", "", "targetHeight", "mapscore_release"})
    public static final class Companion {
        private final Bitmap createBitmapFromDrawable(Drawable drawable) {
            return this.createBitmapFromDrawable(drawable, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        }

        private final Bitmap createBitmapFromDrawable(Drawable drawable, int targetWidth, int targetHeight) {
            Bitmap bitmap = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
            return bitmap2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

