/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.graphics;

import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.Log;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\f\u0018\u0000 S2\u00020\u0001:\u0001SB\u0017\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010>\u001a\u00020\u0004H\u0002J\b\u0010?\u001a\u00020\u0004H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010A\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0006\u0010B\u001a\u00020\u0011J\b\u0010C\u001a\u00020\u0004H\u0002J\u0006\u0010D\u001a\u00020\u0004J\b\u0010E\u001a\u00020\u0004H\u0002J\u001d\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G2\b\b\u0002\u00108\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020\u0004H\u0002J\u0016\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\u001bJ\u001e\u0010N\u001a\u00020\u00042\b\b\u0002\u0010O\u001a\u00020\u00112\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010Q\u001a\u00020\u0004J\b\u0010R\u001a\u00020\u0004H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001eR\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lio/openmobilemaps/mapscore/graphics/GLThread;", "Ljava/lang/Thread;", "onDrawCallback", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "egl", "Ljavax/microedition/khronos/egl/EGL10;", "eglConfig", "Ljavax/microedition/khronos/egl/EGLConfig;", "eglContext", "Ljavax/microedition/khronos/egl/EGLContext;", "eglDisplay", "Ljavax/microedition/khronos/egl/EGLDisplay;", "eglSurface", "Ljavax/microedition/khronos/egl/EGLSurface;", "finished", "", "gl", "Ljavax/microedition/khronos/opengles/GL;", "glRunList", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "getGlRunList", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "setGlRunList", "(Ljava/util/concurrent/ConcurrentLinkedQueue;)V", "height", "", "isDirty", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getOnDrawCallback", "()Lkotlin/jvm/functions/Function0;", "setOnDrawCallback", "renderer", "Landroid/opengl/GLSurfaceView$Renderer;", "getRenderer", "()Landroid/opengl/GLSurfaceView$Renderer;", "setRenderer", "(Landroid/opengl/GLSurfaceView$Renderer;)V", "runNotifier", "Ljava/lang/Object;", "getRunNotifier", "()Ljava/lang/Object;", "sizeChanged", "surface", "Landroid/graphics/SurfaceTexture;", "getSurface", "()Landroid/graphics/SurfaceTexture;", "setSurface", "(Landroid/graphics/SurfaceTexture;)V", "targetFrameRate", "getTargetFrameRate", "()I", "setTargetFrameRate", "(I)V", "useMSAA", "getUseMSAA", "()Z", "setUseMSAA", "(Z)V", "width", "checkCurrent", "checkEglError", "chooseEglConfig", "createContext", "createSurface", "destroySurface", "finish", "finishGL", "getEglConfigs", "", "", "(Z)[[I", "initGL", "onWindowResize", "w", "h", "queueEvent", "clearQueueIfNotRunning", "r", "requestRender", "run", "Companion", "mapscore_release"})
public final class GLThread
extends Thread {
    @NotNull
    private final Object runNotifier;
    @NotNull
    private ConcurrentLinkedQueue<Function0<Unit>> glRunList;
    @NotNull
    private final AtomicBoolean isDirty;
    @Nullable
    private GLSurfaceView.Renderer renderer;
    @Nullable
    private SurfaceTexture surface;
    private boolean useMSAA;
    private int targetFrameRate;
    private volatile boolean finished;
    private EGL10 egl;
    private EGLDisplay eglDisplay;
    private EGLConfig eglConfig;
    private EGLContext eglContext;
    private EGLSurface eglSurface;
    private GL gl;
    private int width;
    private int height;
    private volatile boolean sizeChanged;
    @Nullable
    private Function0<Unit> onDrawCallback;
    private static final String TAG = "GLThread";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int MAX_NUM_GRAPHICS_PRE_TASKS = 16;
    private static final int[] defaultConfig;
    private static final int[] msaaConfig;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Object getRunNotifier() {
        return this.runNotifier;
    }

    @NotNull
    public final ConcurrentLinkedQueue<Function0<Unit>> getGlRunList() {
        return this.glRunList;
    }

    public final void setGlRunList(@NotNull ConcurrentLinkedQueue<Function0<Unit>> concurrentLinkedQueue) {
        Intrinsics.checkNotNullParameter(concurrentLinkedQueue, (String)"<set-?>");
        this.glRunList = concurrentLinkedQueue;
    }

    @NotNull
    public final AtomicBoolean isDirty() {
        return this.isDirty;
    }

    @Nullable
    public final GLSurfaceView.Renderer getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable GLSurfaceView.Renderer renderer) {
        this.renderer = renderer;
    }

    @Nullable
    public final SurfaceTexture getSurface() {
        return this.surface;
    }

    public final void setSurface(@Nullable SurfaceTexture surfaceTexture) {
        this.surface = surfaceTexture;
    }

    public final boolean getUseMSAA() {
        return this.useMSAA;
    }

    public final void setUseMSAA(boolean bl) {
        this.useMSAA = bl;
    }

    public final int getTargetFrameRate() {
        return this.targetFrameRate;
    }

    public final void setTargetFrameRate(int n) {
        this.targetFrameRate = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initGL();
        GL10 gl10 = (GL10)this.gl;
        GLSurfaceView.Renderer renderer = this.renderer;
        if (renderer == null) {
            throw (Throwable)new IllegalStateException("No renderer attached to GlTextureView");
        }
        GLSurfaceView.Renderer renderer2 = renderer;
        renderer2.onSurfaceCreated(gl10, this.eglConfig);
        while (!this.finished) {
            long timestampStartRender = System.nanoTime();
            this.checkCurrent();
            if (this.sizeChanged) {
                this.createSurface();
                renderer2.onSurfaceChanged(gl10, this.width, this.height);
                this.sizeChanged = false;
            }
            int i = 0;
            while (true) {
                Collection collection = this.glRunList;
                boolean bl = false;
                if (!(!collection.isEmpty()) || i >= 16) break;
                Function0<Unit> function0 = this.glRunList.poll();
                if (function0 != null) {
                    Unit cfr_ignored_0 = (Unit)function0.invoke();
                }
                ++i;
            }
            long renderStart = System.nanoTime();
            renderer2.onDrawFrame(gl10);
            if (this.surface != null) {
                EGL10 eGL10 = this.egl;
                if (eGL10 == null || !eGL10.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
                    throw (Throwable)new RuntimeException("Cannot swap buffers");
                }
            }
            Function0<Unit> function0 = this.onDrawCallback;
            if (function0 != null) {
                Unit cfr_ignored_1 = (Unit)function0.invoke();
            }
            if (this.targetFrameRate > 0) {
                long renderTime = (System.nanoTime() - timestampStartRender) / (long)1000000;
                try {
                    long l = 0L;
                    int n = 1000;
                    int n2 = this.targetFrameRate;
                    boolean bl = false;
                    long l2 = (long)(1000 / Math.min(n, n2)) - renderTime;
                    bl = false;
                    long sleepTime = Math.max(l, l2);
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isDirty.get()) {
                try {
                    Object renderTime = this.runNotifier;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (renderTime) {
                        boolean bl3 = false;
                        this.runNotifier.wait(1000L);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!this.glRunList.isEmpty()) continue;
            this.isDirty.set(false);
        }
        this.finishGL();
    }

    private final void destroySurface() {
        if (this.eglSurface != null && this.eglSurface != EGL10.EGL_NO_SURFACE) {
            EGL10 eGL10 = this.egl;
            if (eGL10 != null) {
                eGL10.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            }
            EGL10 eGL102 = this.egl;
            if (eGL102 != null) {
                eGL102.eglDestroySurface(this.eglDisplay, this.eglSurface);
            }
            this.eglSurface = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean createSurface() {
        block13: {
            Object object;
            StringBuilder stringBuilder;
            Object object2;
            block15: {
                block14: {
                    void it;
                    EGLSurface eGLSurface;
                    Object object3;
                    if (this.egl == null) {
                        throw (Throwable)new RuntimeException("egl not initialized");
                    }
                    if (this.eglDisplay == null) {
                        throw (Throwable)new RuntimeException("eglDisplay not initialized");
                    }
                    if (this.eglConfig == null) {
                        throw (Throwable)new RuntimeException("eglConfig not initialized");
                    }
                    this.destroySurface();
                    if (this.surface != null) {
                        object3 = this;
                        try {
                            GLThread gLThread = object3;
                            EGL10 eGL10 = this.egl;
                            eGLSurface = eGL10 != null ? eGL10.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)this.surface, null) : null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            void e;
                            GLThread gLThread = object3;
                            Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)((Throwable)e));
                            return false;
                        }
                        gLThread.eglSurface = eGLSurface;
                    } else {
                        int[] surfAttr = new int[]{12375, this.width, 12374, this.height, 12344};
                        EGL10 eGL10 = this.egl;
                        EGLSurface eGLSurface2 = this.eglSurface = eGL10 != null ? eGL10.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, surfAttr) : null;
                    }
                    if (this.eglSurface == null || this.eglSurface == EGL10.EGL_NO_SURFACE) {
                        EGL10 eGL10 = this.egl;
                        Intrinsics.checkNotNull((Object)eGL10);
                        int error = eGL10.eglGetError();
                        if (error == 12299) {
                            Log.e((String)TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                        }
                        return false;
                    }
                    EGL10 eGL10 = this.egl;
                    if (eGL10 != null && eGL10.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) break block13;
                    object2 = TAG;
                    stringBuilder = new StringBuilder().append("eglMakeCurrent failed ");
                    object = this.egl;
                    if (object == null) break block14;
                    eGLSurface = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    EGLSurface eGLSurface3 = eGLSurface;
                    StringBuilder stringBuilder2 = stringBuilder;
                    object3 = object2;
                    boolean bl3 = false;
                    String string = GLUtils.getEGLErrorString((int)it.eglGetError());
                    object2 = object3;
                    stringBuilder = stringBuilder2;
                    object = string;
                    if (object != null) break block15;
                }
                object = " - egl is null";
            }
            Log.e((String)object2, (String)stringBuilder.append((String)object).toString());
            return false;
        }
        return true;
    }

    private final void checkCurrent() {
        EGL10 eGL10 = this.egl;
        if (eGL10 == null) {
            throw (Throwable)new IllegalStateException("EGL is null");
        }
        EGL10 egl = eGL10;
        if (Intrinsics.areEqual((Object)this.eglContext, (Object)egl.eglGetCurrentContext()) ^ true || Intrinsics.areEqual((Object)this.eglSurface, (Object)egl.eglGetCurrentSurface(12377)) ^ true) {
            this.checkEglError();
            if (!egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                throw (Throwable)new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
            }
            this.checkEglError();
        }
    }

    private final void checkEglError() {
        EGL10 eGL10 = this.egl;
        if (eGL10 == null) {
            throw (Throwable)new IllegalStateException("CheckEglError: EGL is null");
        }
        EGL10 egl = eGL10;
        int error = egl.eglGetError();
        if (error != 12288) {
            Log.e((String)"PanTextureView", (String)("EGL error = 0x" + Integer.toHexString(error)));
        }
    }

    private final void finishGL() {
        block3: {
            EGL10 eGL10 = this.egl;
            if (eGL10 != null) {
                eGL10.eglDestroyContext(this.eglDisplay, this.eglContext);
            }
            EGL10 eGL102 = this.egl;
            if (eGL102 != null) {
                eGL102.eglTerminate(this.eglDisplay);
            }
            EGL10 eGL103 = this.egl;
            if (eGL103 != null) {
                eGL103.eglDestroySurface(this.eglDisplay, this.eglSurface);
            }
            SurfaceTexture surfaceTexture = this.surface;
            if (surfaceTexture == null) break block3;
            surfaceTexture.release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initGL() {
        EGLContext eGLContext;
        EGL10 egl;
        EGL eGL = EGLContext.getEGL();
        if (eGL == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
        }
        this.egl = egl = (EGL10)eGL;
        this.eglDisplay = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw (Throwable)new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
        }
        int[] version = new int[2];
        if (!egl.eglInitialize(this.eglDisplay, version)) {
            throw (Throwable)new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
        }
        this.eglConfig = this.chooseEglConfig(egl);
        if (this.eglConfig == null) {
            throw (Throwable)new RuntimeException("eglConfig not initialized");
        }
        GLThread gLThread = this;
        EGLContext eGLContext2 = this.createContext(egl, this.eglDisplay, this.eglConfig);
        if (eGLContext2 != null) {
            void it;
            EGLContext eGLContext3 = eGLContext2;
            boolean bl = false;
            boolean bl2 = false;
            EGLContext eGLContext4 = eGLContext3;
            GLThread gLThread2 = gLThread;
            boolean bl3 = false;
            this.gl = it.getGL();
            Unit unit = Unit.INSTANCE;
            gLThread = gLThread2;
            eGLContext = eGLContext3;
        } else {
            eGLContext = null;
        }
        gLThread.eglContext = eGLContext;
        this.createSurface();
        if (!egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
            throw (Throwable)new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
        }
    }

    @Nullable
    public final EGLContext createContext(@NotNull EGL10 egl, @Nullable EGLDisplay eglDisplay, @Nullable EGLConfig eglConfig) {
        Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
        int[] attrib_list = new int[]{12440, 2, 12344};
        return egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
    }

    private final EGLConfig chooseEglConfig(EGL10 egl) {
        EGLConfig config = null;
        for (int[] configSpec : this.getEglConfigs(this.useMSAA)) {
            int[] configsCount = new int[1];
            EGLConfig[] configs = new EGLConfig[1];
            egl.eglChooseConfig(this.eglDisplay, configSpec, configs, 1, configsCount);
            if (configsCount[0] > 0) {
                config = configs[0];
                break;
            }
            Log.e((String)TAG, (String)("iterative eglChooseConfig step failed " + GLUtils.getEGLErrorString((int)egl.eglGetError())));
        }
        return config;
    }

    private final int[][] getEglConfigs(boolean useMSAA) {
        return useMSAA ? (int[][])new int[][]{msaaConfig, defaultConfig} : (int[][])new int[][]{defaultConfig};
    }

    static /* synthetic */ int[][] getEglConfigs$default(GLThread gLThread, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gLThread.getEglConfigs(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish() {
        this.finished = true;
        Object object = this.runNotifier;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.runNotifier.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void queueEvent(boolean clearQueueIfNotRunning, @NotNull Function0<Unit> r) {
        Intrinsics.checkNotNullParameter(r, (String)"r");
        if (clearQueueIfNotRunning && !this.isAlive()) {
            this.glRunList.clear();
        } else {
            this.glRunList.add(r);
            this.requestRender();
        }
    }

    public static /* synthetic */ void queueEvent$default(GLThread gLThread, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        gLThread.queueEvent(bl, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestRender() {
        this.isDirty.set(true);
        Object object = this.runNotifier;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.runNotifier.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final synchronized void onWindowResize(int w, int h) {
        this.width = w;
        this.height = h;
        this.sizeChanged = true;
    }

    @Nullable
    public final Function0<Unit> getOnDrawCallback() {
        return this.onDrawCallback;
    }

    public final void setOnDrawCallback(@Nullable Function0<Unit> function0) {
        this.onDrawCallback = function0;
    }

    public GLThread(@Nullable Function0<Unit> onDrawCallback) {
        super(TAG);
        this.onDrawCallback = onDrawCallback;
        this.runNotifier = new Object();
        this.glRunList = new ConcurrentLinkedQueue();
        this.isDirty = new AtomicBoolean(false);
        this.targetFrameRate = -1;
        this.sizeChanged = true;
    }

    public /* synthetic */ GLThread(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        this((Function0<Unit>)function0);
    }

    public GLThread() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        defaultConfig = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 8, 12344};
        msaaConfig = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 8, 12338, 1, 12337, 4, 12344};
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/openmobilemaps/mapscore/graphics/GLThread$Companion;", "", "()V", "EGL_CONTEXT_CLIENT_VERSION", "", "EGL_OPENGL_ES2_BIT", "MAX_NUM_GRAPHICS_PRE_TASKS", "TAG", "", "defaultConfig", "", "msaaConfig", "mapscore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

