/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.map.util;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.util.Log;
import io.openmobilemaps.mapscore.map.util.SaveFrameCallback;
import io.openmobilemaps.mapscore.map.util.SaveFrameSpec;
import io.openmobilemaps.mapscore.map.util.SaveFrameUtil$WhenMappings;
import io.openmobilemaps.mapscore.shared.graphics.common.Vec2I;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/openmobilemaps/mapscore/map/util/SaveFrameUtil;", "", "()V", "saveCurrentFrame", "", "screenSizePx", "Lio/openmobilemaps/mapscore/shared/graphics/common/Vec2I;", "spec", "Lio/openmobilemaps/mapscore/map/util/SaveFrameSpec;", "callback", "Lio/openmobilemaps/mapscore/map/util/SaveFrameCallback;", "mapscore_release"})
public final class SaveFrameUtil {
    @NotNull
    public static final SaveFrameUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void saveCurrentFrame(@NotNull Vec2I screenSizePx, @NotNull SaveFrameSpec spec, @NotNull SaveFrameCallback callback) {
        Intrinsics.checkNotNullParameter((Object)screenSizePx, (String)"screenSizePx");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            Bitmap bitmap;
            int left = (int)(spec.getCropLeftPc() * (float)screenSizePx.getX());
            int right = (int)((1.0f - spec.getCropRightPc()) * (float)screenSizePx.getX());
            int top = (int)((1.0f - spec.getCropTopPc()) * (float)screenSizePx.getY());
            int bottom = (int)(spec.getCropBottomPc() * (float)screenSizePx.getY());
            int width = right - left;
            int height = top - bottom;
            int screenshotSize = width * height;
            ByteBuffer bb = ByteBuffer.allocateDirect(screenshotSize * 4);
            bb.order(ByteOrder.nativeOrder());
            GLES20.glReadPixels((int)left, (int)bottom, (int)width, (int)height, (int)6408, (int)5121, (Buffer)bb);
            switch (SaveFrameUtil$WhenMappings.$EnumSwitchMapping$0[spec.getPixelFormat().ordinal()]) {
                case 1: {
                    int[] pixelsBuffer = new int[screenshotSize];
                    bb.asIntBuffer().get(pixelsBuffer);
                    Bitmap bitmap565 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                    bitmap565.setPixels(pixelsBuffer, screenshotSize - width, -width, 0, 0, width, height);
                    short[] sBuffer = new short[screenshotSize];
                    ShortBuffer sb = ShortBuffer.wrap(sBuffer);
                    bitmap565.copyPixelsToBuffer((Buffer)sb);
                    int n = 0;
                    int n2 = screenshotSize;
                    while (n < n2) {
                        void i;
                        long v = sBuffer[i];
                        sBuffer[i] = (short)((v & 0x1FL) << 11 | v & 0x7E0L | (v & 0xF800L) >> 11);
                        ++i;
                    }
                    sb.rewind();
                    bitmap565.copyPixelsFromBuffer((Buffer)sb);
                    Bitmap bitmap2 = bitmap565;
                    bitmap = bitmap2;
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap565");
                    break;
                }
                case 2: {
                    Bitmap bitmap8888 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap8888.copyPixelsFromBuffer((Buffer)bb.asIntBuffer());
                    Matrix matrix = new Matrix();
                    matrix.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
                    Bitmap bitmap3 = bitmap8888 = Bitmap.createBitmap((Bitmap)bitmap8888, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
                    bitmap = bitmap3;
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"bitmap8888");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Bitmap bitmap4 = bitmap;
            Integer n = spec.getTargetWidthPx();
            Integer n3 = spec.getTargetHeightPx();
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap4, (int)(n != null ? n : width), (int)(n3 != null ? n3 : height), (boolean)true);
            switch (SaveFrameUtil$WhenMappings.$EnumSwitchMapping$1[spec.getOutputFormat().ordinal()]) {
                case 1: {
                    callback.onResultBitmap(bitmap4);
                    return;
                }
                case 2: {
                    Bitmap bitmap5 = scaledBitmap;
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap5, (String)"scaledBitmap");
                    int size = bitmap5.getRowBytes() * scaledBitmap.getHeight();
                    ByteBuffer b = ByteBuffer.allocate(size);
                    scaledBitmap.copyPixelsToBuffer((Buffer)b);
                    b.rewind();
                    byte[] bytes = new byte[size];
                    b.get(bytes);
                    callback.onResultByteArray(bytes);
                    return;
                }
            }
            Log.e((String)INSTANCE.getClass().getCanonicalName(), (String)("Unhandled outputFormat type for saving frame: " + (Object)((Object)spec.getOutputFormat())));
            callback.onError();
        }
        catch (Exception e) {
            callback.onError();
        }
    }

    private SaveFrameUtil() {
    }

    static {
        SaveFrameUtil saveFrameUtil;
        INSTANCE = saveFrameUtil = new SaveFrameUtil();
    }
}

