/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.map.view;

import android.content.Context;
import android.content.res.Resources;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleKt;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import io.openmobilemaps.mapscore.graphics.GlTextureView;
import io.openmobilemaps.mapscore.map.scheduling.AndroidScheduler;
import io.openmobilemaps.mapscore.map.scheduling.AndroidSchedulerCallback;
import io.openmobilemaps.mapscore.map.util.MapViewInterface;
import io.openmobilemaps.mapscore.map.util.SaveFrameCallback;
import io.openmobilemaps.mapscore.map.util.SaveFrameSpec;
import io.openmobilemaps.mapscore.map.util.SaveFrameUtil;
import io.openmobilemaps.mapscore.map.view.MapView;
import io.openmobilemaps.mapscore.shared.graphics.common.Color;
import io.openmobilemaps.mapscore.shared.graphics.common.Vec2F;
import io.openmobilemaps.mapscore.shared.graphics.common.Vec2I;
import io.openmobilemaps.mapscore.shared.map.LayerInterface;
import io.openmobilemaps.mapscore.shared.map.MapCallbackInterface;
import io.openmobilemaps.mapscore.shared.map.MapCamera2dInterface;
import io.openmobilemaps.mapscore.shared.map.MapConfig;
import io.openmobilemaps.mapscore.shared.map.MapInterface;
import io.openmobilemaps.mapscore.shared.map.controls.TouchAction;
import io.openmobilemaps.mapscore.shared.map.controls.TouchEvent;
import io.openmobilemaps.mapscore.shared.map.controls.TouchHandlerInterface;
import io.openmobilemaps.mapscore.shared.map.scheduling.TaskInterface;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B%\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020#H\u0016J\u0018\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0018\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020#H\u0016J\b\u0010,\u001a\u00020!H\u0017J\u0012\u0010-\u001a\u00020!2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020!H\u0017J\b\u00101\u001a\u00020!H\u0017J\b\u00102\u001a\u00020!H\u0017J\b\u00103\u001a\u00020!H\u0017J\"\u00104\u001a\u00020!2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000bH\u0016J\u001c\u00107\u001a\u00020!2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010:\u001a\u00020\u001d2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u000e\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010A\u001a\u00020\u000eH\u0016J\b\u0010B\u001a\u00020\u0018H\u0016J\b\u0010\u0012\u001a\u00020!H\u0002J\u0016\u0010\u0012\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020HH\u0016J\u000e\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001dJ\u001a\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020\u001dH\u0016R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u0018@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lio/openmobilemaps/mapscore/map/view/MapView;", "Lio/openmobilemaps/mapscore/graphics/GlTextureView;", "Landroid/opengl/GLSurfaceView$Renderer;", "Lio/openmobilemaps/mapscore/map/scheduling/AndroidSchedulerCallback;", "Landroidx/lifecycle/LifecycleObserver;", "Lio/openmobilemaps/mapscore/map/util/MapViewInterface;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "Lio/openmobilemaps/mapscore/shared/map/MapInterface;", "mapInterface", "getMapInterface", "()Lio/openmobilemaps/mapscore/shared/map/MapInterface;", "saveFrame", "Ljava/util/concurrent/atomic/AtomicBoolean;", "saveFrameCallback", "Lio/openmobilemaps/mapscore/map/util/SaveFrameCallback;", "saveFrameSpec", "Lio/openmobilemaps/mapscore/map/util/SaveFrameSpec;", "Lio/openmobilemaps/mapscore/map/scheduling/AndroidScheduler;", "scheduler", "getScheduler", "()Lio/openmobilemaps/mapscore/map/scheduling/AndroidScheduler;", "touchDisabled", "", "touchHandler", "Lio/openmobilemaps/mapscore/shared/map/controls/TouchHandlerInterface;", "addLayer", "", "layer", "Lio/openmobilemaps/mapscore/shared/map/LayerInterface;", "getCamera", "Lio/openmobilemaps/mapscore/shared/map/MapCamera2dInterface;", "insertLayerAbove", "above", "insertLayerAt", "at", "insertLayerBelow", "below", "onDestroy", "onDrawFrame", "gl", "Ljavax/microedition/khronos/opengles/GL10;", "onPause", "onResume", "onStart", "onStop", "onSurfaceChanged", "width", "height", "onSurfaceCreated", "config", "Ljavax/microedition/khronos/egl/EGLConfig;", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "registerLifecycle", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "removeLayer", "requireMapInterface", "requireScheduler", "scheduleOnGlThread", "task", "Lio/openmobilemaps/mapscore/shared/map/scheduling/TaskInterface;", "setBackgroundColor", "color", "Lio/openmobilemaps/mapscore/shared/graphics/common/Color;", "setTouchEnabled", "enabled", "setupMap", "mapConfig", "Lio/openmobilemaps/mapscore/shared/map/MapConfig;", "useMSAA", "mapscore_release"})
public class MapView
extends GlTextureView
implements GLSurfaceView.Renderer,
AndroidSchedulerCallback,
LifecycleObserver,
MapViewInterface {
    @Nullable
    private MapInterface mapInterface;
    @Nullable
    private AndroidScheduler scheduler;
    private TouchHandlerInterface touchHandler;
    private boolean touchDisabled;
    private final AtomicBoolean saveFrame;
    private SaveFrameSpec saveFrameSpec;
    private SaveFrameCallback saveFrameCallback;

    @Nullable
    public final MapInterface getMapInterface() {
        return this.mapInterface;
    }

    @Nullable
    protected final AndroidScheduler getScheduler() {
        return this.scheduler;
    }

    public void setupMap(@NotNull MapConfig mapConfig, boolean useMSAA) {
        Intrinsics.checkNotNullParameter((Object)mapConfig, (String)"mapConfig");
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        float densityExact = resources.getDisplayMetrics().xdpi;
        this.configureGL(useMSAA);
        this.setRenderer(this);
        AndroidScheduler scheduler = new AndroidScheduler(this, null, null, null, 14, null);
        MapInterface mapInterface = MapInterface.Companion.createWithOpenGl(mapConfig, scheduler, densityExact);
        mapInterface.setCallbackHandler(new MapCallbackInterface(this, scheduler){
            final /* synthetic */ MapView this$0;
            final /* synthetic */ AndroidScheduler $scheduler;

            public void invalidate() {
                AndroidScheduler.launchCoroutine$default(this.$scheduler, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ setupMap.1 this$0;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.this$0.requestRender();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
            {
                this.this$0 = this$0;
                this.$scheduler = $captured_local_variable$1;
            }
        });
        mapInterface.setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.touchHandler = mapInterface.getTouchHandler();
        this.mapInterface = mapInterface;
        this.scheduler = scheduler;
    }

    public static /* synthetic */ void setupMap$default(MapView mapView, MapConfig mapConfig, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setupMap");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mapView.setupMap(mapConfig, bl);
    }

    public final void registerLifecycle(@NotNull Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        this.requireScheduler().setCoroutineScope((CoroutineScope)LifecycleKt.getCoroutineScope((Lifecycle)lifecycle));
        lifecycle.addObserver((LifecycleObserver)this);
    }

    public void onSurfaceCreated(@Nullable GL10 gl, @Nullable EGLConfig config) {
        this.requireMapInterface().getRenderingContext().onSurfaceCreated();
    }

    public void onSurfaceChanged(@Nullable GL10 gl, int width, int height) {
        this.requireMapInterface().setViewportSize(new Vec2I(width, height));
    }

    public void onDrawFrame(@Nullable GL10 gl) {
        MapInterface mapInterface = this.mapInterface;
        if (mapInterface != null) {
            mapInterface.drawFrame();
        }
        if (this.saveFrame.getAndSet(false)) {
            this.saveFrame();
        }
    }

    @Override
    public void scheduleOnGlThread(@NotNull TaskInterface task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        GlTextureView.queueEvent$default(this, false, (Function0)new Function0<Unit>(task){
            final /* synthetic */ TaskInterface $task;

            public final void invoke() {
                this.$task.run();
            }
            {
                this.$task = taskInterface;
                super(0);
            }
        }, 1, null);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        this.requireScheduler().resume();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        this.requireMapInterface().resume();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        this.requireMapInterface().pause();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        this.requireScheduler().pause();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.setRenderer(null);
        this.mapInterface = null;
        this.scheduler = null;
        this.touchHandler = null;
    }

    public final void setTouchEnabled(boolean enabled) {
        this.touchDisabled = !enabled;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        block9: {
            TouchAction action;
            if (event == null || this.touchDisabled) {
                return false;
            }
            switch (event.getActionMasked()) {
                case 0: 
                case 5: {
                    TouchAction touchAction = TouchAction.DOWN;
                    break;
                }
                case 2: {
                    TouchAction touchAction = TouchAction.MOVE;
                    break;
                }
                case 1: 
                case 6: {
                    TouchAction touchAction = TouchAction.UP;
                    break;
                }
                case 3: {
                    TouchAction touchAction = TouchAction.CANCEL;
                    break;
                }
                default: {
                    TouchAction touchAction = action = null;
                }
            }
            if (action == null) break block9;
            ArrayList<Vec2F> pointers = new ArrayList<Vec2F>(10);
            int n = 0;
            int n2 = event.getPointerCount();
            while (n < n2) {
                void i;
                pointers.add(new Vec2F(event.getX((int)i), event.getY((int)i)));
                ++i;
            }
            TouchHandlerInterface touchHandlerInterface = this.touchHandler;
            if (touchHandlerInterface != null) {
                touchHandlerInterface.onTouchEvent(new TouchEvent(pointers, action));
            }
        }
        return true;
    }

    @Override
    public void setBackgroundColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.requireMapInterface().setBackgroundColor(color);
    }

    @Override
    public void addLayer(@NotNull LayerInterface layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.requireMapInterface().addLayer(layer);
    }

    @Override
    public void insertLayerAt(@NotNull LayerInterface layer, int at) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.requireMapInterface().insertLayerAt(layer, at);
    }

    @Override
    public void insertLayerAbove(@NotNull LayerInterface layer, @NotNull LayerInterface above) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)above, (String)"above");
        this.requireMapInterface().insertLayerAbove(layer, above);
    }

    @Override
    public void insertLayerBelow(@NotNull LayerInterface layer, @NotNull LayerInterface below) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)below, (String)"below");
        this.requireMapInterface().insertLayerBelow(layer, below);
    }

    @Override
    public void removeLayer(@NotNull LayerInterface layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.requireMapInterface().removeLayer(layer);
    }

    @Override
    @NotNull
    public MapCamera2dInterface getCamera() {
        return this.requireMapInterface().getCamera();
    }

    public final void saveFrame(@NotNull SaveFrameSpec saveFrameSpec, @NotNull SaveFrameCallback saveFrameCallback) {
        Intrinsics.checkNotNullParameter((Object)saveFrameSpec, (String)"saveFrameSpec");
        Intrinsics.checkNotNullParameter((Object)saveFrameCallback, (String)"saveFrameCallback");
        this.saveFrameSpec = saveFrameSpec;
        this.saveFrameCallback = saveFrameCallback;
        this.saveFrame.set(true);
        this.invalidate();
    }

    private final void saveFrame() {
        SaveFrameCallback saveFrameCallback = this.saveFrameCallback;
        if (saveFrameCallback == null) {
            return;
        }
        SaveFrameCallback callback = saveFrameCallback;
        SaveFrameSpec saveFrameSpec = this.saveFrameSpec;
        if (saveFrameSpec == null) {
            return;
        }
        SaveFrameSpec spec = saveFrameSpec;
        this.saveFrameCallback = null;
        this.saveFrameSpec = null;
        SaveFrameUtil.INSTANCE.saveCurrentFrame(new Vec2I(this.getWidth(), this.getHeight()), spec, callback);
    }

    @Override
    @NotNull
    public MapInterface requireMapInterface() {
        MapInterface mapInterface = this.mapInterface;
        if (mapInterface == null) {
            throw (Throwable)new IllegalStateException("Map is not setup or already destroyed!");
        }
        return mapInterface;
    }

    @Override
    @NotNull
    public AndroidScheduler requireScheduler() {
        AndroidScheduler androidScheduler = this.scheduler;
        if (androidScheduler == null) {
            throw (Throwable)new IllegalStateException("Map is not setup or already destroyed!");
        }
        return androidScheduler;
    }

    @JvmOverloads
    public MapView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.saveFrame = new AtomicBoolean(false);
    }

    public /* synthetic */ MapView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MapView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public MapView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

