/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.graphics;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0002,-B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010$\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010&\u001a\u00020\u000e2\b\b\u0002\u0010'\u001a\u00020\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010)\u001a\u00020\u000eJ\u000e\u0010*\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\bJ\u0010\u0010+\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0018\u00010\u0014R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/openmobilemaps/mapscore/graphics/GlTextureView;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "frameRate", "glRunList", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Function0;", "", "getGlRunList", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "setGlRunList", "(Ljava/util/concurrent/ConcurrentLinkedQueue;)V", "glThread", "Lio/openmobilemaps/mapscore/graphics/GlTextureView$GLThread;", "isDirty", "Ljava/util/concurrent/atomic/AtomicBoolean;", "renderer", "Landroid/opengl/GLSurfaceView$Renderer;", "runNotifier", "Ljava/lang/Object;", "useMSAA", "", "configureGL", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "queueEvent", "clearQueueIfNotRunning", "r", "requestRender", "setRenderFrameRate", "setRenderer", "Companion", "GLThread", "mapscore_release"})
public class GlTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private GLThread glThread;
    private GLSurfaceView.Renderer renderer;
    private boolean useMSAA;
    @NotNull
    private ConcurrentLinkedQueue<Function0<Unit>> glRunList;
    private final Object runNotifier;
    private final AtomicBoolean isDirty;
    private int frameRate;
    private static final String TAG = "GLTextureView";
    public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int MAX_NUM_GRAPHICS_PRE_TASKS = 16;
    private static final int[] defaultConfig;
    private static final int[] msaaConfig;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ConcurrentLinkedQueue<Function0<Unit>> getGlRunList() {
        return this.glRunList;
    }

    public final void setGlRunList(@NotNull ConcurrentLinkedQueue<Function0<Unit>> concurrentLinkedQueue) {
        Intrinsics.checkNotNullParameter(concurrentLinkedQueue, (String)"<set-?>");
        this.glRunList = concurrentLinkedQueue;
    }

    /*
     * WARNING - void declaration
     */
    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int width, int height) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        GLThread gLThread = new GLThread(this, surface, this.useMSAA);
        boolean bl = false;
        boolean bl2 = false;
        GLThread gLThread2 = gLThread;
        GlTextureView glTextureView = this;
        boolean bl3 = false;
        $this$apply.start();
        Unit unit = Unit.INSTANCE;
        glTextureView.glThread = gLThread;
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            GLThread gLThread = this.glThread;
            if (gLThread == null) break block0;
            gLThread.onWindowResize(width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            GLThread gLThread = this.glThread;
            if (gLThread == null) break block0;
            gLThread.finish();
        }
        return false;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }

    public final void setRenderer(@Nullable GLSurfaceView.Renderer renderer) {
        this.renderer = renderer;
    }

    public final void configureGL(boolean useMSAA) {
        this.useMSAA = useMSAA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestRender() {
        this.isDirty.set(true);
        Object object = this.runNotifier;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.runNotifier.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void queueEvent(boolean clearQueueIfNotRunning, @NotNull Function0<Unit> r) {
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter(r, (String)"r");
                if (!clearQueueIfNotRunning) break block2;
                if (this.glThread == null) break block3;
                GLThread gLThread = this.glThread;
                if (gLThread != null && gLThread.isAlive()) break block2;
            }
            this.glRunList.clear();
            return;
        }
        this.glRunList.add(r);
        this.requestRender();
    }

    public static /* synthetic */ void queueEvent$default(GlTextureView glTextureView, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queueEvent");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        glTextureView.queueEvent(bl, (Function0<Unit>)function0);
    }

    public final void setRenderFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    @JvmOverloads
    public GlTextureView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.setSurfaceTextureListener(this);
        this.glRunList = new ConcurrentLinkedQueue();
        this.runNotifier = new Object();
        this.isDirty = new AtomicBoolean(false);
        this.frameRate = -1;
    }

    public /* synthetic */ GlTextureView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public GlTextureView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GlTextureView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        defaultConfig = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 8, 12344};
        msaaConfig = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 16, 12326, 8, 12338, 1, 12337, 4, 12344};
    }

    public static final /* synthetic */ void access$setRenderer$p(GlTextureView $this, GLSurfaceView.Renderer renderer) {
        $this.renderer = renderer;
    }

    public static final /* synthetic */ void access$setFrameRate$p(GlTextureView $this, int n) {
        $this.frameRate = n;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u001bH\u0002J\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u001bH\u0002J\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001bH\u0002J\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015J\b\u0010+\u001a\u00020\u001bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/openmobilemaps/mapscore/graphics/GlTextureView$GLThread;", "Ljava/lang/Thread;", "surface", "Landroid/graphics/SurfaceTexture;", "useMSAA", "", "(Lio/openmobilemaps/mapscore/graphics/GlTextureView;Landroid/graphics/SurfaceTexture;Z)V", "egl", "Ljavax/microedition/khronos/egl/EGL10;", "eglConfig", "Ljavax/microedition/khronos/egl/EGLConfig;", "eglContext", "Ljavax/microedition/khronos/egl/EGLContext;", "eglDisplay", "Ljavax/microedition/khronos/egl/EGLDisplay;", "eglSurface", "Ljavax/microedition/khronos/egl/EGLSurface;", "finished", "gl", "Ljavax/microedition/khronos/opengles/GL;", "height", "", "sizeChanged", "getUseMSAA", "()Z", "width", "checkCurrent", "", "checkEglError", "chooseEglConfig", "createContext", "createSurface", "destroySurface", "finish", "finishGL", "getEglConfigs", "", "", "(Z)[[I", "initGL", "onWindowResize", "w", "h", "run", "mapscore_release"})
    private final class GLThread
    extends Thread {
        private volatile boolean finished;
        private EGL10 egl;
        private EGLDisplay eglDisplay;
        private EGLConfig eglConfig;
        private EGLContext eglContext;
        private EGLSurface eglSurface;
        private GL gl;
        private int width;
        private int height;
        private volatile boolean sizeChanged;
        private final SurfaceTexture surface;
        private final boolean useMSAA;
        final /* synthetic */ GlTextureView this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.initGL();
            GL10 gl10 = (GL10)this.gl;
            GLSurfaceView.Renderer renderer = this.this$0.renderer;
            if (renderer == null) {
                throw (Throwable)new IllegalStateException("No renderer attached to GlTextureView");
            }
            GLSurfaceView.Renderer renderer2 = renderer;
            renderer2.onSurfaceCreated(gl10, this.eglConfig);
            while (!this.finished) {
                long timestampStartRender = System.nanoTime();
                this.checkCurrent();
                if (this.sizeChanged) {
                    this.createSurface();
                    renderer2.onSurfaceChanged(gl10, this.width, this.height);
                    this.sizeChanged = false;
                }
                int i = 0;
                while (true) {
                    Collection collection = this.this$0.getGlRunList();
                    boolean bl = false;
                    if (!(!collection.isEmpty()) || i >= 16) break;
                    Function0<Unit> function0 = this.this$0.getGlRunList().poll();
                    if (function0 != null) {
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                    ++i;
                }
                long renderStart = System.nanoTime();
                renderer2.onDrawFrame(gl10);
                EGL10 eGL10 = this.egl;
                if (eGL10 == null || !eGL10.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
                    throw (Throwable)new RuntimeException("Cannot swap buffers");
                }
                if (this.this$0.frameRate > 0) {
                    long renderTime = (System.nanoTime() - timestampStartRender) / (long)1000000;
                    try {
                        long sleepTime = Math.max(0L, (long)(1000 / Math.min(1000, this.this$0.frameRate)) - renderTime);
                        if (sleepTime > 0L) {
                            Thread.sleep(sleepTime);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.this$0.isDirty.get()) {
                    try {
                        Object renderTime = this.this$0.runNotifier;
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (renderTime) {
                            boolean bl3 = false;
                            this.this$0.runNotifier.wait(1000L);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.this$0.getGlRunList().isEmpty()) continue;
                this.this$0.isDirty.set(false);
            }
            this.finishGL();
        }

        private final void destroySurface() {
            if (this.eglSurface != null && this.eglSurface != EGL10.EGL_NO_SURFACE) {
                EGL10 eGL10 = this.egl;
                if (eGL10 != null) {
                    eGL10.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
                EGL10 eGL102 = this.egl;
                if (eGL102 != null) {
                    eGL102.eglDestroySurface(this.eglDisplay, this.eglSurface);
                }
                this.eglSurface = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean createSurface() {
            block10: {
                Object object;
                StringBuilder stringBuilder;
                Object object2;
                block12: {
                    block11: {
                        void it;
                        EGLSurface eGLSurface;
                        if (this.egl == null) {
                            throw (Throwable)new RuntimeException("egl not initialized");
                        }
                        if (this.eglDisplay == null) {
                            throw (Throwable)new RuntimeException("eglDisplay not initialized");
                        }
                        if (this.eglConfig == null) {
                            throw (Throwable)new RuntimeException("eglConfig not initialized");
                        }
                        this.destroySurface();
                        Object object3 = this;
                        try {
                            GLThread gLThread = object3;
                            EGL10 eGL10 = this.egl;
                            eGLSurface = eGL10 != null ? eGL10.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)this.surface, null) : null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            void e;
                            GLThread gLThread = object3;
                            Log.e((String)GlTextureView.TAG, (String)"eglCreateWindowSurface", (Throwable)((Throwable)e));
                            return false;
                        }
                        gLThread.eglSurface = eGLSurface;
                        if (this.eglSurface == null || this.eglSurface == EGL10.EGL_NO_SURFACE) {
                            EGL10 eGL10 = this.egl;
                            Intrinsics.checkNotNull((Object)eGL10);
                            int error = eGL10.eglGetError();
                            if (error == 12299) {
                                Log.e((String)GlTextureView.TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                            }
                            return false;
                        }
                        EGL10 eGL10 = this.egl;
                        if (eGL10 != null && eGL10.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) break block10;
                        object2 = GlTextureView.TAG;
                        stringBuilder = new StringBuilder().append("eglMakeCurrent failed ");
                        object = this.egl;
                        if (object == null) break block11;
                        eGLSurface = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        EGLSurface eGLSurface2 = eGLSurface;
                        StringBuilder stringBuilder2 = stringBuilder;
                        object3 = object2;
                        boolean bl3 = false;
                        String string = GLUtils.getEGLErrorString((int)it.eglGetError());
                        object2 = object3;
                        stringBuilder = stringBuilder2;
                        object = string;
                        if (object != null) break block12;
                    }
                    object = " - egl is null";
                }
                Log.e((String)object2, (String)stringBuilder.append((String)object).toString());
                return false;
            }
            return true;
        }

        private final void checkCurrent() {
            EGL10 eGL10 = this.egl;
            if (eGL10 == null) {
                throw (Throwable)new IllegalStateException("EGL is null");
            }
            EGL10 egl = eGL10;
            if (Intrinsics.areEqual((Object)this.eglContext, (Object)egl.eglGetCurrentContext()) ^ true || Intrinsics.areEqual((Object)this.eglSurface, (Object)egl.eglGetCurrentSurface(12377)) ^ true) {
                this.checkEglError();
                if (!egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                    throw (Throwable)new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
                }
                this.checkEglError();
            }
        }

        private final void checkEglError() {
            EGL10 eGL10 = this.egl;
            if (eGL10 == null) {
                throw (Throwable)new IllegalStateException("CheckEglError: EGL is null");
            }
            EGL10 egl = eGL10;
            int error = egl.eglGetError();
            if (error != 12288) {
                Log.e((String)"PanTextureView", (String)("EGL error = 0x" + Integer.toHexString(error)));
            }
        }

        private final void finishGL() {
            block2: {
                EGL10 eGL10 = this.egl;
                if (eGL10 != null) {
                    eGL10.eglDestroyContext(this.eglDisplay, this.eglContext);
                }
                EGL10 eGL102 = this.egl;
                if (eGL102 != null) {
                    eGL102.eglTerminate(this.eglDisplay);
                }
                EGL10 eGL103 = this.egl;
                if (eGL103 == null) break block2;
                eGL103.eglDestroySurface(this.eglDisplay, this.eglSurface);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void initGL() {
            EGLContext eGLContext;
            EGL10 egl;
            EGL eGL = EGLContext.getEGL();
            if (eGL == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
            }
            this.egl = egl = (EGL10)eGL;
            this.eglDisplay = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw (Throwable)new RuntimeException("eglGetDisplay failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
            }
            int[] version = new int[2];
            if (!egl.eglInitialize(this.eglDisplay, version)) {
                throw (Throwable)new RuntimeException("eglInitialize failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
            }
            this.eglConfig = this.chooseEglConfig(egl);
            if (this.eglConfig == null) {
                throw (Throwable)new RuntimeException("eglConfig not initialized");
            }
            GLThread gLThread = this;
            EGLContext eGLContext2 = this.createContext(egl, this.eglDisplay, this.eglConfig);
            if (eGLContext2 != null) {
                void it;
                EGLContext eGLContext3 = eGLContext2;
                boolean bl = false;
                boolean bl2 = false;
                EGLContext eGLContext4 = eGLContext3;
                GLThread gLThread2 = gLThread;
                boolean bl3 = false;
                this.gl = it.getGL();
                Unit unit = Unit.INSTANCE;
                gLThread = gLThread2;
                eGLContext = eGLContext3;
            } else {
                eGLContext = null;
            }
            gLThread.eglContext = eGLContext;
            this.createSurface();
            if (!egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                throw (Throwable)new RuntimeException("eglMakeCurrent failed " + GLUtils.getEGLErrorString((int)egl.eglGetError()));
            }
        }

        @Nullable
        public final EGLContext createContext(@NotNull EGL10 egl, @Nullable EGLDisplay eglDisplay, @Nullable EGLConfig eglConfig) {
            Intrinsics.checkNotNullParameter((Object)egl, (String)"egl");
            int[] attrib_list = new int[]{12440, 2, 12344};
            return egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
        }

        private final EGLConfig chooseEglConfig(EGL10 egl) {
            EGLConfig config = null;
            for (int[] configSpec : this.getEglConfigs(this.useMSAA)) {
                int[] configsCount = new int[1];
                EGLConfig[] configs = new EGLConfig[1];
                egl.eglChooseConfig(this.eglDisplay, configSpec, configs, 1, configsCount);
                Log.e((String)GlTextureView.TAG, (String)("eglChooseConfig failed " + GLUtils.getEGLErrorString((int)egl.eglGetError())));
                if (configsCount[0] <= 0) continue;
                config = configs[0];
                break;
            }
            return config;
        }

        private final int[][] getEglConfigs(boolean useMSAA) {
            return useMSAA ? (int[][])new int[][]{msaaConfig, defaultConfig} : (int[][])new int[][]{defaultConfig};
        }

        static /* synthetic */ int[][] getEglConfigs$default(GLThread gLThread, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return gLThread.getEglConfigs(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void finish() {
            this.finished = true;
            Object object = this.this$0.runNotifier;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.this$0.runNotifier.notify();
                Unit unit = Unit.INSTANCE;
            }
        }

        public final synchronized void onWindowResize(int w, int h) {
            this.width = w;
            this.height = h;
            this.sizeChanged = true;
        }

        public final boolean getUseMSAA() {
            return this.useMSAA;
        }

        public GLThread(@NotNull GlTextureView this$0, SurfaceTexture surface, boolean useMSAA) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            this.this$0 = this$0;
            super("GLThread");
            this.surface = surface;
            this.useMSAA = useMSAA;
            this.width = this$0.getWidth();
            this.height = this$0.getHeight();
            this.sizeChanged = true;
        }

        public /* synthetic */ GLThread(GlTextureView glTextureView, SurfaceTexture surfaceTexture, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(glTextureView, surfaceTexture, bl);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/openmobilemaps/mapscore/graphics/GlTextureView$Companion;", "", "()V", "EGL_CONTEXT_CLIENT_VERSION", "", "EGL_OPENGL_ES2_BIT", "MAX_NUM_GRAPHICS_PRE_TASKS", "TAG", "", "defaultConfig", "", "msaaConfig", "mapscore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

