/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.map.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.openmobilemaps.mapscore.graphics.BitmapTextureHolder;
import io.openmobilemaps.mapscore.graphics.VectorTileHolder;
import io.openmobilemaps.mapscore.map.loader.networking.RefererInterceptor;
import io.openmobilemaps.mapscore.map.loader.networking.RequestUtils;
import io.openmobilemaps.mapscore.map.loader.networking.UserAgentInterceptor;
import io.openmobilemaps.mapscore.shared.map.loader.LoaderStatus;
import io.openmobilemaps.mapscore.shared.map.loader.TextureLoaderResult;
import io.openmobilemaps.mapscore.shared.map.loader.TileLoaderInterface;
import io.openmobilemaps.mapscore.shared.map.loader.VectorTileLoaderResult;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/openmobilemaps/mapscore/map/loader/TileLoader;", "Lio/openmobilemaps/mapscore/shared/map/loader/TileLoaderInterface;", "context", "Landroid/content/Context;", "cacheDirectory", "Ljava/io/File;", "cacheSize", "", "referer", "", "userAgent", "(Landroid/content/Context;Ljava/io/File;JLjava/lang/String;Ljava/lang/String;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "loadTexture", "Lio/openmobilemaps/mapscore/shared/map/loader/TextureLoaderResult;", "url", "loadVectorTile", "Lio/openmobilemaps/mapscore/shared/map/loader/VectorTileLoaderResult;", "mapscore_release"})
public final class TileLoader
extends TileLoaderInterface {
    private final OkHttpClient okHttpClient;
    private final Context context;
    private final File cacheDirectory;
    private final long cacheSize;
    private final String referer;
    private final String userAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextureLoaderResult loadTexture(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        try {
            TextureLoaderResult textureLoaderResult;
            Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                TextureLoaderResult textureLoaderResult2;
                byte[] bytes;
                Response response = (Response)closeable;
                boolean bl3 = false;
                ResponseBody responseBody = response.body();
                Object object = bytes = (Object)(responseBody != null ? responseBody.bytes() : null);
                if (response.isSuccessful() && bytes != null) {
                    Bitmap bitmap;
                    Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                    textureLoaderResult2 = new TextureLoaderResult(new BitmapTextureHolder(bitmap2), LoaderStatus.OK);
                } else {
                    textureLoaderResult2 = response.code() == 404 ? new TextureLoaderResult(null, LoaderStatus.ERROR_404) : new TextureLoaderResult(null, LoaderStatus.ERROR_OTHER);
                }
                textureLoaderResult = textureLoaderResult2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return textureLoaderResult;
        }
        catch (Exception e) {
            return new TextureLoaderResult(null, LoaderStatus.ERROR_NETWORK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public VectorTileLoaderResult loadVectorTile(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        try {
            VectorTileLoaderResult vectorTileLoaderResult;
            Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] bytes;
                Response response = (Response)closeable;
                boolean bl3 = false;
                ResponseBody responseBody = response.body();
                Object object = bytes = (Object)(responseBody != null ? responseBody.bytes() : null);
                vectorTileLoaderResult = response.isSuccessful() && bytes != null ? new VectorTileLoaderResult(new VectorTileHolder(bytes), LoaderStatus.OK) : (response.code() == 404 ? new VectorTileLoaderResult(null, LoaderStatus.ERROR_404) : new VectorTileLoaderResult(null, LoaderStatus.ERROR_OTHER));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return vectorTileLoaderResult;
        }
        catch (Exception e) {
            return new VectorTileLoaderResult(null, LoaderStatus.ERROR_NETWORK);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TileLoader(@NotNull Context context, @NotNull File cacheDirectory, long cacheSize, @NotNull String referer, @Nullable String userAgent) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)referer, (String)"referer");
        this.context = context;
        this.cacheDirectory = cacheDirectory;
        this.cacheSize = cacheSize;
        this.referer = referer;
        this.userAgent = userAgent;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        String string = this.userAgent;
        if (string == null) {
            string = RequestUtils.INSTANCE.getDefaultUserAgent(this.context);
        }
        Dispatcher dispatcher = new Dispatcher();
        boolean bl = false;
        boolean bl2 = false;
        Dispatcher dispatcher2 = dispatcher;
        OkHttpClient.Builder builder2 = builder.addInterceptor((Interceptor)new UserAgentInterceptor(string)).addInterceptor((Interceptor)new RefererInterceptor(this.referer)).connectionPool(new ConnectionPool(8, 5000L, TimeUnit.MILLISECONDS)).cache(new Cache(this.cacheDirectory, this.cacheSize));
        TileLoader tileLoader = this;
        boolean bl3 = false;
        $this$apply.setMaxRequestsPerHost(8);
        Unit unit = Unit.INSTANCE;
        tileLoader.okHttpClient = builder2.dispatcher(dispatcher).readTimeout(20L, TimeUnit.SECONDS).build();
    }

    public /* synthetic */ TileLoader(Context context, File file, long l, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(context, file, l, string, string2);
    }
}

