/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.map.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.openmobilemaps.mapscore.graphics.BitmapTextureHolder;
import io.openmobilemaps.mapscore.graphics.DataHolder;
import io.openmobilemaps.mapscore.map.loader.networking.RefererInterceptor;
import io.openmobilemaps.mapscore.map.loader.networking.RequestUtils;
import io.openmobilemaps.mapscore.map.loader.networking.UserAgentInterceptor;
import io.openmobilemaps.mapscore.shared.map.loader.DataLoaderResult;
import io.openmobilemaps.mapscore.shared.map.loader.LoaderInterface;
import io.openmobilemaps.mapscore.shared.map.loader.LoaderStatus;
import io.openmobilemaps.mapscore.shared.map.loader.TextureLoaderResult;
import java.io.Closeable;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ;\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\rH\u0014J\b\u0010\u0012\u001a\u00020\rH\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/openmobilemaps/mapscore/map/loader/DataLoader;", "Lio/openmobilemaps/mapscore/shared/map/loader/LoaderInterface;", "context", "Landroid/content/Context;", "cacheDirectory", "Ljava/io/File;", "cacheSize", "", "referrer", "", "userAgent", "(Landroid/content/Context;Ljava/io/File;JLjava/lang/String;Ljava/lang/String;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "adjustClientSettings", "", "(Ljava/io/File;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)V", "createClient", "initializeClient", "loadData", "Lio/openmobilemaps/mapscore/shared/map/loader/DataLoaderResult;", "url", "etag", "loadTexture", "Lio/openmobilemaps/mapscore/shared/map/loader/TextureLoaderResult;", "Companion", "mapscore_release"})
public class DataLoader
extends LoaderInterface {
    private OkHttpClient okHttpClient;
    private final Context context;
    private File cacheDirectory;
    private long cacheSize;
    private String referrer;
    private String userAgent;
    private static final String HEADER_NAME_ETAG = "etag";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected OkHttpClient createClient() {
        void $this$apply;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        String string = this.userAgent;
        if (string == null) {
            string = RequestUtils.INSTANCE.getDefaultUserAgent(this.context);
        }
        Dispatcher dispatcher = new Dispatcher();
        boolean bl = false;
        boolean bl2 = false;
        Dispatcher dispatcher2 = dispatcher;
        OkHttpClient.Builder builder2 = builder.addInterceptor((Interceptor)new UserAgentInterceptor(string)).addInterceptor((Interceptor)new RefererInterceptor(this.referrer)).connectionPool(new ConnectionPool(8, 5000L, TimeUnit.MILLISECONDS)).cache(new Cache(this.cacheDirectory, this.cacheSize));
        boolean bl3 = false;
        $this$apply.setMaxRequestsPerHost(8);
        Unit unit = Unit.INSTANCE;
        return builder2.dispatcher(dispatcher).readTimeout(20L, TimeUnit.SECONDS).build();
    }

    public final void adjustClientSettings(@Nullable File cacheDirectory, @Nullable Long cacheSize, @Nullable String referrer, @Nullable String userAgent) {
        boolean bl;
        boolean bl2;
        Object object;
        File file = cacheDirectory;
        if (file != null) {
            object = file;
            bl2 = false;
            bl = false;
            Comparable<File> it = object;
            boolean bl3 = false;
            this.cacheDirectory = cacheDirectory;
        }
        Long l = cacheSize;
        if (l != null) {
            object = l;
            bl2 = false;
            bl = false;
            long it = ((Number)object).longValue();
            boolean bl4 = false;
            this.cacheSize = cacheSize;
        }
        String string = referrer;
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl5 = false;
            this.referrer = it;
        }
        String string2 = userAgent;
        if (string2 != null) {
            object = string2;
            bl2 = false;
            bl = false;
            Object it = object;
            boolean bl6 = false;
            this.userAgent = it;
        }
        this.okHttpClient = this.createClient();
    }

    public static /* synthetic */ void adjustClientSettings$default(DataLoader dataLoader, File file, Long l, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: adjustClientSettings");
        }
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        dataLoader.adjustClientSettings(file, l, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TextureLoaderResult loadTexture(@NotNull String url, @Nullable String etag) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        try {
            TextureLoaderResult textureLoaderResult;
            Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                TextureLoaderResult textureLoaderResult2;
                byte[] bytes;
                Response response = (Response)closeable;
                boolean bl3 = false;
                ResponseBody responseBody = response.body();
                Object object = bytes = (Object)(responseBody != null ? responseBody.bytes() : null);
                if (response.isSuccessful() && bytes != null) {
                    Bitmap bitmap;
                    Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
                    textureLoaderResult2 = new TextureLoaderResult(new BitmapTextureHolder(bitmap2), response.header(HEADER_NAME_ETAG, null), LoaderStatus.OK);
                } else {
                    textureLoaderResult2 = response.code() == 404 ? new TextureLoaderResult(null, null, LoaderStatus.ERROR_404) : new TextureLoaderResult(null, null, LoaderStatus.ERROR_OTHER);
                }
                textureLoaderResult = textureLoaderResult2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return textureLoaderResult;
        }
        catch (Exception e) {
            return new TextureLoaderResult(null, null, LoaderStatus.ERROR_NETWORK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DataLoaderResult loadData(@NotNull String url, @Nullable String etag) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        try {
            DataLoaderResult dataLoaderResult;
            Closeable closeable = (Closeable)this.okHttpClient.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] bytes;
                Response response = (Response)closeable;
                boolean bl3 = false;
                ResponseBody responseBody = response.body();
                Object object = bytes = (Object)(responseBody != null ? responseBody.bytes() : null);
                dataLoaderResult = response.isSuccessful() && bytes != null ? new DataLoaderResult(new DataHolder(bytes), response.header(HEADER_NAME_ETAG, null), LoaderStatus.OK) : (response.code() == 404 ? new DataLoaderResult(null, null, LoaderStatus.ERROR_404) : new DataLoaderResult(null, null, LoaderStatus.ERROR_OTHER));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return dataLoaderResult;
        }
        catch (Exception e) {
            return new DataLoaderResult(null, null, LoaderStatus.ERROR_NETWORK);
        }
    }

    private final OkHttpClient initializeClient() {
        return this.createClient();
    }

    public DataLoader(@NotNull Context context, @NotNull File cacheDirectory, long cacheSize, @NotNull String referrer, @Nullable String userAgent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        this.context = context;
        this.cacheDirectory = cacheDirectory;
        this.cacheSize = cacheSize;
        this.referrer = referrer;
        this.userAgent = userAgent;
        this.okHttpClient = this.initializeClient();
    }

    public /* synthetic */ DataLoader(Context context, File file, long l, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        this(context, file, l, string, string2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/openmobilemaps/mapscore/map/loader/DataLoader$Companion;", "", "()V", "HEADER_NAME_ETAG", "", "mapscore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

