/*
 * Decompiled with CFR 0.152.
 */
package io.openmobilemaps.mapscore.shared.graphics.objects;

import io.openmobilemaps.mapscore.shared.graphics.objects.GraphicsObjectInterface;
import io.openmobilemaps.mapscore.shared.graphics.objects.TextDescription;
import io.openmobilemaps.mapscore.shared.graphics.objects.TextureHolderInterface;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0006H&J \u0010\n\u001a\u00020\u00062\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eH&\u00a8\u0006\u0010"}, d2={"Lio/openmobilemaps/mapscore/shared/graphics/objects/TextInterface;", "", "()V", "asGraphicsObject", "Lio/openmobilemaps/mapscore/shared/graphics/objects/GraphicsObjectInterface;", "loadTexture", "", "textureHolder", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextureHolderInterface;", "removeTexture", "setTexts", "texts", "Ljava/util/ArrayList;", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextDescription;", "Lkotlin/collections/ArrayList;", "CppProxy", "mapscore_release"})
public abstract class TextInterface {
    public abstract void setTexts(@NotNull ArrayList<TextDescription> var1);

    public abstract void loadTexture(@NotNull TextureHolderInterface var1);

    public abstract void removeTexture();

    @NotNull
    public abstract GraphicsObjectInterface asGraphicsObject();

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0004J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0011\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0082 J\u0011\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J\u0019\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0082 J\u0011\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0082 J)\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018H\u0082 J\b\u0010\u0019\u001a\u00020\bH\u0016J \u0010\u001a\u001a\u00020\b2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/openmobilemaps/mapscore/shared/graphics/objects/TextInterface$CppProxy;", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextInterface;", "nativeRef", "", "(J)V", "destroyed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_djinni_private_destroy", "", "asGraphicsObject", "Lio/openmobilemaps/mapscore/shared/graphics/objects/GraphicsObjectInterface;", "finalize", "loadTexture", "textureHolder", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextureHolderInterface;", "nativeDestroy", "native_asGraphicsObject", "_nativeRef", "native_loadTexture", "native_removeTexture", "native_setTexts", "texts", "Ljava/util/ArrayList;", "Lio/openmobilemaps/mapscore/shared/graphics/objects/TextDescription;", "Lkotlin/collections/ArrayList;", "removeTexture", "setTexts", "mapscore_release"})
    private static final class CppProxy
    extends TextInterface {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private final native void nativeDestroy(long var1);

        public final void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected final void finalize() {
            this._djinni_private_destroy();
        }

        @Override
        public void setTexts(@NotNull ArrayList<TextDescription> texts) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_setTexts(this.nativeRef, texts);
        }

        private final native void native_setTexts(long var1, ArrayList<TextDescription> var3);

        @Override
        public void loadTexture(@NotNull TextureHolderInterface textureHolder) {
            Intrinsics.checkNotNullParameter((Object)textureHolder, (String)"textureHolder");
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_loadTexture(this.nativeRef, textureHolder);
        }

        private final native void native_loadTexture(long var1, TextureHolderInterface var3);

        @Override
        public void removeTexture() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.native_removeTexture(this.nativeRef);
        }

        private final native void native_removeTexture(long var1);

        @Override
        @NotNull
        public GraphicsObjectInterface asGraphicsObject() {
            boolean bl = !this.destroyed.get();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "trying to use a destroyed object";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.native_asGraphicsObject(this.nativeRef);
        }

        private final native GraphicsObjectInterface native_asGraphicsObject(long var1);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                String string = "nativeRef is zero";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.nativeRef = nativeRef;
        }
    }
}

