/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.opensergo.OpenSergoSubscribeClientObserver;
import io.opensergo.log.OpenSergoLogger;
import io.opensergo.proto.transport.v1.OpenSergoUniversalTransportServiceGrpc;
import io.opensergo.proto.transport.v1.SubscribeOpType;
import io.opensergo.proto.transport.v1.SubscribeRequest;
import io.opensergo.proto.transport.v1.SubscribeRequestTarget;
import io.opensergo.proto.transport.v1.SubscribeResponse;
import io.opensergo.subscribe.OpenSergoConfigSubscriber;
import io.opensergo.subscribe.SubscribeKey;
import io.opensergo.subscribe.SubscribeRegistry;
import io.opensergo.subscribe.SubscribedConfigCache;
import io.opensergo.util.AssertUtils;
import io.opensergo.util.IdentifierUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class OpenSergoClient
implements AutoCloseable {
    private final ManagedChannel channel;
    private final OpenSergoUniversalTransportServiceGrpc.OpenSergoUniversalTransportServiceStub transportGrpcStub;
    private StreamObserver<SubscribeRequest> requestAndResponseWriter;
    private final SubscribedConfigCache configCache;
    private final SubscribeRegistry subscribeRegistry;
    private AtomicInteger reqId;

    public OpenSergoClient(String host, int port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        this.transportGrpcStub = OpenSergoUniversalTransportServiceGrpc.newStub((Channel)this.channel);
        this.configCache = new SubscribedConfigCache();
        this.subscribeRegistry = new SubscribeRegistry();
        this.reqId = new AtomicInteger(0);
    }

    public void start() throws Exception {
        this.requestAndResponseWriter = ((OpenSergoUniversalTransportServiceGrpc.OpenSergoUniversalTransportServiceStub)this.transportGrpcStub.withWaitForReady()).subscribeConfig((StreamObserver<SubscribeResponse>)new OpenSergoSubscribeClientObserver(this.configCache, this.subscribeRegistry));
    }

    @Override
    public void close() throws Exception {
        this.requestAndResponseWriter.onCompleted();
        this.channel.shutdown();
    }

    public boolean unsubscribeConfig(SubscribeKey subscribeKey) {
        AssertUtils.assertNotNull(subscribeKey, "subscribeKey cannot be null");
        AssertUtils.assertNotNull(subscribeKey.getApp(), "app cannot be null");
        AssertUtils.assertNotNull((Object)subscribeKey.getKind(), "kind cannot be null");
        if (this.requestAndResponseWriter == null) {
            throw new IllegalStateException("gRPC stream is not ready");
        }
        SubscribeRequestTarget subTarget = SubscribeRequestTarget.newBuilder().setNamespace(subscribeKey.getNamespace()).setApp(subscribeKey.getApp()).addKinds(subscribeKey.getKind().getKindName()).build();
        SubscribeRequest request = SubscribeRequest.newBuilder().setTarget(subTarget).setOpType(SubscribeOpType.UNSUBSCRIBE).build();
        this.requestAndResponseWriter.onNext((Object)request);
        this.subscribeRegistry.removeAllSubscribers(subscribeKey);
        return true;
    }

    public boolean subscribeConfig(SubscribeKey subscribeKey) {
        return this.subscribeConfig(subscribeKey, null);
    }

    public boolean subscribeConfig(SubscribeKey subscribeKey, OpenSergoConfigSubscriber subscriber) {
        AssertUtils.assertNotNull(subscribeKey, "subscribeKey cannot be null");
        AssertUtils.assertNotNull(subscribeKey.getApp(), "app cannot be null");
        AssertUtils.assertNotNull((Object)subscribeKey.getKind(), "kind cannot be null");
        if (this.requestAndResponseWriter == null) {
            throw new IllegalStateException("gRPC stream is not ready");
        }
        SubscribeRequestTarget subTarget = SubscribeRequestTarget.newBuilder().setNamespace(subscribeKey.getNamespace()).setApp(subscribeKey.getApp()).addKinds(subscribeKey.getKind().getKindName()).build();
        SubscribeRequest request = SubscribeRequest.newBuilder().setRequestId(String.valueOf(this.reqId.incrementAndGet())).setTarget(subTarget).setOpType(SubscribeOpType.SUBSCRIBE).setIdentifier(IdentifierUtils.generateIdentifier(System.identityHashCode(this))).build();
        this.requestAndResponseWriter.onNext((Object)request);
        if (subscriber != null) {
            this.subscribeRegistry.registerSubscriber(subscribeKey, subscriber);
            OpenSergoLogger.info("OpenSergo config subscriber registered, subscribeKey={}, subscriber={}", subscribeKey, subscriber);
        }
        return true;
    }

    public SubscribedConfigCache getConfigCache() {
        return this.configCache;
    }
}

