/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo.subscribe;

import io.opensergo.subscribe.SubscribeKey;
import io.opensergo.subscribe.SubscribedData;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SubscribedConfigCache {
    private final ConcurrentMap<SubscribeKey, SubscribedData> dataMap = new ConcurrentHashMap<SubscribeKey, SubscribedData>();

    public void updateData(SubscribeKey key, Object data, long version) {
        this.dataMap.put(key, new SubscribedData(version, data));
    }

    public SubscribedData getDataFor(SubscribeKey key) {
        if (key == null) {
            return null;
        }
        return (SubscribedData)this.dataMap.get(key);
    }

    public Optional<Long> getDataVersionFor(SubscribeKey key) {
        SubscribedData d = this.getDataFor(key);
        return Optional.ofNullable(this.getDataFor(key)).map(SubscribedData::getVersion);
    }

    public <T> List<T> getDataListFor(SubscribeKey key, Class<T> clazz) {
        SubscribedData d = this.getDataFor(key);
        if (d == null || d.getData() == null) {
            return null;
        }
        return (List)d.getData();
    }
}

