/*
 * Decompiled with CFR 0.152.
 */
package io.opensergo.util;

import io.opensergo.log.OpenSergoLogger;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class IdentifierUtils {
    private static String ip;
    private static String hostName;
    private static int currentPid;
    private static final AtomicInteger counter;

    private static void resolveHost() throws Exception {
        InetAddress addr = InetAddress.getLocalHost();
        hostName = addr.getHostName();
        ip = addr.getHostAddress();
        if (addr.isLoopbackAddress()) {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface in = interfaces.nextElement();
                Enumeration<InetAddress> addrs = in.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    ip = address.getHostAddress();
                }
            }
        }
    }

    public static int getPid() {
        if (currentPid < 0) {
            IdentifierUtils.resolvePid();
        }
        return currentPid;
    }

    private static void resolvePid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        currentPid = Integer.parseInt(name.split("@")[0]);
    }

    public static String generateIdentifier(long clientId) {
        return String.format("%s-%s-%d-%d", hostName, ip, IdentifierUtils.getPid(), clientId);
    }

    static {
        currentPid = -1;
        counter = new AtomicInteger(0);
        try {
            IdentifierUtils.resolveHost();
        }
        catch (Throwable e) {
            OpenSergoLogger.error("Failed to resolve local host", e);
        }
    }
}

