/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.aws.resource;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Map;
import java.util.stream.Stream;

public final class LambdaResource {
    private static final Resource INSTANCE = LambdaResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    private static Resource buildResource() {
        return LambdaResource.buildResource(System.getenv());
    }

    static Resource buildResource(Map<String, String> environmentVariables) {
        String region = environmentVariables.getOrDefault("AWS_REGION", "");
        String functionName = environmentVariables.getOrDefault("AWS_LAMBDA_FUNCTION_NAME", "");
        String functionVersion = environmentVariables.getOrDefault("AWS_LAMBDA_FUNCTION_VERSION", "");
        if (!LambdaResource.isLambda(functionName, functionVersion)) {
            return Resource.empty();
        }
        AttributesBuilder builder = Attributes.builder().put(ResourceAttributes.CLOUD_PROVIDER, (Object)"aws");
        builder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"aws_lambda");
        if (!region.isEmpty()) {
            builder.put(ResourceAttributes.CLOUD_REGION, (Object)region);
        }
        if (!functionName.isEmpty()) {
            builder.put(ResourceAttributes.FAAS_NAME, (Object)functionName);
        }
        if (!functionVersion.isEmpty()) {
            builder.put(ResourceAttributes.FAAS_VERSION, (Object)functionVersion);
        }
        return Resource.create((Attributes)builder.build(), (String)"https://opentelemetry.io/schemas/1.18.0");
    }

    private static boolean isLambda(String ... envVariables) {
        return Stream.of(envVariables).anyMatch(v -> !v.isEmpty());
    }

    private LambdaResource() {
    }
}

