/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.awsxray.AwsAttributeKeys;
import io.opentelemetry.contrib.awsxray.MetricAttributeGenerator;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AwsMetricAttributeGenerator
implements MetricAttributeGenerator {
    private static final Logger logger = Logger.getLogger(AwsMetricAttributeGenerator.class.getName());
    private static final String GRAPHQL = "graphql";
    private static final String UNKNOWN_SERVICE = "UnknownService";
    private static final String UNKNOWN_OPERATION = "UnknownOperation";
    private static final String UNKNOWN_REMOTE_SERVICE = "UnknownRemoteService";
    private static final String UNKNOWN_REMOTE_OPERATION = "UnknownRemoteOperation";

    AwsMetricAttributeGenerator() {
    }

    @Override
    public Attributes generateMetricAttributesFromSpan(SpanData span, Resource resource) {
        AttributesBuilder builder = Attributes.builder();
        switch (span.getKind()) {
            case CONSUMER: 
            case SERVER: {
                AwsMetricAttributeGenerator.setService(resource, span, builder);
                AwsMetricAttributeGenerator.setIngressOperation(span, builder);
                AwsMetricAttributeGenerator.setSpanKind(span, builder);
                break;
            }
            case PRODUCER: 
            case CLIENT: {
                AwsMetricAttributeGenerator.setService(resource, span, builder);
                AwsMetricAttributeGenerator.setEgressOperation(span, builder);
                AwsMetricAttributeGenerator.setRemoteServiceAndOperation(span, builder);
                AwsMetricAttributeGenerator.setRemoteTarget(span, builder);
                AwsMetricAttributeGenerator.setSpanKind(span, builder);
                break;
            }
        }
        return builder.build();
    }

    private static void setRemoteTarget(SpanData span, AttributesBuilder builder) {
        Optional<String> remoteTarget = AwsMetricAttributeGenerator.getRemoteTarget(span);
        remoteTarget.ifPresent(s -> builder.put(AwsAttributeKeys.AWS_REMOTE_TARGET, s));
    }

    private static Optional<String> getRemoteTarget(SpanData span) {
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_BUCKET_NAME)) {
            return Optional.ofNullable((String)span.getAttributes().get(AwsAttributeKeys.AWS_BUCKET_NAME));
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_QUEUE_NAME)) {
            return Optional.ofNullable((String)span.getAttributes().get(AwsAttributeKeys.AWS_QUEUE_NAME));
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_STREAM_NAME)) {
            return Optional.ofNullable((String)span.getAttributes().get(AwsAttributeKeys.AWS_STREAM_NAME));
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_TABLE_NAME)) {
            return Optional.ofNullable((String)span.getAttributes().get(AwsAttributeKeys.AWS_TABLE_NAME));
        }
        return Optional.empty();
    }

    private static void setService(Resource resource, SpanData span, AttributesBuilder builder) {
        String service = (String)resource.getAttribute(ResourceAttributes.SERVICE_NAME);
        if (service == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_SERVICE, span);
            service = UNKNOWN_SERVICE;
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_SERVICE, (Object)service);
    }

    private static void setIngressOperation(SpanData span, AttributesBuilder builder) {
        String operation = !AwsMetricAttributeGenerator.isValidOperation(span) ? AwsMetricAttributeGenerator.generateIngressOperation(span) : span.getName();
        if (operation.equals(UNKNOWN_OPERATION)) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_OPERATION, span);
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_OPERATION, (Object)operation);
    }

    private static boolean isValidOperation(SpanData span) {
        String operation = span.getName();
        if (operation == null || operation.equals(UNKNOWN_OPERATION)) {
            return false;
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.HTTP_METHOD)) {
            String httpMethod = (String)span.getAttributes().get(SemanticAttributes.HTTP_METHOD);
            return !operation.equals(httpMethod);
        }
        return true;
    }

    private static void setEgressOperation(SpanData span, AttributesBuilder builder) {
        String operation = (String)span.getAttributes().get(AwsAttributeKeys.AWS_LOCAL_OPERATION);
        if (operation == null) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_LOCAL_OPERATION, span);
            operation = UNKNOWN_OPERATION;
        }
        builder.put(AwsAttributeKeys.AWS_LOCAL_OPERATION, (Object)operation);
    }

    private static void setRemoteServiceAndOperation(SpanData span, AttributesBuilder builder) {
        String remoteService = UNKNOWN_REMOTE_SERVICE;
        String remoteOperation = UNKNOWN_REMOTE_OPERATION;
        if (AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_SERVICE) || AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_OPERATION)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, AwsAttributeKeys.AWS_REMOTE_SERVICE);
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, AwsAttributeKeys.AWS_REMOTE_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.RPC_SERVICE) || AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.RPC_METHOD)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.RPC_SERVICE);
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, (AttributeKey<String>)SemanticAttributes.RPC_METHOD);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.DB_SYSTEM) || AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.DB_OPERATION)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.DB_SYSTEM);
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, (AttributeKey<String>)SemanticAttributes.DB_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.FAAS_INVOKED_NAME) || AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.FAAS_TRIGGER)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.FAAS_INVOKED_NAME);
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, (AttributeKey<String>)SemanticAttributes.FAAS_TRIGGER);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.MESSAGING_SYSTEM) || AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.MESSAGING_OPERATION)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.MESSAGING_SYSTEM);
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, (AttributeKey<String>)SemanticAttributes.MESSAGING_OPERATION);
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.GRAPHQL_OPERATION_TYPE)) {
            remoteService = GRAPHQL;
            remoteOperation = AwsMetricAttributeGenerator.getRemoteOperation(span, (AttributeKey<String>)SemanticAttributes.GRAPHQL_OPERATION_TYPE);
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.PEER_SERVICE) && !AwsMetricAttributeGenerator.isKeyPresent(span, AwsAttributeKeys.AWS_REMOTE_SERVICE)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.PEER_SERVICE);
        }
        if (remoteService.equals(UNKNOWN_REMOTE_SERVICE)) {
            remoteService = AwsMetricAttributeGenerator.generateRemoteService(span);
        }
        if (remoteOperation.equals(UNKNOWN_REMOTE_OPERATION)) {
            remoteOperation = AwsMetricAttributeGenerator.generateRemoteOperation(span);
        }
        builder.put(AwsAttributeKeys.AWS_REMOTE_SERVICE, (Object)remoteService);
        builder.put(AwsAttributeKeys.AWS_REMOTE_OPERATION, (Object)remoteOperation);
    }

    private static String generateIngressOperation(SpanData span) {
        String httpTarget;
        String operation = UNKNOWN_OPERATION;
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.HTTP_TARGET) && (httpTarget = (String)span.getAttributes().get(SemanticAttributes.HTTP_TARGET)) != null) {
            String httpMethod;
            operation = AwsMetricAttributeGenerator.extractAPIPathValue(httpTarget);
            if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.HTTP_METHOD) && (httpMethod = (String)span.getAttributes().get(SemanticAttributes.HTTP_METHOD)) != null) {
                operation = httpMethod + " " + operation;
            }
        }
        return operation;
    }

    private static String generateRemoteOperation(SpanData span) {
        String remoteOperation = UNKNOWN_REMOTE_OPERATION;
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.HTTP_URL)) {
            String httpUrl = (String)span.getAttributes().get(SemanticAttributes.HTTP_URL);
            try {
                if (httpUrl != null) {
                    URL url = new URL(httpUrl);
                    remoteOperation = AwsMetricAttributeGenerator.extractAPIPathValue(url.getPath());
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.FINEST, "invalid http.url attribute: ", httpUrl);
            }
        }
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.HTTP_METHOD)) {
            String httpMethod = (String)span.getAttributes().get(SemanticAttributes.HTTP_METHOD);
            remoteOperation = httpMethod + " " + remoteOperation;
        }
        if (remoteOperation.equals(UNKNOWN_REMOTE_OPERATION)) {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_OPERATION, span);
        }
        return remoteOperation;
    }

    private static String extractAPIPathValue(String httpTarget) {
        if (httpTarget == null || httpTarget.isEmpty()) {
            return "/";
        }
        String[] paths = httpTarget.split("/");
        if (paths.length > 1) {
            return "/" + paths[1];
        }
        return "/";
    }

    private static String generateRemoteService(SpanData span) {
        String remoteService = UNKNOWN_REMOTE_SERVICE;
        if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.NET_PEER_NAME)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.NET_PEER_NAME);
            if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.NET_PEER_PORT)) {
                Long port = (Long)span.getAttributes().get(SemanticAttributes.NET_PEER_PORT);
                remoteService = remoteService + ":" + port;
            }
        } else if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.NET_SOCK_PEER_ADDR)) {
            remoteService = AwsMetricAttributeGenerator.getRemoteService(span, (AttributeKey<String>)SemanticAttributes.NET_SOCK_PEER_ADDR);
            if (AwsMetricAttributeGenerator.isKeyPresent(span, SemanticAttributes.NET_SOCK_PEER_PORT)) {
                Long port = (Long)span.getAttributes().get(SemanticAttributes.NET_SOCK_PEER_PORT);
                remoteService = remoteService + ":" + port;
            }
        } else {
            AwsMetricAttributeGenerator.logUnknownAttribute(AwsAttributeKeys.AWS_REMOTE_SERVICE, span);
        }
        return remoteService;
    }

    private static void setSpanKind(SpanData span, AttributesBuilder builder) {
        String spanKind = span.getKind().name();
        builder.put(AwsAttributeKeys.AWS_SPAN_KIND, (Object)spanKind);
    }

    private static boolean isKeyPresent(SpanData span, AttributeKey<?> key) {
        return span.getAttributes().get(key) != null;
    }

    private static String getRemoteService(SpanData span, AttributeKey<String> remoteServiceKey) {
        String remoteService = (String)span.getAttributes().get(remoteServiceKey);
        if (remoteService == null) {
            remoteService = UNKNOWN_REMOTE_SERVICE;
        }
        return remoteService;
    }

    private static String getRemoteOperation(SpanData span, AttributeKey<String> remoteOperationKey) {
        String remoteOperation = (String)span.getAttributes().get(remoteOperationKey);
        if (remoteOperation == null) {
            remoteOperation = UNKNOWN_REMOTE_OPERATION;
        }
        return remoteOperation;
    }

    private static void logUnknownAttribute(AttributeKey<String> attributeKey, SpanData span) {
        Object[] params = new String[]{attributeKey.getKey(), span.getKind().name(), span.getSpanContext().getSpanId()};
        logger.log(Level.FINEST, "No valid {0} value found for {1} span {2}", params);
    }
}

