/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AttributePropagatingSpanProcessor
implements SpanProcessor {
    private final AttributeKey<String> spanNamePropagationKey;
    private final List<AttributeKey<String>> attributesKeysToPropagate;

    public static AttributePropagatingSpanProcessor create(AttributeKey<String> spanNamePropagationKey, List<AttributeKey<String>> attributesKeysToPropagate) {
        return new AttributePropagatingSpanProcessor(spanNamePropagationKey, attributesKeysToPropagate);
    }

    private AttributePropagatingSpanProcessor(AttributeKey<String> spanNamePropagationKey, List<AttributeKey<String>> attributesKeysToPropagate) {
        this.spanNamePropagationKey = spanNamePropagationKey;
        this.attributesKeysToPropagate = attributesKeysToPropagate;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        Span parentSpan = Span.fromContextOrNull((Context)parentContext);
        if (!(parentSpan instanceof ReadableSpan)) {
            return;
        }
        ReadableSpan parentReadableSpan = (ReadableSpan)parentSpan;
        String spanNameToPropagate = AttributePropagatingSpanProcessor.isLocalRoot(parentReadableSpan.getParentSpanContext()) && AttributePropagatingSpanProcessor.isServerOrConsumer(parentReadableSpan) ? parentReadableSpan.getName() : (String)parentReadableSpan.getAttribute(this.spanNamePropagationKey);
        if (spanNameToPropagate != null) {
            span.setAttribute(this.spanNamePropagationKey, (Object)spanNameToPropagate);
        }
        for (AttributeKey<String> keyToPropagate : this.attributesKeysToPropagate) {
            String valueToPropagate = (String)parentReadableSpan.getAttribute(keyToPropagate);
            if (valueToPropagate == null) continue;
            span.setAttribute(keyToPropagate, (Object)valueToPropagate);
        }
    }

    private static boolean isLocalRoot(SpanContext parentSpanContext) {
        return !parentSpanContext.isValid() || parentSpanContext.isRemote();
    }

    private static boolean isServerOrConsumer(ReadableSpan span) {
        return span.getKind() == SpanKind.SERVER || span.getKind() == SpanKind.CONSUMER;
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return false;
    }
}

