/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.contrib.awsxray.MetricAttributeGenerator;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.DelegatingSpanData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AwsMetricAttributesSpanExporter
implements SpanExporter {
    private final SpanExporter delegate;
    private final MetricAttributeGenerator generator;
    private final Resource resource;

    static AwsMetricAttributesSpanExporter create(SpanExporter delegate, MetricAttributeGenerator generator, Resource resource) {
        return new AwsMetricAttributesSpanExporter(delegate, generator, resource);
    }

    private AwsMetricAttributesSpanExporter(SpanExporter delegate, MetricAttributeGenerator generator, Resource resource) {
        this.delegate = delegate;
        this.generator = generator;
        this.resource = resource;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        List<SpanData> modifiedSpans = this.addMetricAttributes(spans);
        return this.delegate.export(modifiedSpans);
    }

    public CompletableResultCode flush() {
        return this.delegate.flush();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public void close() {
        this.delegate.close();
    }

    private List<SpanData> addMetricAttributes(Collection<SpanData> spans) {
        ArrayList<SpanData> modifiedSpans = new ArrayList<SpanData>();
        for (SpanData span : spans) {
            Attributes attributes = this.generator.generateMetricAttributesFromSpan(span, this.resource);
            if (!attributes.isEmpty()) {
                span = AwsMetricAttributesSpanExporter.wrapSpanWithAttributes(span, attributes);
            }
            modifiedSpans.add(span);
        }
        return modifiedSpans;
    }

    private static SpanData wrapSpanWithAttributes(SpanData span, Attributes attributes) {
        Attributes originalAttributes = span.getAttributes();
        final Attributes replacementAttributes = originalAttributes.toBuilder().putAll(attributes).build();
        int newAttributeKeyCount = 0;
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            if (originalAttributes.get((AttributeKey)entry.getKey()) != null) continue;
            ++newAttributeKeyCount;
        }
        int originalTotalAttributeCount = span.getTotalAttributeCount();
        final int replacementTotalAttributeCount = originalTotalAttributeCount + newAttributeKeyCount;
        return new DelegatingSpanData(span){

            public Attributes getAttributes() {
                return replacementAttributes;
            }

            public int getTotalAttributeCount() {
                return replacementTotalAttributeCount;
            }
        };
    }
}

