/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.contrib.awsxray.OrElseSampler;
import io.opentelemetry.contrib.awsxray.RateLimitingSampler;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class AwsXrayRemoteSamplerBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:2000";
    private static final long DEFAULT_POLLING_INTERVAL_SECS = 300L;
    private final Resource resource;
    private Clock clock = Clock.getDefault();
    private String endpoint = "http://localhost:2000";
    @Nullable
    private Sampler initialSampler;
    private long pollingIntervalNanos = TimeUnit.SECONDS.toNanos(300L);

    AwsXrayRemoteSamplerBuilder(Resource resource) {
        this.resource = resource;
    }

    @CanIgnoreReturnValue
    public AwsXrayRemoteSamplerBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsXrayRemoteSamplerBuilder setPollingInterval(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setPollingInterval(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    public AwsXrayRemoteSamplerBuilder setPollingInterval(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        if (delay < 0L) {
            throw new IllegalArgumentException("delay must be non-negative");
        }
        this.pollingIntervalNanos = unit.toNanos(delay);
        return this;
    }

    @CanIgnoreReturnValue
    public AwsXrayRemoteSamplerBuilder setInitialSampler(Sampler initialSampler) {
        Objects.requireNonNull(initialSampler, "initialSampler");
        this.initialSampler = initialSampler;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsXrayRemoteSamplerBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public AwsXrayRemoteSampler build() {
        Sampler initialSampler = this.initialSampler;
        if (initialSampler == null) {
            initialSampler = Sampler.parentBased((Sampler)new OrElseSampler(new RateLimitingSampler(1, this.clock), Sampler.traceIdRatioBased((double)0.05)));
        }
        return new AwsXrayRemoteSampler(this.resource, this.clock, this.endpoint, initialSampler, this.pollingIntervalNanos);
    }
}

