/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import io.opentelemetry.contrib.awsxray.AutoValue_AwsXrayAdaptiveSamplingConfig;
import io.opentelemetry.contrib.awsxray.AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyCaptureLimit;
import io.opentelemetry.contrib.awsxray.AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyConditions;
import java.util.List;
import javax.annotation.Nullable;

@JsonSerialize(as=AwsXrayAdaptiveSamplingConfig.class)
@JsonDeserialize(builder=AutoValue_AwsXrayAdaptiveSamplingConfig.Builder.class)
@AutoValue
public abstract class AwsXrayAdaptiveSamplingConfig {
    @JsonProperty(value="version")
    public abstract double getVersion();

    @JsonProperty(value="anomalyConditions")
    @Nullable
    public abstract List<AnomalyConditions> getAnomalyConditions();

    @JsonProperty(value="anomalyCaptureLimit")
    @Nullable
    public abstract AnomalyCaptureLimit getAnomalyCaptureLimit();

    public static Builder builder() {
        return new AutoValue_AwsXrayAdaptiveSamplingConfig.Builder();
    }

    @JsonDeserialize(builder=AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyCaptureLimit.Builder.class)
    @AutoValue
    public static abstract class AnomalyCaptureLimit {
        @JsonProperty(value="anomalyTracesPerSecond")
        public abstract int getAnomalyTracesPerSecond();

        public static Builder builder() {
            return new AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyCaptureLimit.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="anomalyTracesPerSecond")
            public abstract Builder setAnomalyTracesPerSecond(int var1);

            public abstract AnomalyCaptureLimit build();
        }
    }

    public static enum UsageType {
        BOTH("both"),
        SAMPLING_BOOST("sampling-boost"),
        ANOMALY_TRACE_CAPTURE("anomaly-trace-capture"),
        NEITHER("neither");

        private final String value;

        private UsageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UsageType fromValue(String value) {
            for (UsageType type : UsageType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid usage value: " + value);
        }

        public static boolean isUsedForBoost(UsageType usage) {
            return BOTH.equals((Object)usage) || SAMPLING_BOOST.equals((Object)usage);
        }

        public static boolean isUsedForAnomalyTraceCapture(UsageType usage) {
            return BOTH.equals((Object)usage) || ANOMALY_TRACE_CAPTURE.equals((Object)usage);
        }
    }

    @JsonDeserialize(builder=AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyConditions.Builder.class)
    @AutoValue
    public static abstract class AnomalyConditions {
        @JsonProperty(value="errorCodeRegex")
        @Nullable
        public abstract String getErrorCodeRegex();

        @JsonProperty(value="operations")
        @Nullable
        public abstract List<String> getOperations();

        @JsonProperty(value="highLatencyMs")
        @Nullable
        public abstract Long getHighLatencyMs();

        @JsonProperty(value="usage")
        @Nullable
        public abstract UsageType getUsage();

        public static Builder builder() {
            return new AutoValue_AwsXrayAdaptiveSamplingConfig_AnomalyConditions.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="errorCodeRegex")
            public abstract Builder setErrorCodeRegex(String var1);

            @JsonProperty(value="operations")
            public abstract Builder setOperations(List<String> var1);

            @JsonProperty(value="highLatencyMs")
            public abstract Builder setHighLatencyMs(Long var1);

            @JsonProperty(value="usage")
            public abstract Builder setUsage(UsageType var1);

            public abstract AnomalyConditions build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="version")
        public abstract Builder setVersion(double var1);

        @JsonProperty(value="anomalyConditions")
        public abstract Builder setAnomalyConditions(List<AnomalyConditions> var1);

        @JsonProperty(value="anomalyCaptureLimit")
        public abstract Builder setAnomalyCaptureLimit(AnomalyCaptureLimit var1);

        public abstract AwsXrayAdaptiveSamplingConfig build();
    }
}

