/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.awsxray;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.awsxray.AwsXrayRemoteSampler;
import io.opentelemetry.contrib.awsxray.GetSamplingRulesResponse;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsRequest;
import io.opentelemetry.contrib.awsxray.GetSamplingTargetsResponse;
import io.opentelemetry.contrib.awsxray.RateLimitingSampler;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SamplingRuleApplier {
    private static final AttributeKey<String> AWS_ECS_CONTAINER_ARN = AttributeKey.stringKey((String)"aws.ecs.container.arn");
    private static final AttributeKey<String> CLOUD_PLATFORM = AttributeKey.stringKey((String)"cloud.platform");
    private static final AttributeKey<String> CLOUD_RESOURCE_ID = AttributeKey.stringKey((String)"cloud.resource_id");
    public static final String AWS_EC2 = "aws_ec2";
    public static final String AWS_ECS = "aws_ecs";
    public static final String AWS_EKS = "aws_eks";
    public static final String AWS_LAMBDA = "aws_lambda";
    public static final String AWS_ELASTIC_BEANSTALK = "aws_elastic_beanstalk";
    private static final AttributeKey<String> HTTP_HOST = AttributeKey.stringKey((String)"http.host");
    private static final AttributeKey<String> HTTP_METHOD = AttributeKey.stringKey((String)"http.method");
    private static final AttributeKey<String> HTTP_TARGET = AttributeKey.stringKey((String)"http.target");
    private static final AttributeKey<String> HTTP_URL = AttributeKey.stringKey((String)"http.url");
    private static final AttributeKey<String> NET_HOST_NAME = AttributeKey.stringKey((String)"net.host.name");
    private static final Map<String, String> XRAY_CLOUD_PLATFORM;
    private static final String _OTHER_REQUEST_METHOD = "_OTHER";
    private final String clientId;
    private final String ruleName;
    private final String serviceName;
    private final Clock clock;
    private final Sampler reservoirSampler;
    private final long reservoirEndTimeNanos;
    private final double fixedRate;
    private final Sampler fixedRateSampler;
    private final boolean borrowing;
    private final boolean hasBoost;
    private final double boostedFixedRate;
    private final Long boostEndTimeNanos;
    private final Sampler boostedFixedRateSampler;
    private final Map<String, Matcher> attributeMatchers;
    private final Matcher urlPathMatcher;
    private final Matcher serviceNameMatcher;
    private final Matcher httpMethodMatcher;
    private final Matcher hostMatcher;
    private final Matcher serviceTypeMatcher;
    private final Matcher resourceArnMatcher;
    private final Statistics statistics;
    private final long nextSnapshotTimeNanos;

    SamplingRuleApplier(String clientId, GetSamplingRulesResponse.SamplingRule rule, @Nullable String serviceName, Clock clock) {
        this.clientId = clientId;
        this.clock = clock;
        String ruleName = rule.getRuleName();
        if (ruleName == null) {
            ruleName = "default";
        }
        this.ruleName = ruleName;
        this.serviceName = serviceName == null ? "default" : serviceName;
        this.nextSnapshotTimeNanos = clock.nanoTime();
        this.reservoirEndTimeNanos = Long.MAX_VALUE;
        if (rule.getReservoirSize() > 0) {
            this.reservoirSampler = this.createRateLimited(1);
            this.borrowing = true;
        } else {
            this.reservoirSampler = Sampler.alwaysOff();
            this.borrowing = false;
        }
        this.fixedRate = rule.getFixedRate();
        this.fixedRateSampler = SamplingRuleApplier.createFixedRate(this.fixedRate);
        this.hasBoost = rule.getSamplingRateBoost() != null;
        this.boostedFixedRate = this.fixedRate;
        this.boostedFixedRateSampler = SamplingRuleApplier.createFixedRate(this.fixedRate);
        this.boostEndTimeNanos = clock.nanoTime();
        this.attributeMatchers = rule.getAttributes().isEmpty() ? Collections.emptyMap() : rule.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SamplingRuleApplier.toMatcher((String)e.getValue())));
        this.urlPathMatcher = SamplingRuleApplier.toMatcher(rule.getUrlPath());
        this.serviceNameMatcher = SamplingRuleApplier.toMatcher(rule.getServiceName());
        this.httpMethodMatcher = SamplingRuleApplier.toMatcher(rule.getHttpMethod());
        this.hostMatcher = SamplingRuleApplier.toMatcher(rule.getHost());
        this.serviceTypeMatcher = SamplingRuleApplier.toMatcher(rule.getServiceType());
        this.resourceArnMatcher = SamplingRuleApplier.toMatcher(rule.getResourceArn());
        this.statistics = new Statistics();
    }

    private SamplingRuleApplier(String clientId, String ruleName, String serviceName, Clock clock, Sampler reservoirSampler, long reservoirEndTimeNanos, double fixedRate, Sampler fixedRateSampler, boolean borrowing, double boostedFixedRate, Long boostEndTimeNanos, boolean hasBoost, Map<String, Matcher> attributeMatchers, Matcher urlPathMatcher, Matcher serviceNameMatcher, Matcher httpMethodMatcher, Matcher hostMatcher, Matcher serviceTypeMatcher, Matcher resourceArnMatcher, Statistics statistics, long nextSnapshotTimeNanos) {
        this.clientId = clientId;
        this.ruleName = ruleName;
        this.serviceName = serviceName;
        this.clock = clock;
        this.reservoirSampler = reservoirSampler;
        this.reservoirEndTimeNanos = reservoirEndTimeNanos;
        this.fixedRate = fixedRate;
        this.fixedRateSampler = fixedRateSampler;
        this.borrowing = borrowing;
        this.boostedFixedRate = boostedFixedRate;
        this.boostEndTimeNanos = boostEndTimeNanos;
        this.hasBoost = hasBoost;
        this.attributeMatchers = attributeMatchers;
        this.urlPathMatcher = urlPathMatcher;
        this.serviceNameMatcher = serviceNameMatcher;
        this.httpMethodMatcher = httpMethodMatcher;
        this.hostMatcher = hostMatcher;
        this.serviceTypeMatcher = serviceTypeMatcher;
        this.resourceArnMatcher = resourceArnMatcher;
        this.statistics = statistics;
        this.nextSnapshotTimeNanos = nextSnapshotTimeNanos;
        this.boostedFixedRateSampler = SamplingRuleApplier.createFixedRate(this.boostedFixedRate);
    }

    boolean matches(Attributes attributes, Resource resource) {
        int schemeEndIndex;
        String host;
        String httpMethod;
        String httpUrl;
        int matchedAttributes = 0;
        String httpTarget = (String)attributes.get(UrlAttributes.URL_PATH);
        if (httpTarget == null) {
            httpTarget = (String)attributes.get(HTTP_TARGET);
        }
        if ((httpUrl = (String)attributes.get(UrlAttributes.URL_FULL)) == null) {
            httpUrl = (String)attributes.get(HTTP_URL);
        }
        if ((httpMethod = (String)attributes.get(HttpAttributes.HTTP_REQUEST_METHOD)) == null) {
            httpMethod = (String)attributes.get(HTTP_METHOD);
        }
        if (httpMethod != null && httpMethod.equals(_OTHER_REQUEST_METHOD)) {
            httpMethod = (String)attributes.get(HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL);
        }
        if ((host = (String)attributes.get(ServerAttributes.SERVER_ADDRESS)) == null && (host = (String)attributes.get(NET_HOST_NAME)) == null) {
            host = (String)attributes.get(HTTP_HOST);
        }
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            Matcher matcher = this.attributeMatchers.get(((AttributeKey)entry.getKey()).getKey());
            if (matcher == null) continue;
            if (matcher.matches(entry.getValue().toString())) {
                ++matchedAttributes;
                continue;
            }
            return false;
        }
        if (matchedAttributes != this.attributeMatchers.size()) {
            return false;
        }
        if (httpTarget == null && httpUrl != null && (schemeEndIndex = httpUrl.indexOf("://")) > 0) {
            int pathIndex = httpUrl.indexOf(47, schemeEndIndex + "://".length());
            httpTarget = pathIndex < 0 ? "/" : httpUrl.substring(pathIndex);
        }
        return this.urlPathMatcher.matches(httpTarget) && this.serviceNameMatcher.matches((String)resource.getAttribute(ServiceAttributes.SERVICE_NAME)) && this.httpMethodMatcher.matches(httpMethod) && this.hostMatcher.matches(host) && this.serviceTypeMatcher.matches(SamplingRuleApplier.getServiceType(resource)) && this.resourceArnMatcher.matches(SamplingRuleApplier.getArn(attributes, resource));
    }

    SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SamplingResult result;
        boolean shouldCount;
        boolean bl = shouldCount = !Span.fromContext((Context)parentContext).getSpanContext().isValid();
        if (shouldCount) {
            this.statistics.requests.increment();
        }
        boolean reservoirExpired = this.clock.nanoTime() >= this.reservoirEndTimeNanos;
        SamplingResult samplingResult = result = !reservoirExpired ? this.reservoirSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : SamplingResult.create((SamplingDecision)SamplingDecision.DROP);
        if (result.getDecision() != SamplingDecision.DROP) {
            if (shouldCount) {
                if (this.borrowing) {
                    this.statistics.borrowed.increment();
                }
                this.statistics.sampled.increment();
            }
            return result;
        }
        result = this.clock.nanoTime() < this.boostEndTimeNanos ? this.boostedFixedRateSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.fixedRateSampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        if (shouldCount && result.getDecision() != SamplingDecision.DROP) {
            this.statistics.sampled.increment();
        }
        return result;
    }

    void countTrace() {
        this.statistics.traces.increment();
    }

    void countAnomalyTrace(ReadableSpan span) {
        this.statistics.anomalies.increment();
        if (span.getSpanContext().isSampled()) {
            this.statistics.anomaliesSampled.increment();
        }
    }

    @Nullable
    SamplingRuleStatisticsSnapshot snapshot(Date now) {
        if (this.clock.nanoTime() < this.nextSnapshotTimeNanos) {
            return null;
        }
        long totalCount = this.statistics.requests.sumThenReset();
        long sampledCount = this.statistics.sampled.sumThenReset();
        long borrowCount = this.statistics.borrowed.sumThenReset();
        long traceCount = this.statistics.traces.sumThenReset();
        long anomalyCount = this.statistics.anomalies.sumThenReset();
        long sampledAnomalyCount = this.statistics.anomaliesSampled.sumThenReset();
        GetSamplingTargetsRequest.SamplingStatisticsDocument samplingStatistics = GetSamplingTargetsRequest.SamplingStatisticsDocument.newBuilder().setClientId(this.clientId).setRuleName(this.ruleName).setTimestamp(now).setRequestCount(totalCount).setSampledCount(sampledCount).setBorrowCount(borrowCount).build();
        GetSamplingTargetsRequest.SamplingBoostStatisticsDocument boostDoc = GetSamplingTargetsRequest.SamplingBoostStatisticsDocument.newBuilder().setRuleName(this.ruleName).setServiceName(this.serviceName).setTimestamp(now).setTotalCount(traceCount).setAnomalyCount(anomalyCount).setSampledAnomalyCount(sampledAnomalyCount).build();
        return new SamplingRuleStatisticsSnapshot(samplingStatistics, boostDoc);
    }

    long getNextSnapshotTimeNanos() {
        return this.nextSnapshotTimeNanos;
    }

    SamplingRuleApplier withTarget(GetSamplingTargetsResponse.SamplingTargetDocument target, Date now, long currentNanoTime) {
        GetSamplingTargetsResponse.SamplingBoost samplingBoostMap;
        Sampler newFixedRateSampler = SamplingRuleApplier.createFixedRate(target.getFixedRate());
        Sampler newReservoirSampler = Sampler.alwaysOff();
        long newReservoirEndTimeNanos = currentNanoTime;
        if (target.getReservoirQuota() != null && target.getReservoirQuotaTtl() != null) {
            newReservoirSampler = this.createRateLimited(target.getReservoirQuota());
            newReservoirEndTimeNanos = currentNanoTime + Duration.between(now.toInstant(), target.getReservoirQuotaTtl().toInstant()).toNanos();
        }
        long intervalNanos = target.getIntervalSecs() != null ? TimeUnit.SECONDS.toNanos(target.getIntervalSecs().intValue()) : AwsXrayRemoteSampler.DEFAULT_TARGET_INTERVAL_NANOS;
        long newNextSnapshotTimeNanos = currentNanoTime + intervalNanos;
        double newBoostedFixedRate = this.fixedRate;
        long newBoostEndTimeNanos = currentNanoTime;
        if (target.getSamplingBoost() != null && (samplingBoostMap = target.getSamplingBoost()) != null && samplingBoostMap.getBoostRate() >= target.getFixedRate() && samplingBoostMap.getBoostRateTtl() != null) {
            newBoostedFixedRate = samplingBoostMap.getBoostRate();
            newBoostEndTimeNanos = currentNanoTime + Duration.between(now.toInstant(), samplingBoostMap.getBoostRateTtl().toInstant()).toNanos();
        }
        return new SamplingRuleApplier(this.clientId, this.ruleName, this.serviceName, this.clock, newReservoirSampler, newReservoirEndTimeNanos, this.fixedRate, newFixedRateSampler, false, newBoostedFixedRate, newBoostEndTimeNanos, this.hasBoost, this.attributeMatchers, this.urlPathMatcher, this.serviceNameMatcher, this.httpMethodMatcher, this.hostMatcher, this.serviceTypeMatcher, this.resourceArnMatcher, this.statistics, newNextSnapshotTimeNanos);
    }

    SamplingRuleApplier withNextSnapshotTimeNanos(long newNextSnapshotTimeNanos) {
        return new SamplingRuleApplier(this.clientId, this.ruleName, this.serviceName, this.clock, this.reservoirSampler, this.reservoirEndTimeNanos, this.fixedRate, this.fixedRateSampler, this.borrowing, this.boostedFixedRate, this.boostEndTimeNanos, this.hasBoost, this.attributeMatchers, this.urlPathMatcher, this.serviceNameMatcher, this.httpMethodMatcher, this.hostMatcher, this.serviceTypeMatcher, this.resourceArnMatcher, this.statistics, newNextSnapshotTimeNanos);
    }

    String getRuleName() {
        return this.ruleName;
    }

    String getServiceName() {
        return this.serviceName;
    }

    boolean hasBoost() {
        return this.hasBoost;
    }

    @Nullable
    private static String getArn(Attributes attributes, Resource resource) {
        String arn = (String)resource.getAttributes().get(AWS_ECS_CONTAINER_ARN);
        if (arn != null) {
            return arn;
        }
        String cloudPlatform = (String)resource.getAttributes().get(CLOUD_PLATFORM);
        if (AWS_LAMBDA.equals(cloudPlatform)) {
            return SamplingRuleApplier.getLambdaArn(attributes, resource);
        }
        return null;
    }

    @Nullable
    private static String getLambdaArn(Attributes attributes, Resource resource) {
        String arn = (String)resource.getAttributes().get(CLOUD_RESOURCE_ID);
        if (arn != null) {
            return arn;
        }
        return (String)attributes.get(CLOUD_RESOURCE_ID);
    }

    @Nullable
    private static String getServiceType(Resource resource) {
        String cloudPlatform = (String)resource.getAttributes().get(CLOUD_PLATFORM);
        if (cloudPlatform == null) {
            return null;
        }
        return XRAY_CLOUD_PLATFORM.get(cloudPlatform);
    }

    private static Matcher toMatcher(String globPattern) {
        if (globPattern.equals("*")) {
            return TrueMatcher.INSTANCE;
        }
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c != '*' && c != '?') continue;
            return new PatternMatcher(SamplingRuleApplier.toRegexPattern(globPattern));
        }
        return new StringMatcher(globPattern);
    }

    private static Pattern toRegexPattern(String globPattern) {
        int tokenStart = -1;
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c == '*' || c == '?') {
                if (tokenStart != -1) {
                    patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart, i)));
                    tokenStart = -1;
                }
                if (c == '*') {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append(".");
                continue;
            }
            if (tokenStart != -1) continue;
            tokenStart = i;
        }
        if (tokenStart != -1) {
            patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart)));
        }
        return Pattern.compile(patternBuilder.toString());
    }

    private Sampler createRateLimited(int numPerSecond) {
        return Sampler.parentBased((Sampler)new RateLimitingSampler(numPerSecond, this.clock));
    }

    private static Sampler createFixedRate(double rate) {
        return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)rate));
    }

    static {
        HashMap<String, String> xrayCloudPlatform = new HashMap<String, String>();
        xrayCloudPlatform.put(AWS_EC2, "AWS::EC2::Instance");
        xrayCloudPlatform.put(AWS_ECS, "AWS::ECS::Container");
        xrayCloudPlatform.put(AWS_EKS, "AWS::EKS::Container");
        xrayCloudPlatform.put(AWS_ELASTIC_BEANSTALK, "AWS::ElasticBeanstalk::Environment");
        xrayCloudPlatform.put(AWS_LAMBDA, "AWS::Lambda::Function");
        XRAY_CLOUD_PLATFORM = Collections.unmodifiableMap(xrayCloudPlatform);
    }

    private static interface Matcher {
        public boolean matches(@Nullable String var1);
    }

    private static class Statistics {
        final LongAdder requests = new LongAdder();
        final LongAdder sampled = new LongAdder();
        final LongAdder borrowed = new LongAdder();
        final LongAdder traces = new LongAdder();
        final LongAdder anomalies = new LongAdder();
        final LongAdder anomaliesSampled = new LongAdder();

        private Statistics() {
        }
    }

    static class SamplingRuleStatisticsSnapshot {
        final GetSamplingTargetsRequest.SamplingStatisticsDocument statisticsDocument;
        final GetSamplingTargetsRequest.SamplingBoostStatisticsDocument boostStatisticsDocument;

        SamplingRuleStatisticsSnapshot(GetSamplingTargetsRequest.SamplingStatisticsDocument statisticsDocument, GetSamplingTargetsRequest.SamplingBoostStatisticsDocument boostStatisticsDocument) {
            this.statisticsDocument = statisticsDocument;
            this.boostStatisticsDocument = boostStatisticsDocument;
        }

        GetSamplingTargetsRequest.SamplingStatisticsDocument getStatisticsDocument() {
            return this.statisticsDocument;
        }

        GetSamplingTargetsRequest.SamplingBoostStatisticsDocument getBoostStatisticsDocument() {
            return this.boostStatisticsDocument;
        }
    }

    private static enum TrueMatcher implements Matcher
    {
        INSTANCE;


        @Override
        public boolean matches(@Nullable String s) {
            return true;
        }

        public String toString() {
            return "TrueMatcher";
        }
    }

    private static class PatternMatcher
    implements Matcher {
        private final Pattern pattern;

        PatternMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(@Nullable String s) {
            if (s == null) {
                return false;
            }
            return this.pattern.matcher(s).matches();
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    private static class StringMatcher
    implements Matcher {
        private final String target;

        StringMatcher(String target) {
            this.target = target;
        }

        @Override
        public boolean matches(@Nullable String s) {
            if (s == null) {
                return false;
            }
            return this.target.equalsIgnoreCase(s);
        }

        public String toString() {
            return this.target;
        }
    }
}

