/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.azure.resource.AzureEnvVarPlatform;
import io.opentelemetry.contrib.azure.resource.AzureVmResourceProvider;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.contrib.azure.resource.IncubatingAttributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.HashMap;
import java.util.Map;

public final class AzureContainersResourceProvider
extends CloudResourceProvider {
    static final String CONTAINER_APP_NAME = "CONTAINER_APP_NAME";
    private static final String CONTAINER_APP_REPLICA_NAME = "CONTAINER_APP_REPLICA_NAME";
    private static final String CONTAINER_APP_REVISION = "CONTAINER_APP_REVISION";
    private static final Map<AttributeKey<String>, String> ENV_VAR_MAPPING = new HashMap<AttributeKey<String>, String>();
    private final Map<String, String> env;

    public AzureContainersResourceProvider() {
        this(System.getenv());
    }

    AzureContainersResourceProvider(Map<String, String> env) {
        this.env = env;
    }

    @Override
    public Resource createResource() {
        return Resource.create((Attributes)this.getAttributes());
    }

    public Attributes getAttributes() {
        AzureEnvVarPlatform detect = AzureEnvVarPlatform.detect(this.env);
        if (detect != AzureEnvVarPlatform.CONTAINER_APP) {
            return Attributes.empty();
        }
        AttributesBuilder builder = AzureVmResourceProvider.azureAttributeBuilder("azure_container_apps");
        AzureEnvVarPlatform.addAttributesFromEnv(ENV_VAR_MAPPING, this.env, builder);
        return builder.build();
    }

    static {
        ENV_VAR_MAPPING.put((AttributeKey<String>)ServiceAttributes.SERVICE_NAME, CONTAINER_APP_NAME);
        ENV_VAR_MAPPING.put(IncubatingAttributes.SERVICE_INSTANCE_ID, CONTAINER_APP_REPLICA_NAME);
        ENV_VAR_MAPPING.put((AttributeKey<String>)ServiceAttributes.SERVICE_VERSION, CONTAINER_APP_REVISION);
    }
}

