/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.contrib.azure.resource.AzureAksResourceProvider;
import io.opentelemetry.contrib.azure.resource.AzureAppServiceResourceProvider;
import io.opentelemetry.contrib.azure.resource.AzureContainersResourceProvider;
import io.opentelemetry.contrib.azure.resource.AzureFunctionsResourceProvider;
import io.opentelemetry.contrib.azure.resource.AzureVmResourceProvider;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;

public final class AzureResourceDetector
implements ComponentProvider<Resource> {
    public Class<Resource> getType() {
        return Resource.class;
    }

    public String getName() {
        return "azure";
    }

    public Resource create(DeclarativeConfigProperties config) {
        Builder builder = new Builder();
        builder.add(new AzureFunctionsResourceProvider());
        builder.add(new AzureAppServiceResourceProvider());
        builder.add(new AzureContainersResourceProvider());
        builder.addIfEmpty(new AzureAksResourceProvider());
        builder.addIfEmpty(new AzureVmResourceProvider());
        return builder.builder.build();
    }

    private static class Builder {
        final ResourceBuilder builder = Resource.builder();
        int attributesCount = 0;

        private Builder() {
        }

        private void add(CloudResourceProvider provider) {
            Attributes attributes = provider.createResource().getAttributes();
            this.builder.putAll(attributes);
            this.attributesCount += attributes.size();
        }

        private void addIfEmpty(CloudResourceProvider provider) {
            if (this.attributesCount == 0) {
                this.add(provider);
            }
        }
    }
}

