// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.common.v1.InstrumentationScope in opentelemetry/proto/common/v1/common.proto
package io.opentelemetry.proto.common.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * InstrumentationScope is a message representing the instrumentation scope information
 * such as the fully qualified name and version.
 */
public final class InstrumentationScope extends Message<InstrumentationScope, InstrumentationScope.Builder> {
  public static final ProtoAdapter<InstrumentationScope> ADAPTER = new ProtoAdapter_InstrumentationScope();

  private static final long serialVersionUID = 0L;

  /**
   * An empty instrumentation scope name means the name is unknown.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String name;

  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String version;

  /**
   * Additional attributes that describe the scope. [Optional].
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 3,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedAttributesCount"
  )
  public final int dropped_attributes_count;

  public InstrumentationScope(String name, String version, List<KeyValue> attributes,
      int dropped_attributes_count) {
    this(name, version, attributes, dropped_attributes_count, ByteString.EMPTY);
  }

  public InstrumentationScope(String name, String version, List<KeyValue> attributes,
      int dropped_attributes_count, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (name == null) {
      throw new IllegalArgumentException("name == null");
    }
    this.name = name;
    if (version == null) {
      throw new IllegalArgumentException("version == null");
    }
    this.version = version;
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.dropped_attributes_count = dropped_attributes_count;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.name = name;
    builder.version = version;
    builder.attributes = Internal.copyOf(attributes);
    builder.dropped_attributes_count = dropped_attributes_count;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof InstrumentationScope)) return false;
    InstrumentationScope o = (InstrumentationScope) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(name, o.name)
        && Internal.equals(version, o.version)
        && attributes.equals(o.attributes)
        && Internal.equals(dropped_attributes_count, o.dropped_attributes_count);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (name != null ? name.hashCode() : 0);
      result = result * 37 + (version != null ? version.hashCode() : 0);
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Integer.hashCode(dropped_attributes_count);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (name != null) builder.append(", name=").append(Internal.sanitize(name));
    if (version != null) builder.append(", version=").append(Internal.sanitize(version));
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
    return builder.replace(0, 2, "InstrumentationScope{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<InstrumentationScope, Builder> {
    public String name;

    public String version;

    public List<KeyValue> attributes;

    public int dropped_attributes_count;

    public Builder() {
      name = "";
      version = "";
      attributes = Internal.newMutableList();
      dropped_attributes_count = 0;
    }

    /**
     * An empty instrumentation scope name means the name is unknown.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder version(String version) {
      this.version = version;
      return this;
    }

    /**
     * Additional attributes that describe the scope. [Optional].
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    public Builder dropped_attributes_count(int dropped_attributes_count) {
      this.dropped_attributes_count = dropped_attributes_count;
      return this;
    }

    @Override
    public InstrumentationScope build() {
      return new InstrumentationScope(name, version, attributes, dropped_attributes_count, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_InstrumentationScope extends ProtoAdapter<InstrumentationScope> {
    public ProtoAdapter_InstrumentationScope() {
      super(FieldEncoding.LENGTH_DELIMITED, InstrumentationScope.class, "type.googleapis.com/opentelemetry.proto.common.v1.InstrumentationScope", Syntax.PROTO_3, null, "opentelemetry/proto/common/v1/common.proto");
    }

    @Override
    public int encodedSize(InstrumentationScope value) {
      int result = 0;
      if (!Objects.equals(value.name, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(1, value.name);
      }
      if (!Objects.equals(value.version, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(2, value.version);
      }
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(3, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(4, value.dropped_attributes_count);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, InstrumentationScope value) throws IOException {
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
      if (!Objects.equals(value.version, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.version);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 4, value.dropped_attributes_count);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, InstrumentationScope value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 4, value.dropped_attributes_count);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
      if (!Objects.equals(value.version, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.version);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
    }

    @Override
    public InstrumentationScope decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.version(ProtoAdapter.STRING.decode(reader)); break;
          case 3: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 4: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public InstrumentationScope redact(InstrumentationScope value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
