// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.common.v1.KeyValueList in opentelemetry/proto/common/v1/common.proto
package io.opentelemetry.proto.common.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import okio.ByteString;

/**
 * KeyValueList is a list of KeyValue messages. We need KeyValueList as a message
 * since `oneof` in AnyValue does not allow repeated fields. Everywhere else where we need
 * a list of KeyValue messages (e.g. in Span) we use `repeated KeyValue` directly to
 * avoid unnecessary extra wrapping (which slows down the protocol). The 2 approaches
 * are semantically equivalent.
 */
public final class KeyValueList extends Message<KeyValueList, KeyValueList.Builder> {
  public static final ProtoAdapter<KeyValueList> ADAPTER = new ProtoAdapter_KeyValueList();

  private static final long serialVersionUID = 0L;

  /**
   * A collection of key/value pairs of key-value pairs. The list may be empty (may
   * contain 0 elements).
   * The keys MUST be unique (it is not allowed to have more than one
   * value with the same key).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> values;

  public KeyValueList(List<KeyValue> values) {
    this(values, ByteString.EMPTY);
  }

  public KeyValueList(List<KeyValue> values, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.values = Internal.immutableCopyOf("values", values);
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.values = Internal.copyOf(values);
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof KeyValueList)) return false;
    KeyValueList o = (KeyValueList) other;
    return unknownFields().equals(o.unknownFields())
        && values.equals(o.values);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + values.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!values.isEmpty()) builder.append(", values=").append(values);
    return builder.replace(0, 2, "KeyValueList{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<KeyValueList, Builder> {
    public List<KeyValue> values;

    public Builder() {
      values = Internal.newMutableList();
    }

    /**
     * A collection of key/value pairs of key-value pairs. The list may be empty (may
     * contain 0 elements).
     * The keys MUST be unique (it is not allowed to have more than one
     * value with the same key).
     */
    public Builder values(List<KeyValue> values) {
      Internal.checkElementsNotNull(values);
      this.values = values;
      return this;
    }

    @Override
    public KeyValueList build() {
      return new KeyValueList(values, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_KeyValueList extends ProtoAdapter<KeyValueList> {
    public ProtoAdapter_KeyValueList() {
      super(FieldEncoding.LENGTH_DELIMITED, KeyValueList.class, "type.googleapis.com/opentelemetry.proto.common.v1.KeyValueList", Syntax.PROTO_3, null, "opentelemetry/proto/common/v1/common.proto");
    }

    @Override
    public int encodedSize(KeyValueList value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(1, value.values);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, KeyValueList value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.values);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, KeyValueList value) throws IOException {
      writer.writeBytes(value.unknownFields());
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.values);
    }

    @Override
    public KeyValueList decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.values.add(KeyValue.ADAPTER.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public KeyValueList redact(KeyValueList value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.values, KeyValue.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
