// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.logs.v1.LogRecord in opentelemetry/proto/logs/v1/logs.proto
package io.opentelemetry.proto.logs.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A log record according to OpenTelemetry Log Data Model:
 * https://github.com/open-telemetry/oteps/blob/main/text/logs/0097-log-data-model.md
 */
public final class LogRecord extends Message<LogRecord, LogRecord.Builder> {
  public static final ProtoAdapter<LogRecord> ADAPTER = new ProtoAdapter_LogRecord();

  private static final long serialVersionUID = 0L;

  /**
   * time_unix_nano is the time when the event occurred.
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
   * Value of 0 indicates unknown or missing timestamp.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * Time when the event was observed by the collection system.
   * For events that originate in OpenTelemetry (e.g. using OpenTelemetry Logging SDK)
   * this timestamp is typically set at the generation time and is equal to Timestamp.
   * For events originating externally and collected by OpenTelemetry (e.g. using
   * Collector) this is the time when OpenTelemetry's code observed the event measured
   * by the clock of the OpenTelemetry code. This field MUST be set once the event is
   * observed by OpenTelemetry.
   *
   * For converting OpenTelemetry log data to formats that support only one timestamp or
   * when receiving OpenTelemetry log data by recipients that support only one timestamp
   * internally the following logic is recommended:
   *   - Use time_unix_nano if it is present, otherwise use observed_time_unix_nano.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
   * Value of 0 indicates unknown or missing timestamp.
   */
  @WireField(
      tag = 11,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "observedTimeUnixNano"
  )
  public final long observed_time_unix_nano;

  /**
   * Numerical value of the severity, normalized to values described in Log Data Model.
   * [Optional].
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.logs.v1.SeverityNumber#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "severityNumber"
  )
  public final SeverityNumber severity_number;

  /**
   * The severity text (also known as log level). The original string representation as
   * it is known at the source. [Optional].
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "severityText"
  )
  public final String severity_text;

  /**
   * A value containing the body of the log record. Can be for example a human-readable
   * string message (including multi-line) describing the event in a free form or it can
   * be a structured data composed of arrays and maps of other values. [Optional].
   */
  @WireField(
      tag = 5,
      adapter = "io.opentelemetry.proto.common.v1.AnyValue#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final AnyValue body;

  /**
   * Additional attributes that describe the specific event occurrence. [Optional].
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 6,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedAttributesCount"
  )
  public final int dropped_attributes_count;

  /**
   * Flags, a bit field. 8 least significant bits are the trace flags as
   * defined in W3C Trace Context specification. 24 most significant bits are reserved
   * and must be set to 0. Readers must not assume that 24 most significant bits
   * will be zero and must correctly mask the bits when reading 8-bit trace flag (use
   * flags & LOG_RECORD_FLAGS_TRACE_FLAGS_MASK). [Optional].
   */
  @WireField(
      tag = 8,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  /**
   * A unique identifier for a trace. All logs from the same trace share
   * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
   * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
   * is zero-length and thus is also invalid).
   *
   * This field is optional.
   *
   * The receivers SHOULD assume that the log record is not associated with a
   * trace if any of the following is true:
   *   - the field is not present,
   *   - the field contains an invalid value.
   */
  @WireField(
      tag = 9,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "traceId"
  )
  public final ByteString trace_id;

  /**
   * A unique identifier for a span within a trace, assigned when the span
   * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
   * other than 8 bytes is considered invalid (empty string in OTLP/JSON
   * is zero-length and thus is also invalid).
   *
   * This field is optional. If the sender specifies a valid span_id then it SHOULD also
   * specify a valid trace_id.
   *
   * The receivers SHOULD assume that the log record is not associated with a
   * span if any of the following is true:
   *   - the field is not present,
   *   - the field contains an invalid value.
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "spanId"
  )
  public final ByteString span_id;

  public LogRecord(long time_unix_nano, long observed_time_unix_nano,
      SeverityNumber severity_number, String severity_text, AnyValue body,
      List<KeyValue> attributes, int dropped_attributes_count, int flags, ByteString trace_id,
      ByteString span_id) {
    this(time_unix_nano, observed_time_unix_nano, severity_number, severity_text, body, attributes, dropped_attributes_count, flags, trace_id, span_id, ByteString.EMPTY);
  }

  public LogRecord(long time_unix_nano, long observed_time_unix_nano,
      SeverityNumber severity_number, String severity_text, AnyValue body,
      List<KeyValue> attributes, int dropped_attributes_count, int flags, ByteString trace_id,
      ByteString span_id, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.time_unix_nano = time_unix_nano;
    this.observed_time_unix_nano = observed_time_unix_nano;
    if (severity_number == null) {
      throw new IllegalArgumentException("severity_number == null");
    }
    this.severity_number = severity_number;
    if (severity_text == null) {
      throw new IllegalArgumentException("severity_text == null");
    }
    this.severity_text = severity_text;
    this.body = body;
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.dropped_attributes_count = dropped_attributes_count;
    this.flags = flags;
    if (trace_id == null) {
      throw new IllegalArgumentException("trace_id == null");
    }
    this.trace_id = trace_id;
    if (span_id == null) {
      throw new IllegalArgumentException("span_id == null");
    }
    this.span_id = span_id;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.time_unix_nano = time_unix_nano;
    builder.observed_time_unix_nano = observed_time_unix_nano;
    builder.severity_number = severity_number;
    builder.severity_text = severity_text;
    builder.body = body;
    builder.attributes = Internal.copyOf(attributes);
    builder.dropped_attributes_count = dropped_attributes_count;
    builder.flags = flags;
    builder.trace_id = trace_id;
    builder.span_id = span_id;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof LogRecord)) return false;
    LogRecord o = (LogRecord) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && Internal.equals(observed_time_unix_nano, o.observed_time_unix_nano)
        && Internal.equals(severity_number, o.severity_number)
        && Internal.equals(severity_text, o.severity_text)
        && Internal.equals(body, o.body)
        && attributes.equals(o.attributes)
        && Internal.equals(dropped_attributes_count, o.dropped_attributes_count)
        && Internal.equals(flags, o.flags)
        && Internal.equals(trace_id, o.trace_id)
        && Internal.equals(span_id, o.span_id);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + Long.hashCode(observed_time_unix_nano);
      result = result * 37 + (severity_number != null ? severity_number.hashCode() : 0);
      result = result * 37 + (severity_text != null ? severity_text.hashCode() : 0);
      result = result * 37 + (body != null ? body.hashCode() : 0);
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Integer.hashCode(dropped_attributes_count);
      result = result * 37 + Integer.hashCode(flags);
      result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
      result = result * 37 + (span_id != null ? span_id.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", time_unix_nano=").append(time_unix_nano);
    builder.append(", observed_time_unix_nano=").append(observed_time_unix_nano);
    if (severity_number != null) builder.append(", severity_number=").append(severity_number);
    if (severity_text != null) builder.append(", severity_text=").append(Internal.sanitize(severity_text));
    if (body != null) builder.append(", body=").append(body);
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
    builder.append(", flags=").append(flags);
    if (trace_id != null) builder.append(", trace_id=").append(trace_id);
    if (span_id != null) builder.append(", span_id=").append(span_id);
    return builder.replace(0, 2, "LogRecord{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<LogRecord, Builder> {
    public long time_unix_nano;

    public long observed_time_unix_nano;

    public SeverityNumber severity_number;

    public String severity_text;

    public AnyValue body;

    public List<KeyValue> attributes;

    public int dropped_attributes_count;

    public int flags;

    public ByteString trace_id;

    public ByteString span_id;

    public Builder() {
      time_unix_nano = 0L;
      observed_time_unix_nano = 0L;
      severity_number = SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
      severity_text = "";
      attributes = Internal.newMutableList();
      dropped_attributes_count = 0;
      flags = 0;
      trace_id = ByteString.EMPTY;
      span_id = ByteString.EMPTY;
    }

    /**
     * time_unix_nano is the time when the event occurred.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * Value of 0 indicates unknown or missing timestamp.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * Time when the event was observed by the collection system.
     * For events that originate in OpenTelemetry (e.g. using OpenTelemetry Logging SDK)
     * this timestamp is typically set at the generation time and is equal to Timestamp.
     * For events originating externally and collected by OpenTelemetry (e.g. using
     * Collector) this is the time when OpenTelemetry's code observed the event measured
     * by the clock of the OpenTelemetry code. This field MUST be set once the event is
     * observed by OpenTelemetry.
     *
     * For converting OpenTelemetry log data to formats that support only one timestamp or
     * when receiving OpenTelemetry log data by recipients that support only one timestamp
     * internally the following logic is recommended:
     *   - Use time_unix_nano if it is present, otherwise use observed_time_unix_nano.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * Value of 0 indicates unknown or missing timestamp.
     */
    public Builder observed_time_unix_nano(long observed_time_unix_nano) {
      this.observed_time_unix_nano = observed_time_unix_nano;
      return this;
    }

    /**
     * Numerical value of the severity, normalized to values described in Log Data Model.
     * [Optional].
     */
    public Builder severity_number(SeverityNumber severity_number) {
      this.severity_number = severity_number;
      return this;
    }

    /**
     * The severity text (also known as log level). The original string representation as
     * it is known at the source. [Optional].
     */
    public Builder severity_text(String severity_text) {
      this.severity_text = severity_text;
      return this;
    }

    /**
     * A value containing the body of the log record. Can be for example a human-readable
     * string message (including multi-line) describing the event in a free form or it can
     * be a structured data composed of arrays and maps of other values. [Optional].
     */
    public Builder body(AnyValue body) {
      this.body = body;
      return this;
    }

    /**
     * Additional attributes that describe the specific event occurrence. [Optional].
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    public Builder dropped_attributes_count(int dropped_attributes_count) {
      this.dropped_attributes_count = dropped_attributes_count;
      return this;
    }

    /**
     * Flags, a bit field. 8 least significant bits are the trace flags as
     * defined in W3C Trace Context specification. 24 most significant bits are reserved
     * and must be set to 0. Readers must not assume that 24 most significant bits
     * will be zero and must correctly mask the bits when reading 8-bit trace flag (use
     * flags & LOG_RECORD_FLAGS_TRACE_FLAGS_MASK). [Optional].
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    /**
     * A unique identifier for a trace. All logs from the same trace share
     * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     *
     * This field is optional.
     *
     * The receivers SHOULD assume that the log record is not associated with a
     * trace if any of the following is true:
     *   - the field is not present,
     *   - the field contains an invalid value.
     */
    public Builder trace_id(ByteString trace_id) {
      this.trace_id = trace_id;
      return this;
    }

    /**
     * A unique identifier for a span within a trace, assigned when the span
     * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     * other than 8 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     *
     * This field is optional. If the sender specifies a valid span_id then it SHOULD also
     * specify a valid trace_id.
     *
     * The receivers SHOULD assume that the log record is not associated with a
     * span if any of the following is true:
     *   - the field is not present,
     *   - the field contains an invalid value.
     */
    public Builder span_id(ByteString span_id) {
      this.span_id = span_id;
      return this;
    }

    @Override
    public LogRecord build() {
      return new LogRecord(time_unix_nano, observed_time_unix_nano, severity_number, severity_text, body, attributes, dropped_attributes_count, flags, trace_id, span_id, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_LogRecord extends ProtoAdapter<LogRecord> {
    public ProtoAdapter_LogRecord() {
      super(FieldEncoding.LENGTH_DELIMITED, LogRecord.class, "type.googleapis.com/opentelemetry.proto.logs.v1.LogRecord", Syntax.PROTO_3, null, "opentelemetry/proto/logs/v1/logs.proto");
    }

    @Override
    public int encodedSize(LogRecord value) {
      int result = 0;
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(1, value.time_unix_nano);
      }
      if (!Objects.equals(value.observed_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(11, value.observed_time_unix_nano);
      }
      if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) {
        result += SeverityNumber.ADAPTER.encodedSizeWithTag(2, value.severity_number);
      }
      if (!Objects.equals(value.severity_text, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.severity_text);
      }
      if (!Objects.equals(value.body, null)) {
        result += AnyValue.ADAPTER.encodedSizeWithTag(5, value.body);
      }
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(6, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(7, value.dropped_attributes_count);
      }
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.FIXED32.encodedSizeWithTag(8, value.flags);
      }
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(9, value.trace_id);
      }
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(10, value.span_id);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, LogRecord value) throws IOException {
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 1, value.time_unix_nano);
      if (!Objects.equals(value.observed_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 11, value.observed_time_unix_nano);
      if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) SeverityNumber.ADAPTER.encodeWithTag(writer, 2, value.severity_number);
      if (!Objects.equals(value.severity_text, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.severity_text);
      if (!Objects.equals(value.body, null)) AnyValue.ADAPTER.encodeWithTag(writer, 5, value.body);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 7, value.dropped_attributes_count);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 8, value.flags);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 9, value.trace_id);
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 10, value.span_id);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, LogRecord value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 10, value.span_id);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 9, value.trace_id);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 8, value.flags);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 7, value.dropped_attributes_count);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.attributes);
      if (!Objects.equals(value.body, null)) AnyValue.ADAPTER.encodeWithTag(writer, 5, value.body);
      if (!Objects.equals(value.severity_text, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.severity_text);
      if (!Objects.equals(value.severity_number, SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED)) SeverityNumber.ADAPTER.encodeWithTag(writer, 2, value.severity_number);
      if (!Objects.equals(value.observed_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 11, value.observed_time_unix_nano);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 1, value.time_unix_nano);
    }

    @Override
    public LogRecord decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 2: {
            try {
              builder.severity_number(SeverityNumber.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 3: builder.severity_text(ProtoAdapter.STRING.decode(reader)); break;
          case 5: builder.body(AnyValue.ADAPTER.decode(reader)); break;
          case 6: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 7: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
          case 8: builder.flags(ProtoAdapter.FIXED32.decode(reader)); break;
          case 9: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 10: builder.span_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 11: builder.observed_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public LogRecord redact(LogRecord value) {
      Builder builder = value.newBuilder();
      if (builder.body != null) builder.body = AnyValue.ADAPTER.redact(builder.body);
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
