// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.logs.v1.LogsData in opentelemetry/proto/logs/v1/logs.proto
package io.opentelemetry.proto.logs.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import okio.ByteString;

/**
 * LogsData represents the logs data that can be stored in a persistent storage,
 * OR can be embedded by other protocols that transfer OTLP logs data but do not
 * implement the OTLP protocol.
 *
 * The main difference between this message and collector protocol is that
 * in this message there will not be any "control" or "metadata" specific to
 * OTLP protocol.
 *
 * When new fields are added into this message, the OTLP request MUST be updated
 * as well.
 */
public final class LogsData extends Message<LogsData, LogsData.Builder> {
  public static final ProtoAdapter<LogsData> ADAPTER = new ProtoAdapter_LogsData();

  private static final long serialVersionUID = 0L;

  /**
   * An array of ResourceLogs.
   * For data coming from a single resource this array will typically contain
   * one element. Intermediary nodes that receive data from multiple origins
   * typically batch the data before forwarding further and in that case this
   * array will contain multiple elements.
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.logs.v1.ResourceLogs#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "resourceLogs"
  )
  public final List<ResourceLogs> resource_logs;

  public LogsData(List<ResourceLogs> resource_logs) {
    this(resource_logs, ByteString.EMPTY);
  }

  public LogsData(List<ResourceLogs> resource_logs, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.resource_logs = Internal.immutableCopyOf("resource_logs", resource_logs);
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.resource_logs = Internal.copyOf(resource_logs);
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof LogsData)) return false;
    LogsData o = (LogsData) other;
    return unknownFields().equals(o.unknownFields())
        && resource_logs.equals(o.resource_logs);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + resource_logs.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!resource_logs.isEmpty()) builder.append(", resource_logs=").append(resource_logs);
    return builder.replace(0, 2, "LogsData{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<LogsData, Builder> {
    public List<ResourceLogs> resource_logs;

    public Builder() {
      resource_logs = Internal.newMutableList();
    }

    /**
     * An array of ResourceLogs.
     * For data coming from a single resource this array will typically contain
     * one element. Intermediary nodes that receive data from multiple origins
     * typically batch the data before forwarding further and in that case this
     * array will contain multiple elements.
     */
    public Builder resource_logs(List<ResourceLogs> resource_logs) {
      Internal.checkElementsNotNull(resource_logs);
      this.resource_logs = resource_logs;
      return this;
    }

    @Override
    public LogsData build() {
      return new LogsData(resource_logs, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_LogsData extends ProtoAdapter<LogsData> {
    public ProtoAdapter_LogsData() {
      super(FieldEncoding.LENGTH_DELIMITED, LogsData.class, "type.googleapis.com/opentelemetry.proto.logs.v1.LogsData", Syntax.PROTO_3, null, "opentelemetry/proto/logs/v1/logs.proto");
    }

    @Override
    public int encodedSize(LogsData value) {
      int result = 0;
      result += ResourceLogs.ADAPTER.asRepeated().encodedSizeWithTag(1, value.resource_logs);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, LogsData value) throws IOException {
      ResourceLogs.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.resource_logs);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, LogsData value) throws IOException {
      writer.writeBytes(value.unknownFields());
      ResourceLogs.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.resource_logs);
    }

    @Override
    public LogsData decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.resource_logs.add(ResourceLogs.ADAPTER.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public LogsData redact(LogsData value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.resource_logs, ResourceLogs.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
