// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.logs.v1.ScopeLogs in opentelemetry/proto/logs/v1/logs.proto
package io.opentelemetry.proto.logs.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A collection of Logs produced by a Scope.
 */
public final class ScopeLogs extends Message<ScopeLogs, ScopeLogs.Builder> {
  public static final ProtoAdapter<ScopeLogs> ADAPTER = new ProtoAdapter_ScopeLogs();

  private static final long serialVersionUID = 0L;

  /**
   * The instrumentation scope information for the logs in this message.
   * Semantically when InstrumentationScope isn't set, it is equivalent with
   * an empty instrumentation scope name (unknown).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.InstrumentationScope#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final InstrumentationScope scope;

  /**
   * A list of log records.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.logs.v1.LogRecord#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "logRecords"
  )
  public final List<LogRecord> log_records;

  /**
   * The Schema URL, if known. This is the identifier of the Schema that the log data
   * is recorded in. To learn more about Schema URL see
   * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
   * This schema_url applies to all logs in the "logs" field.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "schemaUrl"
  )
  public final String schema_url;

  public ScopeLogs(InstrumentationScope scope, List<LogRecord> log_records, String schema_url) {
    this(scope, log_records, schema_url, ByteString.EMPTY);
  }

  public ScopeLogs(InstrumentationScope scope, List<LogRecord> log_records, String schema_url,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.scope = scope;
    this.log_records = Internal.immutableCopyOf("log_records", log_records);
    if (schema_url == null) {
      throw new IllegalArgumentException("schema_url == null");
    }
    this.schema_url = schema_url;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.scope = scope;
    builder.log_records = Internal.copyOf(log_records);
    builder.schema_url = schema_url;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ScopeLogs)) return false;
    ScopeLogs o = (ScopeLogs) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(scope, o.scope)
        && log_records.equals(o.log_records)
        && Internal.equals(schema_url, o.schema_url);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (scope != null ? scope.hashCode() : 0);
      result = result * 37 + log_records.hashCode();
      result = result * 37 + (schema_url != null ? schema_url.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (scope != null) builder.append(", scope=").append(scope);
    if (!log_records.isEmpty()) builder.append(", log_records=").append(log_records);
    if (schema_url != null) builder.append(", schema_url=").append(Internal.sanitize(schema_url));
    return builder.replace(0, 2, "ScopeLogs{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ScopeLogs, Builder> {
    public InstrumentationScope scope;

    public List<LogRecord> log_records;

    public String schema_url;

    public Builder() {
      log_records = Internal.newMutableList();
      schema_url = "";
    }

    /**
     * The instrumentation scope information for the logs in this message.
     * Semantically when InstrumentationScope isn't set, it is equivalent with
     * an empty instrumentation scope name (unknown).
     */
    public Builder scope(InstrumentationScope scope) {
      this.scope = scope;
      return this;
    }

    /**
     * A list of log records.
     */
    public Builder log_records(List<LogRecord> log_records) {
      Internal.checkElementsNotNull(log_records);
      this.log_records = log_records;
      return this;
    }

    /**
     * The Schema URL, if known. This is the identifier of the Schema that the log data
     * is recorded in. To learn more about Schema URL see
     * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
     * This schema_url applies to all logs in the "logs" field.
     */
    public Builder schema_url(String schema_url) {
      this.schema_url = schema_url;
      return this;
    }

    @Override
    public ScopeLogs build() {
      return new ScopeLogs(scope, log_records, schema_url, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ScopeLogs extends ProtoAdapter<ScopeLogs> {
    public ProtoAdapter_ScopeLogs() {
      super(FieldEncoding.LENGTH_DELIMITED, ScopeLogs.class, "type.googleapis.com/opentelemetry.proto.logs.v1.ScopeLogs", Syntax.PROTO_3, null, "opentelemetry/proto/logs/v1/logs.proto");
    }

    @Override
    public int encodedSize(ScopeLogs value) {
      int result = 0;
      if (!Objects.equals(value.scope, null)) {
        result += InstrumentationScope.ADAPTER.encodedSizeWithTag(1, value.scope);
      }
      result += LogRecord.ADAPTER.asRepeated().encodedSizeWithTag(2, value.log_records);
      if (!Objects.equals(value.schema_url, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.schema_url);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, ScopeLogs value) throws IOException {
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
      LogRecord.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.log_records);
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, ScopeLogs value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      LogRecord.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.log_records);
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
    }

    @Override
    public ScopeLogs decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.scope(InstrumentationScope.ADAPTER.decode(reader)); break;
          case 2: builder.log_records.add(LogRecord.ADAPTER.decode(reader)); break;
          case 3: builder.schema_url(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public ScopeLogs redact(ScopeLogs value) {
      Builder builder = value.newBuilder();
      if (builder.scope != null) builder.scope = InstrumentationScope.ADAPTER.redact(builder.scope);
      Internal.redactElements(builder.log_records, LogRecord.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
