// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.AggregationTemporality in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import java.lang.Override;

/**
 * AggregationTemporality defines how a metric aggregator reports aggregated
 * values. It describes how those values relate to the time interval over
 * which they are aggregated.
 */
public enum AggregationTemporality implements WireEnum {
  /**
   * UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
   */
  AGGREGATION_TEMPORALITY_UNSPECIFIED(0),

  /**
   * DELTA is an AggregationTemporality for a metric aggregator which reports
   * changes since last report time. Successive metrics contain aggregation of
   * values from continuous and non-overlapping intervals.
   *
   * The values for a DELTA metric are based only on the time interval
   * associated with one measurement cycle. There is no dependency on
   * previous measurements like is the case for CUMULATIVE metrics.
   *
   * For example, consider a system measuring the number of requests that
   * it receives and reports the sum of these requests every second as a
   * DELTA metric:
   *
   *   1. The system starts receiving at time=t_0.
   *   2. A request is received, the system measures 1 request.
   *   3. A request is received, the system measures 1 request.
   *   4. A request is received, the system measures 1 request.
   *   5. The 1 second collection cycle ends. A metric is exported for the
   *      number of requests received over the interval of time t_0 to
   *      t_0+1 with a value of 3.
   *   6. A request is received, the system measures 1 request.
   *   7. A request is received, the system measures 1 request.
   *   8. The 1 second collection cycle ends. A metric is exported for the
   *      number of requests received over the interval of time t_0+1 to
   *      t_0+2 with a value of 2.
   */
  AGGREGATION_TEMPORALITY_DELTA(1),

  /**
   * CUMULATIVE is an AggregationTemporality for a metric aggregator which
   * reports changes since a fixed start time. This means that current values
   * of a CUMULATIVE metric depend on all previous measurements since the
   * start time. Because of this, the sender is required to retain this state
   * in some form. If this state is lost or invalidated, the CUMULATIVE metric
   * values MUST be reset and a new fixed start time following the last
   * reported measurement time sent MUST be used.
   *
   * For example, consider a system measuring the number of requests that
   * it receives and reports the sum of these requests every second as a
   * CUMULATIVE metric:
   *
   *   1. The system starts receiving at time=t_0.
   *   2. A request is received, the system measures 1 request.
   *   3. A request is received, the system measures 1 request.
   *   4. A request is received, the system measures 1 request.
   *   5. The 1 second collection cycle ends. A metric is exported for the
   *      number of requests received over the interval of time t_0 to
   *      t_0+1 with a value of 3.
   *   6. A request is received, the system measures 1 request.
   *   7. A request is received, the system measures 1 request.
   *   8. The 1 second collection cycle ends. A metric is exported for the
   *      number of requests received over the interval of time t_0 to
   *      t_0+2 with a value of 5.
   *   9. The system experiences a fault and loses state.
   *   10. The system recovers and resumes receiving at time=t_1.
   *   11. A request is received, the system measures 1 request.
   *   12. The 1 second collection cycle ends. A metric is exported for the
   *      number of requests received over the interval of time t_1 to
   *      t_0+1 with a value of 1.
   *
   * Note: Even though, when reporting changes since last report time, using
   * CUMULATIVE is valid, it is not recommended. This may cause problems for
   * systems that do not use start_time to determine when the aggregation
   * value was reset (e.g. Prometheus).
   */
  AGGREGATION_TEMPORALITY_CUMULATIVE(2);

  public static final ProtoAdapter<AggregationTemporality> ADAPTER = new ProtoAdapter_AggregationTemporality();

  private final int value;

  AggregationTemporality(int value) {
    this.value = value;
  }

  /**
   * Return the constant for {@code value} or null.
   */
  public static AggregationTemporality fromValue(int value) {
    switch (value) {
      case 0: return AGGREGATION_TEMPORALITY_UNSPECIFIED;
      case 1: return AGGREGATION_TEMPORALITY_DELTA;
      case 2: return AGGREGATION_TEMPORALITY_CUMULATIVE;
      default: return null;
    }
  }

  @Override
  public int getValue() {
    return value;
  }

  private static final class ProtoAdapter_AggregationTemporality extends EnumAdapter<AggregationTemporality> {
    ProtoAdapter_AggregationTemporality() {
      super(AggregationTemporality.class, Syntax.PROTO_3, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED);
    }

    @Override
    protected AggregationTemporality fromValue(int value) {
      return AggregationTemporality.fromValue(value);
    }
  }
}
