// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.Exemplar in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Double;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A representation of an exemplar, which is a sample input measurement.
 * Exemplars also hold information about the environment when the measurement
 * was recorded, for example the span and trace ID of the active span when the
 * exemplar was recorded.
 */
public final class Exemplar extends Message<Exemplar, Exemplar.Builder> {
  public static final ProtoAdapter<Exemplar> ADAPTER = new ProtoAdapter_Exemplar();

  private static final long serialVersionUID = 0L;

  public static final Double DEFAULT_AS_DOUBLE = 0.0d;

  public static final Long DEFAULT_AS_INT = 0L;

  /**
   * The set of key/value pairs that were filtered out by the aggregator, but
   * recorded alongside the original measurement. Only key/value pairs that were
   * filtered out by the aggregator should be included
   */
  @WireField(
      tag = 7,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "filteredAttributes"
  )
  public final List<KeyValue> filtered_attributes;

  /**
   * time_unix_nano is the exact time when this exemplar was recorded
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * (Optional) Span ID of the exemplar trace.
   * span_id may be missing if the measurement is not recorded inside a trace
   * or if the trace is not sampled.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "spanId"
  )
  public final ByteString span_id;

  /**
   * (Optional) Trace ID of the exemplar trace.
   * trace_id may be missing if the measurement is not recorded inside a trace
   * or if the trace is not sampled.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "traceId"
  )
  public final ByteString trace_id;

  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      jsonName = "asDouble",
      oneofName = "value"
  )
  public final Double as_double;

  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#SFIXED64",
      jsonName = "asInt",
      oneofName = "value"
  )
  public final Long as_int;

  public Exemplar(List<KeyValue> filtered_attributes, long time_unix_nano, ByteString span_id,
      ByteString trace_id, Double as_double, Long as_int) {
    this(filtered_attributes, time_unix_nano, span_id, trace_id, as_double, as_int, ByteString.EMPTY);
  }

  public Exemplar(List<KeyValue> filtered_attributes, long time_unix_nano, ByteString span_id,
      ByteString trace_id, Double as_double, Long as_int, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (Internal.countNonNull(as_double, as_int) > 1) {
      throw new IllegalArgumentException("at most one of as_double, as_int may be non-null");
    }
    this.filtered_attributes = Internal.immutableCopyOf("filtered_attributes", filtered_attributes);
    this.time_unix_nano = time_unix_nano;
    if (span_id == null) {
      throw new IllegalArgumentException("span_id == null");
    }
    this.span_id = span_id;
    if (trace_id == null) {
      throw new IllegalArgumentException("trace_id == null");
    }
    this.trace_id = trace_id;
    this.as_double = as_double;
    this.as_int = as_int;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.filtered_attributes = Internal.copyOf(filtered_attributes);
    builder.time_unix_nano = time_unix_nano;
    builder.span_id = span_id;
    builder.trace_id = trace_id;
    builder.as_double = as_double;
    builder.as_int = as_int;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Exemplar)) return false;
    Exemplar o = (Exemplar) other;
    return unknownFields().equals(o.unknownFields())
        && filtered_attributes.equals(o.filtered_attributes)
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && Internal.equals(span_id, o.span_id)
        && Internal.equals(trace_id, o.trace_id)
        && Internal.equals(as_double, o.as_double)
        && Internal.equals(as_int, o.as_int);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + filtered_attributes.hashCode();
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + (span_id != null ? span_id.hashCode() : 0);
      result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
      result = result * 37 + (as_double != null ? as_double.hashCode() : 0);
      result = result * 37 + (as_int != null ? as_int.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!filtered_attributes.isEmpty()) builder.append(", filtered_attributes=").append(filtered_attributes);
    builder.append(", time_unix_nano=").append(time_unix_nano);
    if (span_id != null) builder.append(", span_id=").append(span_id);
    if (trace_id != null) builder.append(", trace_id=").append(trace_id);
    if (as_double != null) builder.append(", as_double=").append(as_double);
    if (as_int != null) builder.append(", as_int=").append(as_int);
    return builder.replace(0, 2, "Exemplar{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Exemplar, Builder> {
    public List<KeyValue> filtered_attributes;

    public long time_unix_nano;

    public ByteString span_id;

    public ByteString trace_id;

    public Double as_double;

    public Long as_int;

    public Builder() {
      filtered_attributes = Internal.newMutableList();
      time_unix_nano = 0L;
      span_id = ByteString.EMPTY;
      trace_id = ByteString.EMPTY;
    }

    /**
     * The set of key/value pairs that were filtered out by the aggregator, but
     * recorded alongside the original measurement. Only key/value pairs that were
     * filtered out by the aggregator should be included
     */
    public Builder filtered_attributes(List<KeyValue> filtered_attributes) {
      Internal.checkElementsNotNull(filtered_attributes);
      this.filtered_attributes = filtered_attributes;
      return this;
    }

    /**
     * time_unix_nano is the exact time when this exemplar was recorded
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * (Optional) Span ID of the exemplar trace.
     * span_id may be missing if the measurement is not recorded inside a trace
     * or if the trace is not sampled.
     */
    public Builder span_id(ByteString span_id) {
      this.span_id = span_id;
      return this;
    }

    /**
     * (Optional) Trace ID of the exemplar trace.
     * trace_id may be missing if the measurement is not recorded inside a trace
     * or if the trace is not sampled.
     */
    public Builder trace_id(ByteString trace_id) {
      this.trace_id = trace_id;
      return this;
    }

    public Builder as_double(Double as_double) {
      this.as_double = as_double;
      this.as_int = null;
      return this;
    }

    public Builder as_int(Long as_int) {
      this.as_int = as_int;
      this.as_double = null;
      return this;
    }

    @Override
    public Exemplar build() {
      return new Exemplar(filtered_attributes, time_unix_nano, span_id, trace_id, as_double, as_int, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Exemplar extends ProtoAdapter<Exemplar> {
    public ProtoAdapter_Exemplar() {
      super(FieldEncoding.LENGTH_DELIMITED, Exemplar.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.Exemplar", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(Exemplar value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(7, value.filtered_attributes);
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(2, value.time_unix_nano);
      }
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(4, value.span_id);
      }
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(5, value.trace_id);
      }
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(3, value.as_double);
      result += ProtoAdapter.SFIXED64.encodedSizeWithTag(6, value.as_int);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Exemplar value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.filtered_attributes);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.time_unix_nano);
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.span_id);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 5, value.trace_id);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 3, value.as_double);
      ProtoAdapter.SFIXED64.encodeWithTag(writer, 6, value.as_int);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Exemplar value) throws IOException {
      writer.writeBytes(value.unknownFields());
      ProtoAdapter.SFIXED64.encodeWithTag(writer, 6, value.as_int);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 3, value.as_double);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 5, value.trace_id);
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.span_id);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.filtered_attributes);
    }

    @Override
    public Exemplar decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 2: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 3: builder.as_double(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 4: builder.span_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 5: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 6: builder.as_int(ProtoAdapter.SFIXED64.decode(reader)); break;
          case 7: builder.filtered_attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Exemplar redact(Exemplar value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.filtered_attributes, KeyValue.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
