// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
 * time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
 * summary statistics for a population of values, it may optionally contain the
 * distribution of those values across a set of buckets.
 */
public final class ExponentialHistogramDataPoint extends Message<ExponentialHistogramDataPoint, ExponentialHistogramDataPoint.Builder> {
  public static final ProtoAdapter<ExponentialHistogramDataPoint> ADAPTER = new ProtoAdapter_ExponentialHistogramDataPoint();

  private static final long serialVersionUID = 0L;

  public static final Double DEFAULT_SUM = 0.0d;

  public static final Double DEFAULT_MIN = 0.0d;

  public static final Double DEFAULT_MAX = 0.0d;

  /**
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * StartTimeUnixNano is optional but strongly encouraged, see the
   * the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "startTimeUnixNano"
  )
  public final long start_time_unix_nano;

  /**
   * TimeUnixNano is required, see the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * count is the number of values in the population. Must be
   * non-negative. This value must be equal to the sum of the "bucket_counts"
   * values in the positive and negative Buckets plus the "zero_count" field.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final long count;

  /**
   * sum of the values in the population. If count is zero then this field
   * must be zero.
   *
   * Note: Sum should only be filled out when measuring non-negative discrete
   * events, and is assumed to be monotonic over the values of these events.
   * Negative events *can* be recorded, but sum should not be filled out when
   * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
   * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double sum;

  /**
   * scale describes the resolution of the histogram.  Boundaries are
   * located at powers of the base, where:
   *
   *   base = (2^(2^-scale))
   *
   * The histogram bucket identified by `index`, a signed integer,
   * contains values that are greater than (base^index) and
   * less than or equal to (base^(index+1)).
   *
   * The positive and negative ranges of the histogram are expressed
   * separately.  Negative values are mapped by their absolute value
   * into the negative range using the same scale as the positive range.
   *
   * scale is not restricted by the protocol, as the permissible
   * values depend on the range of the data.
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#SINT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int scale;

  /**
   * zero_count is the count of values that are either exactly zero or
   * within the region considered zero by the instrumentation at the
   * tolerated degree of precision.  This bucket stores values that
   * cannot be expressed using the standard exponential formula as
   * well as values that have been rounded to zero.
   *
   * Implementations MAY consider the zero bucket to have probability
   * mass equal to (zero_count / count).
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "zeroCount"
  )
  public final long zero_count;

  /**
   * positive carries the positive range of exponential bucket counts.
   */
  @WireField(
      tag = 8,
      adapter = "io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint$Buckets#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final Buckets positive;

  /**
   * negative carries the negative range of exponential bucket counts.
   */
  @WireField(
      tag = 9,
      adapter = "io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint$Buckets#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final Buckets negative;

  /**
   * Flags that apply to this specific data point.  See DataPointFlags
   * for the available flags and their meaning.
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  /**
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   */
  @WireField(
      tag = 11,
      adapter = "io.opentelemetry.proto.metrics.v1.Exemplar#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Exemplar> exemplars;

  /**
   * min is the minimum value over (start_time, end_time].
   */
  @WireField(
      tag = 12,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double min;

  /**
   * max is the maximum value over (start_time, end_time].
   */
  @WireField(
      tag = 13,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double max;

  /**
   * ZeroThreshold may be optionally set to convey the width of the zero
   * region. Where the zero region is defined as the closed interval
   * [-ZeroThreshold, ZeroThreshold].
   * When ZeroThreshold is 0, zero count bucket stores values that cannot be
   * expressed using the standard exponential formula as well as values that
   * have been rounded to zero.
   */
  @WireField(
      tag = 14,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "zeroThreshold"
  )
  public final double zero_threshold;

  public ExponentialHistogramDataPoint(List<KeyValue> attributes, long start_time_unix_nano,
      long time_unix_nano, long count, Double sum, int scale, long zero_count, Buckets positive,
      Buckets negative, int flags, List<Exemplar> exemplars, Double min, Double max,
      double zero_threshold) {
    this(attributes, start_time_unix_nano, time_unix_nano, count, sum, scale, zero_count, positive, negative, flags, exemplars, min, max, zero_threshold, ByteString.EMPTY);
  }

  public ExponentialHistogramDataPoint(List<KeyValue> attributes, long start_time_unix_nano,
      long time_unix_nano, long count, Double sum, int scale, long zero_count, Buckets positive,
      Buckets negative, int flags, List<Exemplar> exemplars, Double min, Double max,
      double zero_threshold, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.start_time_unix_nano = start_time_unix_nano;
    this.time_unix_nano = time_unix_nano;
    this.count = count;
    this.sum = sum;
    this.scale = scale;
    this.zero_count = zero_count;
    this.positive = positive;
    this.negative = negative;
    this.flags = flags;
    this.exemplars = Internal.immutableCopyOf("exemplars", exemplars);
    this.min = min;
    this.max = max;
    this.zero_threshold = zero_threshold;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.attributes = Internal.copyOf(attributes);
    builder.start_time_unix_nano = start_time_unix_nano;
    builder.time_unix_nano = time_unix_nano;
    builder.count = count;
    builder.sum = sum;
    builder.scale = scale;
    builder.zero_count = zero_count;
    builder.positive = positive;
    builder.negative = negative;
    builder.flags = flags;
    builder.exemplars = Internal.copyOf(exemplars);
    builder.min = min;
    builder.max = max;
    builder.zero_threshold = zero_threshold;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ExponentialHistogramDataPoint)) return false;
    ExponentialHistogramDataPoint o = (ExponentialHistogramDataPoint) other;
    return unknownFields().equals(o.unknownFields())
        && attributes.equals(o.attributes)
        && Internal.equals(start_time_unix_nano, o.start_time_unix_nano)
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && Internal.equals(count, o.count)
        && Internal.equals(sum, o.sum)
        && Internal.equals(scale, o.scale)
        && Internal.equals(zero_count, o.zero_count)
        && Internal.equals(positive, o.positive)
        && Internal.equals(negative, o.negative)
        && Internal.equals(flags, o.flags)
        && exemplars.equals(o.exemplars)
        && Internal.equals(min, o.min)
        && Internal.equals(max, o.max)
        && Internal.equals(zero_threshold, o.zero_threshold);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Long.hashCode(start_time_unix_nano);
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + Long.hashCode(count);
      result = result * 37 + (sum != null ? sum.hashCode() : 0);
      result = result * 37 + Integer.hashCode(scale);
      result = result * 37 + Long.hashCode(zero_count);
      result = result * 37 + (positive != null ? positive.hashCode() : 0);
      result = result * 37 + (negative != null ? negative.hashCode() : 0);
      result = result * 37 + Integer.hashCode(flags);
      result = result * 37 + exemplars.hashCode();
      result = result * 37 + (min != null ? min.hashCode() : 0);
      result = result * 37 + (max != null ? max.hashCode() : 0);
      result = result * 37 + Double.hashCode(zero_threshold);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", start_time_unix_nano=").append(start_time_unix_nano);
    builder.append(", time_unix_nano=").append(time_unix_nano);
    builder.append(", count=").append(count);
    if (sum != null) builder.append(", sum=").append(sum);
    builder.append(", scale=").append(scale);
    builder.append(", zero_count=").append(zero_count);
    if (positive != null) builder.append(", positive=").append(positive);
    if (negative != null) builder.append(", negative=").append(negative);
    builder.append(", flags=").append(flags);
    if (!exemplars.isEmpty()) builder.append(", exemplars=").append(exemplars);
    if (min != null) builder.append(", min=").append(min);
    if (max != null) builder.append(", max=").append(max);
    builder.append(", zero_threshold=").append(zero_threshold);
    return builder.replace(0, 2, "ExponentialHistogramDataPoint{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ExponentialHistogramDataPoint, Builder> {
    public List<KeyValue> attributes;

    public long start_time_unix_nano;

    public long time_unix_nano;

    public long count;

    public Double sum;

    public int scale;

    public long zero_count;

    public Buckets positive;

    public Buckets negative;

    public int flags;

    public List<Exemplar> exemplars;

    public Double min;

    public Double max;

    public double zero_threshold;

    public Builder() {
      attributes = Internal.newMutableList();
      start_time_unix_nano = 0L;
      time_unix_nano = 0L;
      count = 0L;
      scale = 0;
      zero_count = 0L;
      flags = 0;
      exemplars = Internal.newMutableList();
      zero_threshold = 0.0;
    }

    /**
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder start_time_unix_nano(long start_time_unix_nano) {
      this.start_time_unix_nano = start_time_unix_nano;
      return this;
    }

    /**
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * count is the number of values in the population. Must be
     * non-negative. This value must be equal to the sum of the "bucket_counts"
     * values in the positive and negative Buckets plus the "zero_count" field.
     */
    public Builder count(long count) {
      this.count = count;
      return this;
    }

    /**
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     */
    public Builder sum(Double sum) {
      this.sum = sum;
      return this;
    }

    /**
     * scale describes the resolution of the histogram.  Boundaries are
     * located at powers of the base, where:
     *
     *   base = (2^(2^-scale))
     *
     * The histogram bucket identified by `index`, a signed integer,
     * contains values that are greater than (base^index) and
     * less than or equal to (base^(index+1)).
     *
     * The positive and negative ranges of the histogram are expressed
     * separately.  Negative values are mapped by their absolute value
     * into the negative range using the same scale as the positive range.
     *
     * scale is not restricted by the protocol, as the permissible
     * values depend on the range of the data.
     */
    public Builder scale(int scale) {
      this.scale = scale;
      return this;
    }

    /**
     * zero_count is the count of values that are either exactly zero or
     * within the region considered zero by the instrumentation at the
     * tolerated degree of precision.  This bucket stores values that
     * cannot be expressed using the standard exponential formula as
     * well as values that have been rounded to zero.
     *
     * Implementations MAY consider the zero bucket to have probability
     * mass equal to (zero_count / count).
     */
    public Builder zero_count(long zero_count) {
      this.zero_count = zero_count;
      return this;
    }

    /**
     * positive carries the positive range of exponential bucket counts.
     */
    public Builder positive(Buckets positive) {
      this.positive = positive;
      return this;
    }

    /**
     * negative carries the negative range of exponential bucket counts.
     */
    public Builder negative(Buckets negative) {
      this.negative = negative;
      return this;
    }

    /**
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    /**
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     */
    public Builder exemplars(List<Exemplar> exemplars) {
      Internal.checkElementsNotNull(exemplars);
      this.exemplars = exemplars;
      return this;
    }

    /**
     * min is the minimum value over (start_time, end_time].
     */
    public Builder min(Double min) {
      this.min = min;
      return this;
    }

    /**
     * max is the maximum value over (start_time, end_time].
     */
    public Builder max(Double max) {
      this.max = max;
      return this;
    }

    /**
     * ZeroThreshold may be optionally set to convey the width of the zero
     * region. Where the zero region is defined as the closed interval
     * [-ZeroThreshold, ZeroThreshold].
     * When ZeroThreshold is 0, zero count bucket stores values that cannot be
     * expressed using the standard exponential formula as well as values that
     * have been rounded to zero.
     */
    public Builder zero_threshold(double zero_threshold) {
      this.zero_threshold = zero_threshold;
      return this;
    }

    @Override
    public ExponentialHistogramDataPoint build() {
      return new ExponentialHistogramDataPoint(attributes, start_time_unix_nano, time_unix_nano, count, sum, scale, zero_count, positive, negative, flags, exemplars, min, max, zero_threshold, super.buildUnknownFields());
    }
  }

  /**
   * Buckets are a set of bucket counts, encoded in a contiguous array
   * of counts.
   */
  public static final class Buckets extends Message<Buckets, Buckets.Builder> {
    public static final ProtoAdapter<Buckets> ADAPTER = new ProtoAdapter_Buckets();

    private static final long serialVersionUID = 0L;

    /**
     * Offset is the bucket index of the first entry in the bucket_counts array.
     *
     * Note: This uses a varint encoding as a simple form of compression.
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#SINT32",
        label = WireField.Label.OMIT_IDENTITY
    )
    public final int offset;

    /**
     * bucket_counts is an array of count values, where bucket_counts[i] carries
     * the count of the bucket at index (offset+i). bucket_counts[i] is the count
     * of values greater than base^(offset+i) and less than or equal to
     * base^(offset+i+1).
     *
     * Note: By contrast, the explicit HistogramDataPoint uses
     * fixed64.  This field is expected to have many buckets,
     * especially zeros, so uint64 has been selected to ensure
     * varint encoding.
     */
    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#UINT64",
        label = WireField.Label.PACKED,
        jsonName = "bucketCounts"
    )
    public final List<Long> bucket_counts;

    public Buckets(int offset, List<Long> bucket_counts) {
      this(offset, bucket_counts, ByteString.EMPTY);
    }

    public Buckets(int offset, List<Long> bucket_counts, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.offset = offset;
      this.bucket_counts = Internal.immutableCopyOf("bucket_counts", bucket_counts);
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.offset = offset;
      builder.bucket_counts = Internal.copyOf(bucket_counts);
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof Buckets)) return false;
      Buckets o = (Buckets) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(offset, o.offset)
          && bucket_counts.equals(o.bucket_counts);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + Integer.hashCode(offset);
        result = result * 37 + bucket_counts.hashCode();
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append(", offset=").append(offset);
      if (!bucket_counts.isEmpty()) builder.append(", bucket_counts=").append(bucket_counts);
      return builder.replace(0, 2, "Buckets{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<Buckets, Builder> {
      public int offset;

      public List<Long> bucket_counts;

      public Builder() {
        offset = 0;
        bucket_counts = Internal.newMutableList();
      }

      /**
       * Offset is the bucket index of the first entry in the bucket_counts array.
       *
       * Note: This uses a varint encoding as a simple form of compression.
       */
      public Builder offset(int offset) {
        this.offset = offset;
        return this;
      }

      /**
       * bucket_counts is an array of count values, where bucket_counts[i] carries
       * the count of the bucket at index (offset+i). bucket_counts[i] is the count
       * of values greater than base^(offset+i) and less than or equal to
       * base^(offset+i+1).
       *
       * Note: By contrast, the explicit HistogramDataPoint uses
       * fixed64.  This field is expected to have many buckets,
       * especially zeros, so uint64 has been selected to ensure
       * varint encoding.
       */
      public Builder bucket_counts(List<Long> bucket_counts) {
        Internal.checkElementsNotNull(bucket_counts);
        this.bucket_counts = bucket_counts;
        return this;
      }

      @Override
      public Buckets build() {
        return new Buckets(offset, bucket_counts, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_Buckets extends ProtoAdapter<Buckets> {
      public ProtoAdapter_Buckets() {
        super(FieldEncoding.LENGTH_DELIMITED, Buckets.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint.Buckets", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
      }

      @Override
      public int encodedSize(Buckets value) {
        int result = 0;
        if (!Objects.equals(value.offset, 0)) {
          result += ProtoAdapter.SINT32.encodedSizeWithTag(1, value.offset);
        }
        result += ProtoAdapter.UINT64.asPacked().encodedSizeWithTag(2, value.bucket_counts);
        result += value.unknownFields().size();
        return result;
      }

      @Override
      public void encode(ProtoWriter writer, Buckets value) throws IOException {
        if (!Objects.equals(value.offset, 0)) ProtoAdapter.SINT32.encodeWithTag(writer, 1, value.offset);
        ProtoAdapter.UINT64.asPacked().encodeWithTag(writer, 2, value.bucket_counts);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public void encode(ReverseProtoWriter writer, Buckets value) throws IOException {
        writer.writeBytes(value.unknownFields());
        ProtoAdapter.UINT64.asPacked().encodeWithTag(writer, 2, value.bucket_counts);
        if (!Objects.equals(value.offset, 0)) ProtoAdapter.SINT32.encodeWithTag(writer, 1, value.offset);
      }

      @Override
      public Buckets decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.offset(ProtoAdapter.SINT32.decode(reader)); break;
            case 2: builder.bucket_counts.add(ProtoAdapter.UINT64.decode(reader)); break;
            default: {
              reader.readUnknownField(tag);
            }
          }
        }
        builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
        return builder.build();
      }

      @Override
      public Buckets redact(Buckets value) {
        Builder builder = value.newBuilder();
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  private static final class ProtoAdapter_ExponentialHistogramDataPoint extends ProtoAdapter<ExponentialHistogramDataPoint> {
    public ProtoAdapter_ExponentialHistogramDataPoint() {
      super(FieldEncoding.LENGTH_DELIMITED, ExponentialHistogramDataPoint.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(ExponentialHistogramDataPoint value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(1, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(2, value.start_time_unix_nano);
      }
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(3, value.time_unix_nano);
      }
      if (!Objects.equals(value.count, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(4, value.count);
      }
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(5, value.sum);
      if (!Objects.equals(value.scale, 0)) {
        result += ProtoAdapter.SINT32.encodedSizeWithTag(6, value.scale);
      }
      if (!Objects.equals(value.zero_count, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(7, value.zero_count);
      }
      if (!Objects.equals(value.positive, null)) {
        result += Buckets.ADAPTER.encodedSizeWithTag(8, value.positive);
      }
      if (!Objects.equals(value.negative, null)) {
        result += Buckets.ADAPTER.encodedSizeWithTag(9, value.negative);
      }
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(10, value.flags);
      }
      result += Exemplar.ADAPTER.asRepeated().encodedSizeWithTag(11, value.exemplars);
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(12, value.min);
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(13, value.max);
      if (!Objects.equals(value.zero_threshold, 0.0)) {
        result += ProtoAdapter.DOUBLE.encodedSizeWithTag(14, value.zero_threshold);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, ExponentialHistogramDataPoint value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      if (!Objects.equals(value.scale, 0)) ProtoAdapter.SINT32.encodeWithTag(writer, 6, value.scale);
      if (!Objects.equals(value.zero_count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 7, value.zero_count);
      if (!Objects.equals(value.positive, null)) Buckets.ADAPTER.encodeWithTag(writer, 8, value.positive);
      if (!Objects.equals(value.negative, null)) Buckets.ADAPTER.encodeWithTag(writer, 9, value.negative);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.flags);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.exemplars);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 12, value.min);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 13, value.max);
      if (!Objects.equals(value.zero_threshold, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 14, value.zero_threshold);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, ExponentialHistogramDataPoint value) throws
        IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.zero_threshold, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 14, value.zero_threshold);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 13, value.max);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 12, value.min);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.exemplars);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.flags);
      if (!Objects.equals(value.negative, null)) Buckets.ADAPTER.encodeWithTag(writer, 9, value.negative);
      if (!Objects.equals(value.positive, null)) Buckets.ADAPTER.encodeWithTag(writer, 8, value.positive);
      if (!Objects.equals(value.zero_count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 7, value.zero_count);
      if (!Objects.equals(value.scale, 0)) ProtoAdapter.SINT32.encodeWithTag(writer, 6, value.scale);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.attributes);
    }

    @Override
    public ExponentialHistogramDataPoint decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 2: builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 3: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 4: builder.count(ProtoAdapter.FIXED64.decode(reader)); break;
          case 5: builder.sum(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 6: builder.scale(ProtoAdapter.SINT32.decode(reader)); break;
          case 7: builder.zero_count(ProtoAdapter.FIXED64.decode(reader)); break;
          case 8: builder.positive(Buckets.ADAPTER.decode(reader)); break;
          case 9: builder.negative(Buckets.ADAPTER.decode(reader)); break;
          case 10: builder.flags(ProtoAdapter.UINT32.decode(reader)); break;
          case 11: builder.exemplars.add(Exemplar.ADAPTER.decode(reader)); break;
          case 12: builder.min(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 13: builder.max(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 14: builder.zero_threshold(ProtoAdapter.DOUBLE.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public ExponentialHistogramDataPoint redact(ExponentialHistogramDataPoint value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      if (builder.positive != null) builder.positive = Buckets.ADAPTER.redact(builder.positive);
      if (builder.negative != null) builder.negative = Buckets.ADAPTER.redact(builder.negative);
      Internal.redactElements(builder.exemplars, Exemplar.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
