// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.Histogram in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * Histogram represents the type of a metric that is calculated by aggregating
 * as a Histogram of all reported measurements over a time interval.
 */
public final class Histogram extends Message<Histogram, Histogram.Builder> {
  public static final ProtoAdapter<Histogram> ADAPTER = new ProtoAdapter_Histogram();

  private static final long serialVersionUID = 0L;

  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.metrics.v1.HistogramDataPoint#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "dataPoints"
  )
  public final List<HistogramDataPoint> data_points;

  /**
   * aggregation_temporality describes if the aggregator reports delta changes
   * since last report time, or cumulative changes since a fixed start time.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.metrics.v1.AggregationTemporality#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "aggregationTemporality"
  )
  public final AggregationTemporality aggregation_temporality;

  public Histogram(List<HistogramDataPoint> data_points,
      AggregationTemporality aggregation_temporality) {
    this(data_points, aggregation_temporality, ByteString.EMPTY);
  }

  public Histogram(List<HistogramDataPoint> data_points,
      AggregationTemporality aggregation_temporality, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.data_points = Internal.immutableCopyOf("data_points", data_points);
    if (aggregation_temporality == null) {
      throw new IllegalArgumentException("aggregation_temporality == null");
    }
    this.aggregation_temporality = aggregation_temporality;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.data_points = Internal.copyOf(data_points);
    builder.aggregation_temporality = aggregation_temporality;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Histogram)) return false;
    Histogram o = (Histogram) other;
    return unknownFields().equals(o.unknownFields())
        && data_points.equals(o.data_points)
        && Internal.equals(aggregation_temporality, o.aggregation_temporality);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + data_points.hashCode();
      result = result * 37 + (aggregation_temporality != null ? aggregation_temporality.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!data_points.isEmpty()) builder.append(", data_points=").append(data_points);
    if (aggregation_temporality != null) builder.append(", aggregation_temporality=").append(aggregation_temporality);
    return builder.replace(0, 2, "Histogram{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Histogram, Builder> {
    public List<HistogramDataPoint> data_points;

    public AggregationTemporality aggregation_temporality;

    public Builder() {
      data_points = Internal.newMutableList();
      aggregation_temporality = AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    public Builder data_points(List<HistogramDataPoint> data_points) {
      Internal.checkElementsNotNull(data_points);
      this.data_points = data_points;
      return this;
    }

    /**
     * aggregation_temporality describes if the aggregator reports delta changes
     * since last report time, or cumulative changes since a fixed start time.
     */
    public Builder aggregation_temporality(AggregationTemporality aggregation_temporality) {
      this.aggregation_temporality = aggregation_temporality;
      return this;
    }

    @Override
    public Histogram build() {
      return new Histogram(data_points, aggregation_temporality, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Histogram extends ProtoAdapter<Histogram> {
    public ProtoAdapter_Histogram() {
      super(FieldEncoding.LENGTH_DELIMITED, Histogram.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.Histogram", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(Histogram value) {
      int result = 0;
      result += HistogramDataPoint.ADAPTER.asRepeated().encodedSizeWithTag(1, value.data_points);
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) {
        result += AggregationTemporality.ADAPTER.encodedSizeWithTag(2, value.aggregation_temporality);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Histogram value) throws IOException {
      HistogramDataPoint.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.data_points);
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) AggregationTemporality.ADAPTER.encodeWithTag(writer, 2, value.aggregation_temporality);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Histogram value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) AggregationTemporality.ADAPTER.encodeWithTag(writer, 2, value.aggregation_temporality);
      HistogramDataPoint.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.data_points);
    }

    @Override
    public Histogram decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.data_points.add(HistogramDataPoint.ADAPTER.decode(reader)); break;
          case 2: {
            try {
              builder.aggregation_temporality(AggregationTemporality.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Histogram redact(Histogram value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.data_points, HistogramDataPoint.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
