// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.HistogramDataPoint in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * HistogramDataPoint is a single data point in a timeseries that describes the
 * time-varying values of a Histogram. A Histogram contains summary statistics
 * for a population of values, it may optionally contain the distribution of
 * those values across a set of buckets.
 *
 * If the histogram contains the distribution of values, then both
 * "explicit_bounds" and "bucket counts" fields must be defined.
 * If the histogram does not contain the distribution of values, then both
 * "explicit_bounds" and "bucket_counts" must be omitted and only "count" and
 * "sum" are known.
 */
public final class HistogramDataPoint extends Message<HistogramDataPoint, HistogramDataPoint.Builder> {
  public static final ProtoAdapter<HistogramDataPoint> ADAPTER = new ProtoAdapter_HistogramDataPoint();

  private static final long serialVersionUID = 0L;

  public static final Double DEFAULT_SUM = 0.0d;

  public static final Double DEFAULT_MIN = 0.0d;

  public static final Double DEFAULT_MAX = 0.0d;

  /**
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 9,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * StartTimeUnixNano is optional but strongly encouraged, see the
   * the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "startTimeUnixNano"
  )
  public final long start_time_unix_nano;

  /**
   * TimeUnixNano is required, see the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * count is the number of values in the population. Must be non-negative. This
   * value must be equal to the sum of the "count" fields in buckets if a
   * histogram is provided.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final long count;

  /**
   * sum of the values in the population. If count is zero then this field
   * must be zero.
   *
   * Note: Sum should only be filled out when measuring non-negative discrete
   * events, and is assumed to be monotonic over the values of these events.
   * Negative events *can* be recorded, but sum should not be filled out when
   * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
   * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double sum;

  /**
   * bucket_counts is an optional field contains the count values of histogram
   * for each bucket.
   *
   * The sum of the bucket_counts must equal the value in the count field.
   *
   * The number of elements in bucket_counts array must be by one greater than
   * the number of elements in explicit_bounds array.
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.PACKED,
      jsonName = "bucketCounts"
  )
  public final List<Long> bucket_counts;

  /**
   * explicit_bounds specifies buckets with explicitly defined bounds for values.
   *
   * The boundaries for bucket at index i are:
   *
   * (-infinity, explicit_bounds[i]] for i == 0
   * (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
   * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
   *
   * The values in the explicit_bounds array must be strictly increasing.
   *
   * Histogram buckets are inclusive of their upper boundary, except the last
   * bucket where the boundary is at infinity. This format is intentionally
   * compatible with the OpenMetrics histogram definition.
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      label = WireField.Label.PACKED,
      jsonName = "explicitBounds"
  )
  public final List<Double> explicit_bounds;

  /**
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   */
  @WireField(
      tag = 8,
      adapter = "io.opentelemetry.proto.metrics.v1.Exemplar#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Exemplar> exemplars;

  /**
   * Flags that apply to this specific data point.  See DataPointFlags
   * for the available flags and their meaning.
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  /**
   * min is the minimum value over (start_time, end_time].
   */
  @WireField(
      tag = 11,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double min;

  /**
   * max is the maximum value over (start_time, end_time].
   */
  @WireField(
      tag = 12,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE"
  )
  public final Double max;

  public HistogramDataPoint(List<KeyValue> attributes, long start_time_unix_nano,
      long time_unix_nano, long count, Double sum, List<Long> bucket_counts,
      List<Double> explicit_bounds, List<Exemplar> exemplars, int flags, Double min, Double max) {
    this(attributes, start_time_unix_nano, time_unix_nano, count, sum, bucket_counts, explicit_bounds, exemplars, flags, min, max, ByteString.EMPTY);
  }

  public HistogramDataPoint(List<KeyValue> attributes, long start_time_unix_nano,
      long time_unix_nano, long count, Double sum, List<Long> bucket_counts,
      List<Double> explicit_bounds, List<Exemplar> exemplars, int flags, Double min, Double max,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.start_time_unix_nano = start_time_unix_nano;
    this.time_unix_nano = time_unix_nano;
    this.count = count;
    this.sum = sum;
    this.bucket_counts = Internal.immutableCopyOf("bucket_counts", bucket_counts);
    this.explicit_bounds = Internal.immutableCopyOf("explicit_bounds", explicit_bounds);
    this.exemplars = Internal.immutableCopyOf("exemplars", exemplars);
    this.flags = flags;
    this.min = min;
    this.max = max;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.attributes = Internal.copyOf(attributes);
    builder.start_time_unix_nano = start_time_unix_nano;
    builder.time_unix_nano = time_unix_nano;
    builder.count = count;
    builder.sum = sum;
    builder.bucket_counts = Internal.copyOf(bucket_counts);
    builder.explicit_bounds = Internal.copyOf(explicit_bounds);
    builder.exemplars = Internal.copyOf(exemplars);
    builder.flags = flags;
    builder.min = min;
    builder.max = max;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof HistogramDataPoint)) return false;
    HistogramDataPoint o = (HistogramDataPoint) other;
    return unknownFields().equals(o.unknownFields())
        && attributes.equals(o.attributes)
        && Internal.equals(start_time_unix_nano, o.start_time_unix_nano)
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && Internal.equals(count, o.count)
        && Internal.equals(sum, o.sum)
        && bucket_counts.equals(o.bucket_counts)
        && explicit_bounds.equals(o.explicit_bounds)
        && exemplars.equals(o.exemplars)
        && Internal.equals(flags, o.flags)
        && Internal.equals(min, o.min)
        && Internal.equals(max, o.max);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Long.hashCode(start_time_unix_nano);
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + Long.hashCode(count);
      result = result * 37 + (sum != null ? sum.hashCode() : 0);
      result = result * 37 + bucket_counts.hashCode();
      result = result * 37 + explicit_bounds.hashCode();
      result = result * 37 + exemplars.hashCode();
      result = result * 37 + Integer.hashCode(flags);
      result = result * 37 + (min != null ? min.hashCode() : 0);
      result = result * 37 + (max != null ? max.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", start_time_unix_nano=").append(start_time_unix_nano);
    builder.append(", time_unix_nano=").append(time_unix_nano);
    builder.append(", count=").append(count);
    if (sum != null) builder.append(", sum=").append(sum);
    if (!bucket_counts.isEmpty()) builder.append(", bucket_counts=").append(bucket_counts);
    if (!explicit_bounds.isEmpty()) builder.append(", explicit_bounds=").append(explicit_bounds);
    if (!exemplars.isEmpty()) builder.append(", exemplars=").append(exemplars);
    builder.append(", flags=").append(flags);
    if (min != null) builder.append(", min=").append(min);
    if (max != null) builder.append(", max=").append(max);
    return builder.replace(0, 2, "HistogramDataPoint{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<HistogramDataPoint, Builder> {
    public List<KeyValue> attributes;

    public long start_time_unix_nano;

    public long time_unix_nano;

    public long count;

    public Double sum;

    public List<Long> bucket_counts;

    public List<Double> explicit_bounds;

    public List<Exemplar> exemplars;

    public int flags;

    public Double min;

    public Double max;

    public Builder() {
      attributes = Internal.newMutableList();
      start_time_unix_nano = 0L;
      time_unix_nano = 0L;
      count = 0L;
      bucket_counts = Internal.newMutableList();
      explicit_bounds = Internal.newMutableList();
      exemplars = Internal.newMutableList();
      flags = 0;
    }

    /**
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder start_time_unix_nano(long start_time_unix_nano) {
      this.start_time_unix_nano = start_time_unix_nano;
      return this;
    }

    /**
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * count is the number of values in the population. Must be non-negative. This
     * value must be equal to the sum of the "count" fields in buckets if a
     * histogram is provided.
     */
    public Builder count(long count) {
      this.count = count;
      return this;
    }

    /**
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#histogram
     */
    public Builder sum(Double sum) {
      this.sum = sum;
      return this;
    }

    /**
     * bucket_counts is an optional field contains the count values of histogram
     * for each bucket.
     *
     * The sum of the bucket_counts must equal the value in the count field.
     *
     * The number of elements in bucket_counts array must be by one greater than
     * the number of elements in explicit_bounds array.
     */
    public Builder bucket_counts(List<Long> bucket_counts) {
      Internal.checkElementsNotNull(bucket_counts);
      this.bucket_counts = bucket_counts;
      return this;
    }

    /**
     * explicit_bounds specifies buckets with explicitly defined bounds for values.
     *
     * The boundaries for bucket at index i are:
     *
     * (-infinity, explicit_bounds[i]] for i == 0
     * (explicit_bounds[i-1], explicit_bounds[i]] for 0 < i < size(explicit_bounds)
     * (explicit_bounds[i-1], +infinity) for i == size(explicit_bounds)
     *
     * The values in the explicit_bounds array must be strictly increasing.
     *
     * Histogram buckets are inclusive of their upper boundary, except the last
     * bucket where the boundary is at infinity. This format is intentionally
     * compatible with the OpenMetrics histogram definition.
     */
    public Builder explicit_bounds(List<Double> explicit_bounds) {
      Internal.checkElementsNotNull(explicit_bounds);
      this.explicit_bounds = explicit_bounds;
      return this;
    }

    /**
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     */
    public Builder exemplars(List<Exemplar> exemplars) {
      Internal.checkElementsNotNull(exemplars);
      this.exemplars = exemplars;
      return this;
    }

    /**
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    /**
     * min is the minimum value over (start_time, end_time].
     */
    public Builder min(Double min) {
      this.min = min;
      return this;
    }

    /**
     * max is the maximum value over (start_time, end_time].
     */
    public Builder max(Double max) {
      this.max = max;
      return this;
    }

    @Override
    public HistogramDataPoint build() {
      return new HistogramDataPoint(attributes, start_time_unix_nano, time_unix_nano, count, sum, bucket_counts, explicit_bounds, exemplars, flags, min, max, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_HistogramDataPoint extends ProtoAdapter<HistogramDataPoint> {
    public ProtoAdapter_HistogramDataPoint() {
      super(FieldEncoding.LENGTH_DELIMITED, HistogramDataPoint.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.HistogramDataPoint", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(HistogramDataPoint value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(9, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(2, value.start_time_unix_nano);
      }
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(3, value.time_unix_nano);
      }
      if (!Objects.equals(value.count, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(4, value.count);
      }
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(5, value.sum);
      result += ProtoAdapter.FIXED64.asPacked().encodedSizeWithTag(6, value.bucket_counts);
      result += ProtoAdapter.DOUBLE.asPacked().encodedSizeWithTag(7, value.explicit_bounds);
      result += Exemplar.ADAPTER.asRepeated().encodedSizeWithTag(8, value.exemplars);
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(10, value.flags);
      }
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(11, value.min);
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(12, value.max);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, HistogramDataPoint value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      ProtoAdapter.FIXED64.asPacked().encodeWithTag(writer, 6, value.bucket_counts);
      ProtoAdapter.DOUBLE.asPacked().encodeWithTag(writer, 7, value.explicit_bounds);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 8, value.exemplars);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.flags);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 11, value.min);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 12, value.max);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, HistogramDataPoint value) throws IOException {
      writer.writeBytes(value.unknownFields());
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 12, value.max);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 11, value.min);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.flags);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 8, value.exemplars);
      ProtoAdapter.DOUBLE.asPacked().encodeWithTag(writer, 7, value.explicit_bounds);
      ProtoAdapter.FIXED64.asPacked().encodeWithTag(writer, 6, value.bucket_counts);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
    }

    @Override
    public HistogramDataPoint decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 2: builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 3: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 4: builder.count(ProtoAdapter.FIXED64.decode(reader)); break;
          case 5: builder.sum(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 6: builder.bucket_counts.add(ProtoAdapter.FIXED64.decode(reader)); break;
          case 7: builder.explicit_bounds.add(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 8: builder.exemplars.add(Exemplar.ADAPTER.decode(reader)); break;
          case 9: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 10: builder.flags(ProtoAdapter.UINT32.decode(reader)); break;
          case 11: builder.min(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 12: builder.max(ProtoAdapter.DOUBLE.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public HistogramDataPoint redact(HistogramDataPoint value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      Internal.redactElements(builder.exemplars, Exemplar.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
