// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.Metric in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Objects;
import okio.ByteString;

/**
 * Defines a Metric which has one or more timeseries.  The following is a
 * brief summary of the Metric data model.  For more details, see:
 *
 *   https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md
 *
 *
 * The data model and relation between entities is shown in the
 * diagram below. Here, "DataPoint" is the term used to refer to any
 * one of the specific data point value types, and "points" is the term used
 * to refer to any one of the lists of points contained in the Metric.
 *
 * - Metric is composed of a metadata and data.
 * - Metadata part contains a name, description, unit.
 * - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
 * - DataPoint contains timestamps, attributes, and one of the possible value type
 *   fields.
 *
 *     Metric
 *  +------------+
 *  |name        |
 *  |description |
 *  |unit        |     +------------------------------------+
 *  |data        |---> |Gauge, Sum, Histogram, Summary, ... |
 *  +------------+     +------------------------------------+
 *
 *    Data [One of Gauge, Sum, Histogram, Summary, ...]
 *  +-----------+
 *  |...        |  // Metadata about the Data.
 *  |points     |--+
 *  +-----------+  |
 *                 |      +---------------------------+
 *                 |      |DataPoint 1                |
 *                 v      |+------+------+   +------+ |
 *              +-----+   ||label |label |...|label | |
 *              |  1  |-->||value1|value2|...|valueN| |
 *              +-----+   |+------+------+   +------+ |
 *              |  .  |   |+-----+                    |
 *              |  .  |   ||value|                    |
 *              |  .  |   |+-----+                    |
 *              |  .  |   +---------------------------+
 *              |  .  |                   .
 *              |  .  |                   .
 *              |  .  |                   .
 *              |  .  |   +---------------------------+
 *              |  .  |   |DataPoint M                |
 *              +-----+   |+------+------+   +------+ |
 *              |  M  |-->||label |label |...|label | |
 *              +-----+   ||value1|value2|...|valueN| |
 *                        |+------+------+   +------+ |
 *                        |+-----+                    |
 *                        ||value|                    |
 *                        |+-----+                    |
 *                        +---------------------------+
 *
 * Each distinct type of DataPoint represents the output of a specific
 * aggregation function, the result of applying the DataPoint's
 * associated function of to one or more measurements.
 *
 * All DataPoint types have three common fields:
 * - Attributes includes key-value pairs associated with the data point
 * - TimeUnixNano is required, set to the end time of the aggregation
 * - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
 *   having an AggregationTemporality field, as discussed below.
 *
 * Both TimeUnixNano and StartTimeUnixNano values are expressed as
 * UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
 *
 * # TimeUnixNano
 *
 * This field is required, having consistent interpretation across
 * DataPoint types.  TimeUnixNano is the moment corresponding to when
 * the data point's aggregate value was captured.
 *
 * Data points with the 0 value for TimeUnixNano SHOULD be rejected
 * by consumers.
 *
 * # StartTimeUnixNano
 *
 * StartTimeUnixNano in general allows detecting when a sequence of
 * observations is unbroken.  This field indicates to consumers the
 * start time for points with cumulative and delta
 * AggregationTemporality, and it should be included whenever possible
 * to support correct rate calculation.  Although it may be omitted
 * when the start time is truly unknown, setting StartTimeUnixNano is
 * strongly encouraged.
 */
public final class Metric extends Message<Metric, Metric.Builder> {
  public static final ProtoAdapter<Metric> ADAPTER = new ProtoAdapter_Metric();

  private static final long serialVersionUID = 0L;

  /**
   * name of the metric.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String name;

  /**
   * description of the metric, which can be used in documentation.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String description;

  /**
   * unit in which the metric value is reported. Follows the format
   * described by http://unitsofmeasure.org/ucum.html.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String unit;

  @WireField(
      tag = 5,
      adapter = "io.opentelemetry.proto.metrics.v1.Gauge#ADAPTER",
      oneofName = "data"
  )
  public final Gauge gauge;

  @WireField(
      tag = 7,
      adapter = "io.opentelemetry.proto.metrics.v1.Sum#ADAPTER",
      oneofName = "data"
  )
  public final Sum sum;

  @WireField(
      tag = 9,
      adapter = "io.opentelemetry.proto.metrics.v1.Histogram#ADAPTER",
      oneofName = "data"
  )
  public final Histogram histogram;

  @WireField(
      tag = 10,
      adapter = "io.opentelemetry.proto.metrics.v1.ExponentialHistogram#ADAPTER",
      jsonName = "exponentialHistogram",
      oneofName = "data"
  )
  public final ExponentialHistogram exponential_histogram;

  @WireField(
      tag = 11,
      adapter = "io.opentelemetry.proto.metrics.v1.Summary#ADAPTER",
      oneofName = "data"
  )
  public final Summary summary;

  public Metric(String name, String description, String unit, Gauge gauge, Sum sum,
      Histogram histogram, ExponentialHistogram exponential_histogram, Summary summary) {
    this(name, description, unit, gauge, sum, histogram, exponential_histogram, summary, ByteString.EMPTY);
  }

  public Metric(String name, String description, String unit, Gauge gauge, Sum sum,
      Histogram histogram, ExponentialHistogram exponential_histogram, Summary summary,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (Internal.countNonNull(gauge, sum, histogram, exponential_histogram, summary) > 1) {
      throw new IllegalArgumentException("at most one of gauge, sum, histogram, exponential_histogram, summary may be non-null");
    }
    if (name == null) {
      throw new IllegalArgumentException("name == null");
    }
    this.name = name;
    if (description == null) {
      throw new IllegalArgumentException("description == null");
    }
    this.description = description;
    if (unit == null) {
      throw new IllegalArgumentException("unit == null");
    }
    this.unit = unit;
    this.gauge = gauge;
    this.sum = sum;
    this.histogram = histogram;
    this.exponential_histogram = exponential_histogram;
    this.summary = summary;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.name = name;
    builder.description = description;
    builder.unit = unit;
    builder.gauge = gauge;
    builder.sum = sum;
    builder.histogram = histogram;
    builder.exponential_histogram = exponential_histogram;
    builder.summary = summary;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Metric)) return false;
    Metric o = (Metric) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(name, o.name)
        && Internal.equals(description, o.description)
        && Internal.equals(unit, o.unit)
        && Internal.equals(gauge, o.gauge)
        && Internal.equals(sum, o.sum)
        && Internal.equals(histogram, o.histogram)
        && Internal.equals(exponential_histogram, o.exponential_histogram)
        && Internal.equals(summary, o.summary);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (name != null ? name.hashCode() : 0);
      result = result * 37 + (description != null ? description.hashCode() : 0);
      result = result * 37 + (unit != null ? unit.hashCode() : 0);
      result = result * 37 + (gauge != null ? gauge.hashCode() : 0);
      result = result * 37 + (sum != null ? sum.hashCode() : 0);
      result = result * 37 + (histogram != null ? histogram.hashCode() : 0);
      result = result * 37 + (exponential_histogram != null ? exponential_histogram.hashCode() : 0);
      result = result * 37 + (summary != null ? summary.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (name != null) builder.append(", name=").append(Internal.sanitize(name));
    if (description != null) builder.append(", description=").append(Internal.sanitize(description));
    if (unit != null) builder.append(", unit=").append(Internal.sanitize(unit));
    if (gauge != null) builder.append(", gauge=").append(gauge);
    if (sum != null) builder.append(", sum=").append(sum);
    if (histogram != null) builder.append(", histogram=").append(histogram);
    if (exponential_histogram != null) builder.append(", exponential_histogram=").append(exponential_histogram);
    if (summary != null) builder.append(", summary=").append(summary);
    return builder.replace(0, 2, "Metric{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Metric, Builder> {
    public String name;

    public String description;

    public String unit;

    public Gauge gauge;

    public Sum sum;

    public Histogram histogram;

    public ExponentialHistogram exponential_histogram;

    public Summary summary;

    public Builder() {
      name = "";
      description = "";
      unit = "";
    }

    /**
     * name of the metric.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * description of the metric, which can be used in documentation.
     */
    public Builder description(String description) {
      this.description = description;
      return this;
    }

    /**
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     */
    public Builder unit(String unit) {
      this.unit = unit;
      return this;
    }

    public Builder gauge(Gauge gauge) {
      this.gauge = gauge;
      this.sum = null;
      this.histogram = null;
      this.exponential_histogram = null;
      this.summary = null;
      return this;
    }

    public Builder sum(Sum sum) {
      this.sum = sum;
      this.gauge = null;
      this.histogram = null;
      this.exponential_histogram = null;
      this.summary = null;
      return this;
    }

    public Builder histogram(Histogram histogram) {
      this.histogram = histogram;
      this.gauge = null;
      this.sum = null;
      this.exponential_histogram = null;
      this.summary = null;
      return this;
    }

    public Builder exponential_histogram(ExponentialHistogram exponential_histogram) {
      this.exponential_histogram = exponential_histogram;
      this.gauge = null;
      this.sum = null;
      this.histogram = null;
      this.summary = null;
      return this;
    }

    public Builder summary(Summary summary) {
      this.summary = summary;
      this.gauge = null;
      this.sum = null;
      this.histogram = null;
      this.exponential_histogram = null;
      return this;
    }

    @Override
    public Metric build() {
      return new Metric(name, description, unit, gauge, sum, histogram, exponential_histogram, summary, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Metric extends ProtoAdapter<Metric> {
    public ProtoAdapter_Metric() {
      super(FieldEncoding.LENGTH_DELIMITED, Metric.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.Metric", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(Metric value) {
      int result = 0;
      if (!Objects.equals(value.name, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(1, value.name);
      }
      if (!Objects.equals(value.description, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(2, value.description);
      }
      if (!Objects.equals(value.unit, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.unit);
      }
      result += Gauge.ADAPTER.encodedSizeWithTag(5, value.gauge);
      result += Sum.ADAPTER.encodedSizeWithTag(7, value.sum);
      result += Histogram.ADAPTER.encodedSizeWithTag(9, value.histogram);
      result += ExponentialHistogram.ADAPTER.encodedSizeWithTag(10, value.exponential_histogram);
      result += Summary.ADAPTER.encodedSizeWithTag(11, value.summary);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Metric value) throws IOException {
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
      if (!Objects.equals(value.description, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.description);
      if (!Objects.equals(value.unit, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.unit);
      Gauge.ADAPTER.encodeWithTag(writer, 5, value.gauge);
      Sum.ADAPTER.encodeWithTag(writer, 7, value.sum);
      Histogram.ADAPTER.encodeWithTag(writer, 9, value.histogram);
      ExponentialHistogram.ADAPTER.encodeWithTag(writer, 10, value.exponential_histogram);
      Summary.ADAPTER.encodeWithTag(writer, 11, value.summary);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Metric value) throws IOException {
      writer.writeBytes(value.unknownFields());
      Summary.ADAPTER.encodeWithTag(writer, 11, value.summary);
      ExponentialHistogram.ADAPTER.encodeWithTag(writer, 10, value.exponential_histogram);
      Histogram.ADAPTER.encodeWithTag(writer, 9, value.histogram);
      Sum.ADAPTER.encodeWithTag(writer, 7, value.sum);
      Gauge.ADAPTER.encodeWithTag(writer, 5, value.gauge);
      if (!Objects.equals(value.unit, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.unit);
      if (!Objects.equals(value.description, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.description);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
    }

    @Override
    public Metric decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.description(ProtoAdapter.STRING.decode(reader)); break;
          case 3: builder.unit(ProtoAdapter.STRING.decode(reader)); break;
          case 5: builder.gauge(Gauge.ADAPTER.decode(reader)); break;
          case 7: builder.sum(Sum.ADAPTER.decode(reader)); break;
          case 9: builder.histogram(Histogram.ADAPTER.decode(reader)); break;
          case 10: builder.exponential_histogram(ExponentialHistogram.ADAPTER.decode(reader)); break;
          case 11: builder.summary(Summary.ADAPTER.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Metric redact(Metric value) {
      Builder builder = value.newBuilder();
      if (builder.gauge != null) builder.gauge = Gauge.ADAPTER.redact(builder.gauge);
      if (builder.sum != null) builder.sum = Sum.ADAPTER.redact(builder.sum);
      if (builder.histogram != null) builder.histogram = Histogram.ADAPTER.redact(builder.histogram);
      if (builder.exponential_histogram != null) builder.exponential_histogram = ExponentialHistogram.ADAPTER.redact(builder.exponential_histogram);
      if (builder.summary != null) builder.summary = Summary.ADAPTER.redact(builder.summary);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
