// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.NumberDataPoint in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * NumberDataPoint is a single data point in a timeseries that describes the
 * time-varying scalar value of a metric.
 */
public final class NumberDataPoint extends Message<NumberDataPoint, NumberDataPoint.Builder> {
  public static final ProtoAdapter<NumberDataPoint> ADAPTER = new ProtoAdapter_NumberDataPoint();

  private static final long serialVersionUID = 0L;

  public static final Double DEFAULT_AS_DOUBLE = 0.0d;

  public static final Long DEFAULT_AS_INT = 0L;

  /**
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 7,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * StartTimeUnixNano is optional but strongly encouraged, see the
   * the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "startTimeUnixNano"
  )
  public final long start_time_unix_nano;

  /**
   * TimeUnixNano is required, see the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * (Optional) List of exemplars collected from
   * measurements that were used to form the data point
   */
  @WireField(
      tag = 5,
      adapter = "io.opentelemetry.proto.metrics.v1.Exemplar#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Exemplar> exemplars;

  /**
   * Flags that apply to this specific data point.  See DataPointFlags
   * for the available flags and their meaning.
   */
  @WireField(
      tag = 8,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      jsonName = "asDouble",
      oneofName = "value"
  )
  public final Double as_double;

  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#SFIXED64",
      jsonName = "asInt",
      oneofName = "value"
  )
  public final Long as_int;

  public NumberDataPoint(List<KeyValue> attributes, long start_time_unix_nano, long time_unix_nano,
      List<Exemplar> exemplars, int flags, Double as_double, Long as_int) {
    this(attributes, start_time_unix_nano, time_unix_nano, exemplars, flags, as_double, as_int, ByteString.EMPTY);
  }

  public NumberDataPoint(List<KeyValue> attributes, long start_time_unix_nano, long time_unix_nano,
      List<Exemplar> exemplars, int flags, Double as_double, Long as_int,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (Internal.countNonNull(as_double, as_int) > 1) {
      throw new IllegalArgumentException("at most one of as_double, as_int may be non-null");
    }
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.start_time_unix_nano = start_time_unix_nano;
    this.time_unix_nano = time_unix_nano;
    this.exemplars = Internal.immutableCopyOf("exemplars", exemplars);
    this.flags = flags;
    this.as_double = as_double;
    this.as_int = as_int;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.attributes = Internal.copyOf(attributes);
    builder.start_time_unix_nano = start_time_unix_nano;
    builder.time_unix_nano = time_unix_nano;
    builder.exemplars = Internal.copyOf(exemplars);
    builder.flags = flags;
    builder.as_double = as_double;
    builder.as_int = as_int;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof NumberDataPoint)) return false;
    NumberDataPoint o = (NumberDataPoint) other;
    return unknownFields().equals(o.unknownFields())
        && attributes.equals(o.attributes)
        && Internal.equals(start_time_unix_nano, o.start_time_unix_nano)
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && exemplars.equals(o.exemplars)
        && Internal.equals(flags, o.flags)
        && Internal.equals(as_double, o.as_double)
        && Internal.equals(as_int, o.as_int);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Long.hashCode(start_time_unix_nano);
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + exemplars.hashCode();
      result = result * 37 + Integer.hashCode(flags);
      result = result * 37 + (as_double != null ? as_double.hashCode() : 0);
      result = result * 37 + (as_int != null ? as_int.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", start_time_unix_nano=").append(start_time_unix_nano);
    builder.append(", time_unix_nano=").append(time_unix_nano);
    if (!exemplars.isEmpty()) builder.append(", exemplars=").append(exemplars);
    builder.append(", flags=").append(flags);
    if (as_double != null) builder.append(", as_double=").append(as_double);
    if (as_int != null) builder.append(", as_int=").append(as_int);
    return builder.replace(0, 2, "NumberDataPoint{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<NumberDataPoint, Builder> {
    public List<KeyValue> attributes;

    public long start_time_unix_nano;

    public long time_unix_nano;

    public List<Exemplar> exemplars;

    public int flags;

    public Double as_double;

    public Long as_int;

    public Builder() {
      attributes = Internal.newMutableList();
      start_time_unix_nano = 0L;
      time_unix_nano = 0L;
      exemplars = Internal.newMutableList();
      flags = 0;
    }

    /**
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder start_time_unix_nano(long start_time_unix_nano) {
      this.start_time_unix_nano = start_time_unix_nano;
      return this;
    }

    /**
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * (Optional) List of exemplars collected from
     * measurements that were used to form the data point
     */
    public Builder exemplars(List<Exemplar> exemplars) {
      Internal.checkElementsNotNull(exemplars);
      this.exemplars = exemplars;
      return this;
    }

    /**
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    public Builder as_double(Double as_double) {
      this.as_double = as_double;
      this.as_int = null;
      return this;
    }

    public Builder as_int(Long as_int) {
      this.as_int = as_int;
      this.as_double = null;
      return this;
    }

    @Override
    public NumberDataPoint build() {
      return new NumberDataPoint(attributes, start_time_unix_nano, time_unix_nano, exemplars, flags, as_double, as_int, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_NumberDataPoint extends ProtoAdapter<NumberDataPoint> {
    public ProtoAdapter_NumberDataPoint() {
      super(FieldEncoding.LENGTH_DELIMITED, NumberDataPoint.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.NumberDataPoint", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(NumberDataPoint value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(7, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(2, value.start_time_unix_nano);
      }
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(3, value.time_unix_nano);
      }
      result += Exemplar.ADAPTER.asRepeated().encodedSizeWithTag(5, value.exemplars);
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(8, value.flags);
      }
      result += ProtoAdapter.DOUBLE.encodedSizeWithTag(4, value.as_double);
      result += ProtoAdapter.SFIXED64.encodedSizeWithTag(6, value.as_int);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, NumberDataPoint value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 5, value.exemplars);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 8, value.flags);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 4, value.as_double);
      ProtoAdapter.SFIXED64.encodeWithTag(writer, 6, value.as_int);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, NumberDataPoint value) throws IOException {
      writer.writeBytes(value.unknownFields());
      ProtoAdapter.SFIXED64.encodeWithTag(writer, 6, value.as_int);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 4, value.as_double);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 8, value.flags);
      Exemplar.ADAPTER.asRepeated().encodeWithTag(writer, 5, value.exemplars);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.attributes);
    }

    @Override
    public NumberDataPoint decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 2: builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 3: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 4: builder.as_double(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 5: builder.exemplars.add(Exemplar.ADAPTER.decode(reader)); break;
          case 6: builder.as_int(ProtoAdapter.SFIXED64.decode(reader)); break;
          case 7: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 8: builder.flags(ProtoAdapter.UINT32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public NumberDataPoint redact(NumberDataPoint value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      Internal.redactElements(builder.exemplars, Exemplar.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
