// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.ResourceMetrics in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.resource.v1.Resource;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A collection of ScopeMetrics from a Resource.
 */
public final class ResourceMetrics extends Message<ResourceMetrics, ResourceMetrics.Builder> {
  public static final ProtoAdapter<ResourceMetrics> ADAPTER = new ProtoAdapter_ResourceMetrics();

  private static final long serialVersionUID = 0L;

  /**
   * The resource for the metrics in this message.
   * If this field is not set then no resource info is known.
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.resource.v1.Resource#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final Resource resource;

  /**
   * A list of metrics that originate from a resource.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.metrics.v1.ScopeMetrics#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "scopeMetrics"
  )
  public final List<ScopeMetrics> scope_metrics;

  /**
   * The Schema URL, if known. This is the identifier of the Schema that the resource data
   * is recorded in. To learn more about Schema URL see
   * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
   * This schema_url applies to the data in the "resource" field. It does not apply
   * to the data in the "scope_metrics" field which have their own schema_url field.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "schemaUrl"
  )
  public final String schema_url;

  public ResourceMetrics(Resource resource, List<ScopeMetrics> scope_metrics, String schema_url) {
    this(resource, scope_metrics, schema_url, ByteString.EMPTY);
  }

  public ResourceMetrics(Resource resource, List<ScopeMetrics> scope_metrics, String schema_url,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.resource = resource;
    this.scope_metrics = Internal.immutableCopyOf("scope_metrics", scope_metrics);
    if (schema_url == null) {
      throw new IllegalArgumentException("schema_url == null");
    }
    this.schema_url = schema_url;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.resource = resource;
    builder.scope_metrics = Internal.copyOf(scope_metrics);
    builder.schema_url = schema_url;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ResourceMetrics)) return false;
    ResourceMetrics o = (ResourceMetrics) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(resource, o.resource)
        && scope_metrics.equals(o.scope_metrics)
        && Internal.equals(schema_url, o.schema_url);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (resource != null ? resource.hashCode() : 0);
      result = result * 37 + scope_metrics.hashCode();
      result = result * 37 + (schema_url != null ? schema_url.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (resource != null) builder.append(", resource=").append(resource);
    if (!scope_metrics.isEmpty()) builder.append(", scope_metrics=").append(scope_metrics);
    if (schema_url != null) builder.append(", schema_url=").append(Internal.sanitize(schema_url));
    return builder.replace(0, 2, "ResourceMetrics{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ResourceMetrics, Builder> {
    public Resource resource;

    public List<ScopeMetrics> scope_metrics;

    public String schema_url;

    public Builder() {
      scope_metrics = Internal.newMutableList();
      schema_url = "";
    }

    /**
     * The resource for the metrics in this message.
     * If this field is not set then no resource info is known.
     */
    public Builder resource(Resource resource) {
      this.resource = resource;
      return this;
    }

    /**
     * A list of metrics that originate from a resource.
     */
    public Builder scope_metrics(List<ScopeMetrics> scope_metrics) {
      Internal.checkElementsNotNull(scope_metrics);
      this.scope_metrics = scope_metrics;
      return this;
    }

    /**
     * The Schema URL, if known. This is the identifier of the Schema that the resource data
     * is recorded in. To learn more about Schema URL see
     * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
     * This schema_url applies to the data in the "resource" field. It does not apply
     * to the data in the "scope_metrics" field which have their own schema_url field.
     */
    public Builder schema_url(String schema_url) {
      this.schema_url = schema_url;
      return this;
    }

    @Override
    public ResourceMetrics build() {
      return new ResourceMetrics(resource, scope_metrics, schema_url, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ResourceMetrics extends ProtoAdapter<ResourceMetrics> {
    public ProtoAdapter_ResourceMetrics() {
      super(FieldEncoding.LENGTH_DELIMITED, ResourceMetrics.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.ResourceMetrics", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(ResourceMetrics value) {
      int result = 0;
      if (!Objects.equals(value.resource, null)) {
        result += Resource.ADAPTER.encodedSizeWithTag(1, value.resource);
      }
      result += ScopeMetrics.ADAPTER.asRepeated().encodedSizeWithTag(2, value.scope_metrics);
      if (!Objects.equals(value.schema_url, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.schema_url);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, ResourceMetrics value) throws IOException {
      if (!Objects.equals(value.resource, null)) Resource.ADAPTER.encodeWithTag(writer, 1, value.resource);
      ScopeMetrics.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.scope_metrics);
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, ResourceMetrics value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      ScopeMetrics.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.scope_metrics);
      if (!Objects.equals(value.resource, null)) Resource.ADAPTER.encodeWithTag(writer, 1, value.resource);
    }

    @Override
    public ResourceMetrics decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.resource(Resource.ADAPTER.decode(reader)); break;
          case 2: builder.scope_metrics.add(ScopeMetrics.ADAPTER.decode(reader)); break;
          case 3: builder.schema_url(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public ResourceMetrics redact(ResourceMetrics value) {
      Builder builder = value.newBuilder();
      if (builder.resource != null) builder.resource = Resource.ADAPTER.redact(builder.resource);
      Internal.redactElements(builder.scope_metrics, ScopeMetrics.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
