// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.ScopeMetrics in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A collection of Metrics produced by an Scope.
 */
public final class ScopeMetrics extends Message<ScopeMetrics, ScopeMetrics.Builder> {
  public static final ProtoAdapter<ScopeMetrics> ADAPTER = new ProtoAdapter_ScopeMetrics();

  private static final long serialVersionUID = 0L;

  /**
   * The instrumentation scope information for the metrics in this message.
   * Semantically when InstrumentationScope isn't set, it is equivalent with
   * an empty instrumentation scope name (unknown).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.InstrumentationScope#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final InstrumentationScope scope;

  /**
   * A list of metrics that originate from an instrumentation library.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.metrics.v1.Metric#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Metric> metrics;

  /**
   * The Schema URL, if known. This is the identifier of the Schema that the metric data
   * is recorded in. To learn more about Schema URL see
   * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
   * This schema_url applies to all metrics in the "metrics" field.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "schemaUrl"
  )
  public final String schema_url;

  public ScopeMetrics(InstrumentationScope scope, List<Metric> metrics, String schema_url) {
    this(scope, metrics, schema_url, ByteString.EMPTY);
  }

  public ScopeMetrics(InstrumentationScope scope, List<Metric> metrics, String schema_url,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.scope = scope;
    this.metrics = Internal.immutableCopyOf("metrics", metrics);
    if (schema_url == null) {
      throw new IllegalArgumentException("schema_url == null");
    }
    this.schema_url = schema_url;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.scope = scope;
    builder.metrics = Internal.copyOf(metrics);
    builder.schema_url = schema_url;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ScopeMetrics)) return false;
    ScopeMetrics o = (ScopeMetrics) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(scope, o.scope)
        && metrics.equals(o.metrics)
        && Internal.equals(schema_url, o.schema_url);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (scope != null ? scope.hashCode() : 0);
      result = result * 37 + metrics.hashCode();
      result = result * 37 + (schema_url != null ? schema_url.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (scope != null) builder.append(", scope=").append(scope);
    if (!metrics.isEmpty()) builder.append(", metrics=").append(metrics);
    if (schema_url != null) builder.append(", schema_url=").append(Internal.sanitize(schema_url));
    return builder.replace(0, 2, "ScopeMetrics{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ScopeMetrics, Builder> {
    public InstrumentationScope scope;

    public List<Metric> metrics;

    public String schema_url;

    public Builder() {
      metrics = Internal.newMutableList();
      schema_url = "";
    }

    /**
     * The instrumentation scope information for the metrics in this message.
     * Semantically when InstrumentationScope isn't set, it is equivalent with
     * an empty instrumentation scope name (unknown).
     */
    public Builder scope(InstrumentationScope scope) {
      this.scope = scope;
      return this;
    }

    /**
     * A list of metrics that originate from an instrumentation library.
     */
    public Builder metrics(List<Metric> metrics) {
      Internal.checkElementsNotNull(metrics);
      this.metrics = metrics;
      return this;
    }

    /**
     * The Schema URL, if known. This is the identifier of the Schema that the metric data
     * is recorded in. To learn more about Schema URL see
     * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
     * This schema_url applies to all metrics in the "metrics" field.
     */
    public Builder schema_url(String schema_url) {
      this.schema_url = schema_url;
      return this;
    }

    @Override
    public ScopeMetrics build() {
      return new ScopeMetrics(scope, metrics, schema_url, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ScopeMetrics extends ProtoAdapter<ScopeMetrics> {
    public ProtoAdapter_ScopeMetrics() {
      super(FieldEncoding.LENGTH_DELIMITED, ScopeMetrics.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.ScopeMetrics", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(ScopeMetrics value) {
      int result = 0;
      if (!Objects.equals(value.scope, null)) {
        result += InstrumentationScope.ADAPTER.encodedSizeWithTag(1, value.scope);
      }
      result += Metric.ADAPTER.asRepeated().encodedSizeWithTag(2, value.metrics);
      if (!Objects.equals(value.schema_url, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.schema_url);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, ScopeMetrics value) throws IOException {
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
      Metric.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.metrics);
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, ScopeMetrics value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      Metric.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.metrics);
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
    }

    @Override
    public ScopeMetrics decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.scope(InstrumentationScope.ADAPTER.decode(reader)); break;
          case 2: builder.metrics.add(Metric.ADAPTER.decode(reader)); break;
          case 3: builder.schema_url(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public ScopeMetrics redact(ScopeMetrics value) {
      Builder builder = value.newBuilder();
      if (builder.scope != null) builder.scope = InstrumentationScope.ADAPTER.redact(builder.scope);
      Internal.redactElements(builder.metrics, Metric.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
