// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.Sum in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * Sum represents the type of a scalar metric that is calculated as a sum of all
 * reported measurements over a time interval.
 */
public final class Sum extends Message<Sum, Sum.Builder> {
  public static final ProtoAdapter<Sum> ADAPTER = new ProtoAdapter_Sum();

  private static final long serialVersionUID = 0L;

  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.metrics.v1.NumberDataPoint#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "dataPoints"
  )
  public final List<NumberDataPoint> data_points;

  /**
   * aggregation_temporality describes if the aggregator reports delta changes
   * since last report time, or cumulative changes since a fixed start time.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.metrics.v1.AggregationTemporality#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "aggregationTemporality"
  )
  public final AggregationTemporality aggregation_temporality;

  /**
   * If "true" means that the sum is monotonic.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#BOOL",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "isMonotonic"
  )
  public final boolean is_monotonic;

  public Sum(List<NumberDataPoint> data_points, AggregationTemporality aggregation_temporality,
      boolean is_monotonic) {
    this(data_points, aggregation_temporality, is_monotonic, ByteString.EMPTY);
  }

  public Sum(List<NumberDataPoint> data_points, AggregationTemporality aggregation_temporality,
      boolean is_monotonic, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.data_points = Internal.immutableCopyOf("data_points", data_points);
    if (aggregation_temporality == null) {
      throw new IllegalArgumentException("aggregation_temporality == null");
    }
    this.aggregation_temporality = aggregation_temporality;
    this.is_monotonic = is_monotonic;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.data_points = Internal.copyOf(data_points);
    builder.aggregation_temporality = aggregation_temporality;
    builder.is_monotonic = is_monotonic;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Sum)) return false;
    Sum o = (Sum) other;
    return unknownFields().equals(o.unknownFields())
        && data_points.equals(o.data_points)
        && Internal.equals(aggregation_temporality, o.aggregation_temporality)
        && Internal.equals(is_monotonic, o.is_monotonic);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + data_points.hashCode();
      result = result * 37 + (aggregation_temporality != null ? aggregation_temporality.hashCode() : 0);
      result = result * 37 + Boolean.hashCode(is_monotonic);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!data_points.isEmpty()) builder.append(", data_points=").append(data_points);
    if (aggregation_temporality != null) builder.append(", aggregation_temporality=").append(aggregation_temporality);
    builder.append(", is_monotonic=").append(is_monotonic);
    return builder.replace(0, 2, "Sum{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Sum, Builder> {
    public List<NumberDataPoint> data_points;

    public AggregationTemporality aggregation_temporality;

    public boolean is_monotonic;

    public Builder() {
      data_points = Internal.newMutableList();
      aggregation_temporality = AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
      is_monotonic = false;
    }

    public Builder data_points(List<NumberDataPoint> data_points) {
      Internal.checkElementsNotNull(data_points);
      this.data_points = data_points;
      return this;
    }

    /**
     * aggregation_temporality describes if the aggregator reports delta changes
     * since last report time, or cumulative changes since a fixed start time.
     */
    public Builder aggregation_temporality(AggregationTemporality aggregation_temporality) {
      this.aggregation_temporality = aggregation_temporality;
      return this;
    }

    /**
     * If "true" means that the sum is monotonic.
     */
    public Builder is_monotonic(boolean is_monotonic) {
      this.is_monotonic = is_monotonic;
      return this;
    }

    @Override
    public Sum build() {
      return new Sum(data_points, aggregation_temporality, is_monotonic, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Sum extends ProtoAdapter<Sum> {
    public ProtoAdapter_Sum() {
      super(FieldEncoding.LENGTH_DELIMITED, Sum.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.Sum", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(Sum value) {
      int result = 0;
      result += NumberDataPoint.ADAPTER.asRepeated().encodedSizeWithTag(1, value.data_points);
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) {
        result += AggregationTemporality.ADAPTER.encodedSizeWithTag(2, value.aggregation_temporality);
      }
      if (!Objects.equals(value.is_monotonic, false)) {
        result += ProtoAdapter.BOOL.encodedSizeWithTag(3, value.is_monotonic);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Sum value) throws IOException {
      NumberDataPoint.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.data_points);
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) AggregationTemporality.ADAPTER.encodeWithTag(writer, 2, value.aggregation_temporality);
      if (!Objects.equals(value.is_monotonic, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 3, value.is_monotonic);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Sum value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.is_monotonic, false)) ProtoAdapter.BOOL.encodeWithTag(writer, 3, value.is_monotonic);
      if (!Objects.equals(value.aggregation_temporality, AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED)) AggregationTemporality.ADAPTER.encodeWithTag(writer, 2, value.aggregation_temporality);
      NumberDataPoint.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.data_points);
    }

    @Override
    public Sum decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.data_points.add(NumberDataPoint.ADAPTER.decode(reader)); break;
          case 2: {
            try {
              builder.aggregation_temporality(AggregationTemporality.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 3: builder.is_monotonic(ProtoAdapter.BOOL.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Sum redact(Sum value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.data_points, NumberDataPoint.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
