// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.metrics.v1.SummaryDataPoint in opentelemetry/proto/metrics/v1/metrics.proto
package io.opentelemetry.proto.metrics.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * SummaryDataPoint is a single data point in a timeseries that describes the
 * time-varying values of a Summary metric.
 */
public final class SummaryDataPoint extends Message<SummaryDataPoint, SummaryDataPoint.Builder> {
  public static final ProtoAdapter<SummaryDataPoint> ADAPTER = new ProtoAdapter_SummaryDataPoint();

  private static final long serialVersionUID = 0L;

  /**
   * The set of key/value pairs that uniquely identify the timeseries from
   * where this point belongs. The list may be empty (may contain 0 elements).
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 7,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * StartTimeUnixNano is optional but strongly encouraged, see the
   * the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "startTimeUnixNano"
  )
  public final long start_time_unix_nano;

  /**
   * TimeUnixNano is required, see the detailed comments above Metric.
   *
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
   * 1970.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "timeUnixNano"
  )
  public final long time_unix_nano;

  /**
   * count is the number of values in the population. Must be non-negative.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final long count;

  /**
   * sum of the values in the population. If count is zero then this field
   * must be zero.
   *
   * Note: Sum should only be filled out when measuring non-negative discrete
   * events, and is assumed to be monotonic over the values of these events.
   * Negative events *can* be recorded, but sum should not be filled out when
   * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
   * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#summary
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final double sum;

  /**
   * (Optional) list of values at different quantiles of the distribution calculated
   * from the current snapshot. The quantiles must be strictly increasing.
   */
  @WireField(
      tag = 6,
      adapter = "io.opentelemetry.proto.metrics.v1.SummaryDataPoint$ValueAtQuantile#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "quantileValues"
  )
  public final List<ValueAtQuantile> quantile_values;

  /**
   * Flags that apply to this specific data point.  See DataPointFlags
   * for the available flags and their meaning.
   */
  @WireField(
      tag = 8,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  public SummaryDataPoint(List<KeyValue> attributes, long start_time_unix_nano, long time_unix_nano,
      long count, double sum, List<ValueAtQuantile> quantile_values, int flags) {
    this(attributes, start_time_unix_nano, time_unix_nano, count, sum, quantile_values, flags, ByteString.EMPTY);
  }

  public SummaryDataPoint(List<KeyValue> attributes, long start_time_unix_nano, long time_unix_nano,
      long count, double sum, List<ValueAtQuantile> quantile_values, int flags,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.start_time_unix_nano = start_time_unix_nano;
    this.time_unix_nano = time_unix_nano;
    this.count = count;
    this.sum = sum;
    this.quantile_values = Internal.immutableCopyOf("quantile_values", quantile_values);
    this.flags = flags;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.attributes = Internal.copyOf(attributes);
    builder.start_time_unix_nano = start_time_unix_nano;
    builder.time_unix_nano = time_unix_nano;
    builder.count = count;
    builder.sum = sum;
    builder.quantile_values = Internal.copyOf(quantile_values);
    builder.flags = flags;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof SummaryDataPoint)) return false;
    SummaryDataPoint o = (SummaryDataPoint) other;
    return unknownFields().equals(o.unknownFields())
        && attributes.equals(o.attributes)
        && Internal.equals(start_time_unix_nano, o.start_time_unix_nano)
        && Internal.equals(time_unix_nano, o.time_unix_nano)
        && Internal.equals(count, o.count)
        && Internal.equals(sum, o.sum)
        && quantile_values.equals(o.quantile_values)
        && Internal.equals(flags, o.flags);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Long.hashCode(start_time_unix_nano);
      result = result * 37 + Long.hashCode(time_unix_nano);
      result = result * 37 + Long.hashCode(count);
      result = result * 37 + Double.hashCode(sum);
      result = result * 37 + quantile_values.hashCode();
      result = result * 37 + Integer.hashCode(flags);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", start_time_unix_nano=").append(start_time_unix_nano);
    builder.append(", time_unix_nano=").append(time_unix_nano);
    builder.append(", count=").append(count);
    builder.append(", sum=").append(sum);
    if (!quantile_values.isEmpty()) builder.append(", quantile_values=").append(quantile_values);
    builder.append(", flags=").append(flags);
    return builder.replace(0, 2, "SummaryDataPoint{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<SummaryDataPoint, Builder> {
    public List<KeyValue> attributes;

    public long start_time_unix_nano;

    public long time_unix_nano;

    public long count;

    public double sum;

    public List<ValueAtQuantile> quantile_values;

    public int flags;

    public Builder() {
      attributes = Internal.newMutableList();
      start_time_unix_nano = 0L;
      time_unix_nano = 0L;
      count = 0L;
      sum = 0.0;
      quantile_values = Internal.newMutableList();
      flags = 0;
    }

    /**
     * The set of key/value pairs that uniquely identify the timeseries from
     * where this point belongs. The list may be empty (may contain 0 elements).
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * StartTimeUnixNano is optional but strongly encouraged, see the
     * the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder start_time_unix_nano(long start_time_unix_nano) {
      this.start_time_unix_nano = start_time_unix_nano;
      return this;
    }

    /**
     * TimeUnixNano is required, see the detailed comments above Metric.
     *
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
     * 1970.
     */
    public Builder time_unix_nano(long time_unix_nano) {
      this.time_unix_nano = time_unix_nano;
      return this;
    }

    /**
     * count is the number of values in the population. Must be non-negative.
     */
    public Builder count(long count) {
      this.count = count;
      return this;
    }

    /**
     * sum of the values in the population. If count is zero then this field
     * must be zero.
     *
     * Note: Sum should only be filled out when measuring non-negative discrete
     * events, and is assumed to be monotonic over the values of these events.
     * Negative events *can* be recorded, but sum should not be filled out when
     * doing so.  This is specifically to enforce compatibility w/ OpenMetrics,
     * see: https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#summary
     */
    public Builder sum(double sum) {
      this.sum = sum;
      return this;
    }

    /**
     * (Optional) list of values at different quantiles of the distribution calculated
     * from the current snapshot. The quantiles must be strictly increasing.
     */
    public Builder quantile_values(List<ValueAtQuantile> quantile_values) {
      Internal.checkElementsNotNull(quantile_values);
      this.quantile_values = quantile_values;
      return this;
    }

    /**
     * Flags that apply to this specific data point.  See DataPointFlags
     * for the available flags and their meaning.
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    @Override
    public SummaryDataPoint build() {
      return new SummaryDataPoint(attributes, start_time_unix_nano, time_unix_nano, count, sum, quantile_values, flags, super.buildUnknownFields());
    }
  }

  /**
   * Represents the value at a given quantile of a distribution.
   *
   * To record Min and Max values following conventions are used:
   * - The 1.0 quantile is equivalent to the maximum value observed.
   * - The 0.0 quantile is equivalent to the minimum value observed.
   *
   * See the following issue for more context:
   * https://github.com/open-telemetry/opentelemetry-proto/issues/125
   */
  public static final class ValueAtQuantile extends Message<ValueAtQuantile, ValueAtQuantile.Builder> {
    public static final ProtoAdapter<ValueAtQuantile> ADAPTER = new ProtoAdapter_ValueAtQuantile();

    private static final long serialVersionUID = 0L;

    /**
     * The quantile of a distribution. Must be in the interval
     * [0.0, 1.0].
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
        label = WireField.Label.OMIT_IDENTITY
    )
    public final double quantile;

    /**
     * The value at the given quantile of a distribution.
     *
     * Quantile values must NOT be negative.
     */
    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
        label = WireField.Label.OMIT_IDENTITY
    )
    public final double value;

    public ValueAtQuantile(double quantile, double value) {
      this(quantile, value, ByteString.EMPTY);
    }

    public ValueAtQuantile(double quantile, double value, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.quantile = quantile;
      this.value = value;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.quantile = quantile;
      builder.value = value;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof ValueAtQuantile)) return false;
      ValueAtQuantile o = (ValueAtQuantile) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(quantile, o.quantile)
          && Internal.equals(value, o.value);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + Double.hashCode(quantile);
        result = result * 37 + Double.hashCode(value);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append(", quantile=").append(quantile);
      builder.append(", value=").append(value);
      return builder.replace(0, 2, "ValueAtQuantile{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<ValueAtQuantile, Builder> {
      public double quantile;

      public double value;

      public Builder() {
        quantile = 0.0;
        value = 0.0;
      }

      /**
       * The quantile of a distribution. Must be in the interval
       * [0.0, 1.0].
       */
      public Builder quantile(double quantile) {
        this.quantile = quantile;
        return this;
      }

      /**
       * The value at the given quantile of a distribution.
       *
       * Quantile values must NOT be negative.
       */
      public Builder value(double value) {
        this.value = value;
        return this;
      }

      @Override
      public ValueAtQuantile build() {
        return new ValueAtQuantile(quantile, value, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_ValueAtQuantile extends ProtoAdapter<ValueAtQuantile> {
      public ProtoAdapter_ValueAtQuantile() {
        super(FieldEncoding.LENGTH_DELIMITED, ValueAtQuantile.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.SummaryDataPoint.ValueAtQuantile", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
      }

      @Override
      public int encodedSize(ValueAtQuantile value) {
        int result = 0;
        if (!Objects.equals(value.quantile, 0.0)) {
          result += ProtoAdapter.DOUBLE.encodedSizeWithTag(1, value.quantile);
        }
        if (!Objects.equals(value.value, 0.0)) {
          result += ProtoAdapter.DOUBLE.encodedSizeWithTag(2, value.value);
        }
        result += value.unknownFields().size();
        return result;
      }

      @Override
      public void encode(ProtoWriter writer, ValueAtQuantile value) throws IOException {
        if (!Objects.equals(value.quantile, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 1, value.quantile);
        if (!Objects.equals(value.value, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 2, value.value);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public void encode(ReverseProtoWriter writer, ValueAtQuantile value) throws IOException {
        writer.writeBytes(value.unknownFields());
        if (!Objects.equals(value.value, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 2, value.value);
        if (!Objects.equals(value.quantile, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 1, value.quantile);
      }

      @Override
      public ValueAtQuantile decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.quantile(ProtoAdapter.DOUBLE.decode(reader)); break;
            case 2: builder.value(ProtoAdapter.DOUBLE.decode(reader)); break;
            default: {
              reader.readUnknownField(tag);
            }
          }
        }
        builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
        return builder.build();
      }

      @Override
      public ValueAtQuantile redact(ValueAtQuantile value) {
        Builder builder = value.newBuilder();
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  private static final class ProtoAdapter_SummaryDataPoint extends ProtoAdapter<SummaryDataPoint> {
    public ProtoAdapter_SummaryDataPoint() {
      super(FieldEncoding.LENGTH_DELIMITED, SummaryDataPoint.class, "type.googleapis.com/opentelemetry.proto.metrics.v1.SummaryDataPoint", Syntax.PROTO_3, null, "opentelemetry/proto/metrics/v1/metrics.proto");
    }

    @Override
    public int encodedSize(SummaryDataPoint value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(7, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(2, value.start_time_unix_nano);
      }
      if (!Objects.equals(value.time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(3, value.time_unix_nano);
      }
      if (!Objects.equals(value.count, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(4, value.count);
      }
      if (!Objects.equals(value.sum, 0.0)) {
        result += ProtoAdapter.DOUBLE.encodedSizeWithTag(5, value.sum);
      }
      result += ValueAtQuantile.ADAPTER.asRepeated().encodedSizeWithTag(6, value.quantile_values);
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(8, value.flags);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, SummaryDataPoint value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.attributes);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      if (!Objects.equals(value.sum, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      ValueAtQuantile.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.quantile_values);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 8, value.flags);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, SummaryDataPoint value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 8, value.flags);
      ValueAtQuantile.ADAPTER.asRepeated().encodeWithTag(writer, 6, value.quantile_values);
      if (!Objects.equals(value.sum, 0.0)) ProtoAdapter.DOUBLE.encodeWithTag(writer, 5, value.sum);
      if (!Objects.equals(value.count, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 4, value.count);
      if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 3, value.time_unix_nano);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 2, value.start_time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 7, value.attributes);
    }

    @Override
    public SummaryDataPoint decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 2: builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 3: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 4: builder.count(ProtoAdapter.FIXED64.decode(reader)); break;
          case 5: builder.sum(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 6: builder.quantile_values.add(ValueAtQuantile.ADAPTER.decode(reader)); break;
          case 7: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 8: builder.flags(ProtoAdapter.UINT32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public SummaryDataPoint redact(SummaryDataPoint value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      Internal.redactElements(builder.quantile_values, ValueAtQuantile.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
