// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.resource.v1.Resource in opentelemetry/proto/resource/v1/resource.proto
package io.opentelemetry.proto.resource.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * Resource information.
 */
public final class Resource extends Message<Resource, Resource.Builder> {
  public static final ProtoAdapter<Resource> ADAPTER = new ProtoAdapter_Resource();

  private static final long serialVersionUID = 0L;

  /**
   * Set of attributes that describe the resource.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * dropped_attributes_count is the number of dropped attributes. If the value is 0, then
   * no attributes were dropped.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedAttributesCount"
  )
  public final int dropped_attributes_count;

  public Resource(List<KeyValue> attributes, int dropped_attributes_count) {
    this(attributes, dropped_attributes_count, ByteString.EMPTY);
  }

  public Resource(List<KeyValue> attributes, int dropped_attributes_count,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.attributes = Internal.immutableCopyOf("attributes", attributes);
    this.dropped_attributes_count = dropped_attributes_count;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.attributes = Internal.copyOf(attributes);
    builder.dropped_attributes_count = dropped_attributes_count;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Resource)) return false;
    Resource o = (Resource) other;
    return unknownFields().equals(o.unknownFields())
        && attributes.equals(o.attributes)
        && Internal.equals(dropped_attributes_count, o.dropped_attributes_count);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Integer.hashCode(dropped_attributes_count);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
    return builder.replace(0, 2, "Resource{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Resource, Builder> {
    public List<KeyValue> attributes;

    public int dropped_attributes_count;

    public Builder() {
      attributes = Internal.newMutableList();
      dropped_attributes_count = 0;
    }

    /**
     * Set of attributes that describe the resource.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * dropped_attributes_count is the number of dropped attributes. If the value is 0, then
     * no attributes were dropped.
     */
    public Builder dropped_attributes_count(int dropped_attributes_count) {
      this.dropped_attributes_count = dropped_attributes_count;
      return this;
    }

    @Override
    public Resource build() {
      return new Resource(attributes, dropped_attributes_count, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_Resource extends ProtoAdapter<Resource> {
    public ProtoAdapter_Resource() {
      super(FieldEncoding.LENGTH_DELIMITED, Resource.class, "type.googleapis.com/opentelemetry.proto.resource.v1.Resource", Syntax.PROTO_3, null, "opentelemetry/proto/resource/v1/resource.proto");
    }

    @Override
    public int encodedSize(Resource value) {
      int result = 0;
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(1, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(2, value.dropped_attributes_count);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Resource value) throws IOException {
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 2, value.dropped_attributes_count);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Resource value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 2, value.dropped_attributes_count);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.attributes);
    }

    @Override
    public Resource decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 2: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Resource redact(Resource value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
