// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.trace.v1.ScopeSpans in opentelemetry/proto/trace/v1/trace.proto
package io.opentelemetry.proto.trace.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A collection of Spans produced by an InstrumentationScope.
 */
public final class ScopeSpans extends Message<ScopeSpans, ScopeSpans.Builder> {
  public static final ProtoAdapter<ScopeSpans> ADAPTER = new ProtoAdapter_ScopeSpans();

  private static final long serialVersionUID = 0L;

  /**
   * The instrumentation scope information for the spans in this message.
   * Semantically when InstrumentationScope isn't set, it is equivalent with
   * an empty instrumentation scope name (unknown).
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.common.v1.InstrumentationScope#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final InstrumentationScope scope;

  /**
   * A list of Spans that originate from an instrumentation scope.
   */
  @WireField(
      tag = 2,
      adapter = "io.opentelemetry.proto.trace.v1.Span#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Span> spans;

  /**
   * The Schema URL, if known. This is the identifier of the Schema that the span data
   * is recorded in. To learn more about Schema URL see
   * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
   * This schema_url applies to all spans and span events in the "spans" field.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "schemaUrl"
  )
  public final String schema_url;

  public ScopeSpans(InstrumentationScope scope, List<Span> spans, String schema_url) {
    this(scope, spans, schema_url, ByteString.EMPTY);
  }

  public ScopeSpans(InstrumentationScope scope, List<Span> spans, String schema_url,
      ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.scope = scope;
    this.spans = Internal.immutableCopyOf("spans", spans);
    if (schema_url == null) {
      throw new IllegalArgumentException("schema_url == null");
    }
    this.schema_url = schema_url;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.scope = scope;
    builder.spans = Internal.copyOf(spans);
    builder.schema_url = schema_url;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ScopeSpans)) return false;
    ScopeSpans o = (ScopeSpans) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(scope, o.scope)
        && spans.equals(o.spans)
        && Internal.equals(schema_url, o.schema_url);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (scope != null ? scope.hashCode() : 0);
      result = result * 37 + spans.hashCode();
      result = result * 37 + (schema_url != null ? schema_url.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (scope != null) builder.append(", scope=").append(scope);
    if (!spans.isEmpty()) builder.append(", spans=").append(spans);
    if (schema_url != null) builder.append(", schema_url=").append(Internal.sanitize(schema_url));
    return builder.replace(0, 2, "ScopeSpans{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ScopeSpans, Builder> {
    public InstrumentationScope scope;

    public List<Span> spans;

    public String schema_url;

    public Builder() {
      spans = Internal.newMutableList();
      schema_url = "";
    }

    /**
     * The instrumentation scope information for the spans in this message.
     * Semantically when InstrumentationScope isn't set, it is equivalent with
     * an empty instrumentation scope name (unknown).
     */
    public Builder scope(InstrumentationScope scope) {
      this.scope = scope;
      return this;
    }

    /**
     * A list of Spans that originate from an instrumentation scope.
     */
    public Builder spans(List<Span> spans) {
      Internal.checkElementsNotNull(spans);
      this.spans = spans;
      return this;
    }

    /**
     * The Schema URL, if known. This is the identifier of the Schema that the span data
     * is recorded in. To learn more about Schema URL see
     * https://opentelemetry.io/docs/specs/otel/schemas/#schema-url
     * This schema_url applies to all spans and span events in the "spans" field.
     */
    public Builder schema_url(String schema_url) {
      this.schema_url = schema_url;
      return this;
    }

    @Override
    public ScopeSpans build() {
      return new ScopeSpans(scope, spans, schema_url, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ScopeSpans extends ProtoAdapter<ScopeSpans> {
    public ProtoAdapter_ScopeSpans() {
      super(FieldEncoding.LENGTH_DELIMITED, ScopeSpans.class, "type.googleapis.com/opentelemetry.proto.trace.v1.ScopeSpans", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
    }

    @Override
    public int encodedSize(ScopeSpans value) {
      int result = 0;
      if (!Objects.equals(value.scope, null)) {
        result += InstrumentationScope.ADAPTER.encodedSizeWithTag(1, value.scope);
      }
      result += Span.ADAPTER.asRepeated().encodedSizeWithTag(2, value.spans);
      if (!Objects.equals(value.schema_url, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.schema_url);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, ScopeSpans value) throws IOException {
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
      Span.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.spans);
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, ScopeSpans value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.schema_url, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.schema_url);
      Span.ADAPTER.asRepeated().encodeWithTag(writer, 2, value.spans);
      if (!Objects.equals(value.scope, null)) InstrumentationScope.ADAPTER.encodeWithTag(writer, 1, value.scope);
    }

    @Override
    public ScopeSpans decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.scope(InstrumentationScope.ADAPTER.decode(reader)); break;
          case 2: builder.spans.add(Span.ADAPTER.decode(reader)); break;
          case 3: builder.schema_url(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public ScopeSpans redact(ScopeSpans value) {
      Builder builder = value.newBuilder();
      if (builder.scope != null) builder.scope = InstrumentationScope.ADAPTER.redact(builder.scope);
      Internal.redactElements(builder.spans, Span.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
