// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.trace.v1.Span in opentelemetry/proto/trace/v1/trace.proto
package io.opentelemetry.proto.trace.v1;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Objects;
import okio.ByteString;

/**
 * A Span represents a single operation performed by a single component of the system.
 *
 * The next available field id is 17.
 */
public final class Span extends Message<Span, Span.Builder> {
  public static final ProtoAdapter<Span> ADAPTER = new ProtoAdapter_Span();

  private static final long serialVersionUID = 0L;

  /**
   * A unique identifier for a trace. All spans from the same trace share
   * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
   * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
   * is zero-length and thus is also invalid).
   *
   * This field is required.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "traceId"
  )
  public final ByteString trace_id;

  /**
   * A unique identifier for a span within a trace, assigned when the span
   * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
   * other than 8 bytes is considered invalid (empty string in OTLP/JSON
   * is zero-length and thus is also invalid).
   *
   * This field is required.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "spanId"
  )
  public final ByteString span_id;

  /**
   * trace_state conveys information about request position in multiple distributed tracing graphs.
   * It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
   * See also https://github.com/w3c/distributed-tracing for more details about this field.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "traceState"
  )
  public final String trace_state;

  /**
   * The `span_id` of this span's parent span. If this is a root span, then this
   * field must be empty. The ID is an 8-byte array.
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "parentSpanId"
  )
  public final ByteString parent_span_id;

  /**
   * Flags, a bit field. 8 least significant bits are the trace
   * flags as defined in W3C Trace Context specification. Readers
   * MUST not assume that 24 most significant bits will be zero.
   * To read the 8-bit W3C trace flag, use `flags & SPAN_FLAGS_TRACE_FLAGS_MASK`.
   *
   * When creating span messages, if the message is logically forwarded from another source
   * with an equivalent flags fields (i.e., usually another OTLP span message), the field SHOULD
   * be copied as-is. If creating from a source that does not have an equivalent flags field
   * (such as a runtime representation of an OpenTelemetry span), the high 24 bits MUST
   * be set to zero.
   *
   * [Optional].
   *
   * See https://www.w3.org/TR/trace-context-2/#trace-flags for the flag definitions.
   */
  @WireField(
      tag = 16,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED32",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final int flags;

  /**
   * A description of the span's operation.
   *
   * For example, the name can be a qualified method name or a file name
   * and a line number where the operation is called. A best practice is to use
   * the same display name at the same call point in an application.
   * This makes it easier to correlate spans in different traces.
   *
   * This field is semantically required to be set to non-empty string.
   * Empty value is equivalent to an unknown span name.
   *
   * This field is required.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String name;

  /**
   * Distinguishes between spans generated in a particular context. For example,
   * two spans with the same name may be distinguished using `CLIENT` (caller)
   * and `SERVER` (callee) to identify queueing latency associated with the span.
   */
  @WireField(
      tag = 6,
      adapter = "io.opentelemetry.proto.trace.v1.Span$SpanKind#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final SpanKind kind;

  /**
   * start_time_unix_nano is the start time of the span. On the client side, this is the time
   * kept by the local machine where the span execution starts. On the server side, this
   * is the time when the server's application handler starts running.
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
   *
   * This field is semantically required and it is expected that end_time >= start_time.
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "startTimeUnixNano"
  )
  public final long start_time_unix_nano;

  /**
   * end_time_unix_nano is the end time of the span. On the client side, this is the time
   * kept by the local machine where the span execution ends. On the server side, this
   * is the time when the server application handler stops running.
   * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
   *
   * This field is semantically required and it is expected that end_time >= start_time.
   */
  @WireField(
      tag = 8,
      adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "endTimeUnixNano"
  )
  public final long end_time_unix_nano;

  /**
   * attributes is a collection of key/value pairs. Note, global attributes
   * like server name can be set using the resource API. Examples of attributes:
   *
   *     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
   *     "/http/server_latency": 300
   *     "example.com/myattribute": true
   *     "example.com/score": 10.239
   *
   * The OpenTelemetry API specification further restricts the allowed value types:
   * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   */
  @WireField(
      tag = 9,
      adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<KeyValue> attributes;

  /**
   * dropped_attributes_count is the number of attributes that were discarded. Attributes
   * can be discarded because their keys are too long or because there are too many
   * attributes. If this value is 0, then no attributes were dropped.
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedAttributesCount"
  )
  public final int dropped_attributes_count;

  /**
   * events is a collection of Event items.
   */
  @WireField(
      tag = 11,
      adapter = "io.opentelemetry.proto.trace.v1.Span$Event#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Event> events;

  /**
   * dropped_events_count is the number of dropped events. If the value is 0, then no
   * events were dropped.
   */
  @WireField(
      tag = 12,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedEventsCount"
  )
  public final int dropped_events_count;

  /**
   * links is a collection of Links, which are references from this span to a span
   * in the same or different trace.
   */
  @WireField(
      tag = 13,
      adapter = "io.opentelemetry.proto.trace.v1.Span$Link#ADAPTER",
      label = WireField.Label.REPEATED
  )
  public final List<Link> links;

  /**
   * dropped_links_count is the number of dropped links after the maximum size was
   * enforced. If this value is 0, then no links were dropped.
   */
  @WireField(
      tag = 14,
      adapter = "com.squareup.wire.ProtoAdapter#UINT32",
      label = WireField.Label.OMIT_IDENTITY,
      jsonName = "droppedLinksCount"
  )
  public final int dropped_links_count;

  /**
   * An optional final status for this span. Semantically when Status isn't set, it means
   * span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
   */
  @WireField(
      tag = 15,
      adapter = "io.opentelemetry.proto.trace.v1.Status#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final Status status;

  public Span(Builder builder, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (builder.trace_id == null) {
      throw new IllegalArgumentException("builder.trace_id == null");
    }
    this.trace_id = builder.trace_id;
    if (builder.span_id == null) {
      throw new IllegalArgumentException("builder.span_id == null");
    }
    this.span_id = builder.span_id;
    if (builder.trace_state == null) {
      throw new IllegalArgumentException("builder.trace_state == null");
    }
    this.trace_state = builder.trace_state;
    if (builder.parent_span_id == null) {
      throw new IllegalArgumentException("builder.parent_span_id == null");
    }
    this.parent_span_id = builder.parent_span_id;
    this.flags = builder.flags;
    if (builder.name == null) {
      throw new IllegalArgumentException("builder.name == null");
    }
    this.name = builder.name;
    if (builder.kind == null) {
      throw new IllegalArgumentException("builder.kind == null");
    }
    this.kind = builder.kind;
    this.start_time_unix_nano = builder.start_time_unix_nano;
    this.end_time_unix_nano = builder.end_time_unix_nano;
    this.attributes = Internal.immutableCopyOf("attributes", builder.attributes);
    this.dropped_attributes_count = builder.dropped_attributes_count;
    this.events = Internal.immutableCopyOf("events", builder.events);
    this.dropped_events_count = builder.dropped_events_count;
    this.links = Internal.immutableCopyOf("links", builder.links);
    this.dropped_links_count = builder.dropped_links_count;
    this.status = builder.status;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.trace_id = trace_id;
    builder.span_id = span_id;
    builder.trace_state = trace_state;
    builder.parent_span_id = parent_span_id;
    builder.flags = flags;
    builder.name = name;
    builder.kind = kind;
    builder.start_time_unix_nano = start_time_unix_nano;
    builder.end_time_unix_nano = end_time_unix_nano;
    builder.attributes = Internal.copyOf(attributes);
    builder.dropped_attributes_count = dropped_attributes_count;
    builder.events = Internal.copyOf(events);
    builder.dropped_events_count = dropped_events_count;
    builder.links = Internal.copyOf(links);
    builder.dropped_links_count = dropped_links_count;
    builder.status = status;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Span)) return false;
    Span o = (Span) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(trace_id, o.trace_id)
        && Internal.equals(span_id, o.span_id)
        && Internal.equals(trace_state, o.trace_state)
        && Internal.equals(parent_span_id, o.parent_span_id)
        && Internal.equals(flags, o.flags)
        && Internal.equals(name, o.name)
        && Internal.equals(kind, o.kind)
        && Internal.equals(start_time_unix_nano, o.start_time_unix_nano)
        && Internal.equals(end_time_unix_nano, o.end_time_unix_nano)
        && attributes.equals(o.attributes)
        && Internal.equals(dropped_attributes_count, o.dropped_attributes_count)
        && events.equals(o.events)
        && Internal.equals(dropped_events_count, o.dropped_events_count)
        && links.equals(o.links)
        && Internal.equals(dropped_links_count, o.dropped_links_count)
        && Internal.equals(status, o.status);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
      result = result * 37 + (span_id != null ? span_id.hashCode() : 0);
      result = result * 37 + (trace_state != null ? trace_state.hashCode() : 0);
      result = result * 37 + (parent_span_id != null ? parent_span_id.hashCode() : 0);
      result = result * 37 + Integer.hashCode(flags);
      result = result * 37 + (name != null ? name.hashCode() : 0);
      result = result * 37 + (kind != null ? kind.hashCode() : 0);
      result = result * 37 + Long.hashCode(start_time_unix_nano);
      result = result * 37 + Long.hashCode(end_time_unix_nano);
      result = result * 37 + attributes.hashCode();
      result = result * 37 + Integer.hashCode(dropped_attributes_count);
      result = result * 37 + events.hashCode();
      result = result * 37 + Integer.hashCode(dropped_events_count);
      result = result * 37 + links.hashCode();
      result = result * 37 + Integer.hashCode(dropped_links_count);
      result = result * 37 + (status != null ? status.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (trace_id != null) builder.append(", trace_id=").append(trace_id);
    if (span_id != null) builder.append(", span_id=").append(span_id);
    if (trace_state != null) builder.append(", trace_state=").append(Internal.sanitize(trace_state));
    if (parent_span_id != null) builder.append(", parent_span_id=").append(parent_span_id);
    builder.append(", flags=").append(flags);
    if (name != null) builder.append(", name=").append(Internal.sanitize(name));
    if (kind != null) builder.append(", kind=").append(kind);
    builder.append(", start_time_unix_nano=").append(start_time_unix_nano);
    builder.append(", end_time_unix_nano=").append(end_time_unix_nano);
    if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
    builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
    if (!events.isEmpty()) builder.append(", events=").append(events);
    builder.append(", dropped_events_count=").append(dropped_events_count);
    if (!links.isEmpty()) builder.append(", links=").append(links);
    builder.append(", dropped_links_count=").append(dropped_links_count);
    if (status != null) builder.append(", status=").append(status);
    return builder.replace(0, 2, "Span{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Span, Builder> {
    public ByteString trace_id;

    public ByteString span_id;

    public String trace_state;

    public ByteString parent_span_id;

    public int flags;

    public String name;

    public SpanKind kind;

    public long start_time_unix_nano;

    public long end_time_unix_nano;

    public List<KeyValue> attributes;

    public int dropped_attributes_count;

    public List<Event> events;

    public int dropped_events_count;

    public List<Link> links;

    public int dropped_links_count;

    public Status status;

    public Builder() {
      trace_id = ByteString.EMPTY;
      span_id = ByteString.EMPTY;
      trace_state = "";
      parent_span_id = ByteString.EMPTY;
      flags = 0;
      name = "";
      kind = SpanKind.SPAN_KIND_UNSPECIFIED;
      start_time_unix_nano = 0L;
      end_time_unix_nano = 0L;
      attributes = Internal.newMutableList();
      dropped_attributes_count = 0;
      events = Internal.newMutableList();
      dropped_events_count = 0;
      links = Internal.newMutableList();
      dropped_links_count = 0;
    }

    /**
     * A unique identifier for a trace. All spans from the same trace share
     * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     *
     * This field is required.
     */
    public Builder trace_id(ByteString trace_id) {
      this.trace_id = trace_id;
      return this;
    }

    /**
     * A unique identifier for a span within a trace, assigned when the span
     * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     * other than 8 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     *
     * This field is required.
     */
    public Builder span_id(ByteString span_id) {
      this.span_id = span_id;
      return this;
    }

    /**
     * trace_state conveys information about request position in multiple distributed tracing graphs.
     * It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
     * See also https://github.com/w3c/distributed-tracing for more details about this field.
     */
    public Builder trace_state(String trace_state) {
      this.trace_state = trace_state;
      return this;
    }

    /**
     * The `span_id` of this span's parent span. If this is a root span, then this
     * field must be empty. The ID is an 8-byte array.
     */
    public Builder parent_span_id(ByteString parent_span_id) {
      this.parent_span_id = parent_span_id;
      return this;
    }

    /**
     * Flags, a bit field. 8 least significant bits are the trace
     * flags as defined in W3C Trace Context specification. Readers
     * MUST not assume that 24 most significant bits will be zero.
     * To read the 8-bit W3C trace flag, use `flags & SPAN_FLAGS_TRACE_FLAGS_MASK`.
     *
     * When creating span messages, if the message is logically forwarded from another source
     * with an equivalent flags fields (i.e., usually another OTLP span message), the field SHOULD
     * be copied as-is. If creating from a source that does not have an equivalent flags field
     * (such as a runtime representation of an OpenTelemetry span), the high 24 bits MUST
     * be set to zero.
     *
     * [Optional].
     *
     * See https://www.w3.org/TR/trace-context-2/#trace-flags for the flag definitions.
     */
    public Builder flags(int flags) {
      this.flags = flags;
      return this;
    }

    /**
     * A description of the span's operation.
     *
     * For example, the name can be a qualified method name or a file name
     * and a line number where the operation is called. A best practice is to use
     * the same display name at the same call point in an application.
     * This makes it easier to correlate spans in different traces.
     *
     * This field is semantically required to be set to non-empty string.
     * Empty value is equivalent to an unknown span name.
     *
     * This field is required.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `CLIENT` (caller)
     * and `SERVER` (callee) to identify queueing latency associated with the span.
     */
    public Builder kind(SpanKind kind) {
      this.kind = kind;
      return this;
    }

    /**
     * start_time_unix_nano is the start time of the span. On the client side, this is the time
     * kept by the local machine where the span execution starts. On the server side, this
     * is the time when the server's application handler starts running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     *
     * This field is semantically required and it is expected that end_time >= start_time.
     */
    public Builder start_time_unix_nano(long start_time_unix_nano) {
      this.start_time_unix_nano = start_time_unix_nano;
      return this;
    }

    /**
     * end_time_unix_nano is the end time of the span. On the client side, this is the time
     * kept by the local machine where the span execution ends. On the server side, this
     * is the time when the server application handler stops running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     *
     * This field is semantically required and it is expected that end_time >= start_time.
     */
    public Builder end_time_unix_nano(long end_time_unix_nano) {
      this.end_time_unix_nano = end_time_unix_nano;
      return this;
    }

    /**
     * attributes is a collection of key/value pairs. Note, global attributes
     * like server name can be set using the resource API. Examples of attributes:
     *
     *     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
     *     "/http/server_latency": 300
     *     "example.com/myattribute": true
     *     "example.com/score": 10.239
     *
     * The OpenTelemetry API specification further restricts the allowed value types:
     * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    public Builder attributes(List<KeyValue> attributes) {
      Internal.checkElementsNotNull(attributes);
      this.attributes = attributes;
      return this;
    }

    /**
     * dropped_attributes_count is the number of attributes that were discarded. Attributes
     * can be discarded because their keys are too long or because there are too many
     * attributes. If this value is 0, then no attributes were dropped.
     */
    public Builder dropped_attributes_count(int dropped_attributes_count) {
      this.dropped_attributes_count = dropped_attributes_count;
      return this;
    }

    /**
     * events is a collection of Event items.
     */
    public Builder events(List<Event> events) {
      Internal.checkElementsNotNull(events);
      this.events = events;
      return this;
    }

    /**
     * dropped_events_count is the number of dropped events. If the value is 0, then no
     * events were dropped.
     */
    public Builder dropped_events_count(int dropped_events_count) {
      this.dropped_events_count = dropped_events_count;
      return this;
    }

    /**
     * links is a collection of Links, which are references from this span to a span
     * in the same or different trace.
     */
    public Builder links(List<Link> links) {
      Internal.checkElementsNotNull(links);
      this.links = links;
      return this;
    }

    /**
     * dropped_links_count is the number of dropped links after the maximum size was
     * enforced. If this value is 0, then no links were dropped.
     */
    public Builder dropped_links_count(int dropped_links_count) {
      this.dropped_links_count = dropped_links_count;
      return this;
    }

    /**
     * An optional final status for this span. Semantically when Status isn't set, it means
     * span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
     */
    public Builder status(Status status) {
      this.status = status;
      return this;
    }

    @Override
    public Span build() {
      return new Span(this, super.buildUnknownFields());
    }
  }

  /**
   * SpanKind is the type of span. Can be used to specify additional relationships between spans
   * in addition to a parent/child relationship.
   */
  public enum SpanKind implements WireEnum {
    /**
     * Unspecified. Do NOT use as default.
     * Implementations MAY assume SpanKind to be INTERNAL when receiving UNSPECIFIED.
     */
    SPAN_KIND_UNSPECIFIED(0),

    /**
     * Indicates that the span represents an internal operation within an application,
     * as opposed to an operation happening at the boundaries. Default value.
     */
    SPAN_KIND_INTERNAL(1),

    /**
     * Indicates that the span covers server-side handling of an RPC or other
     * remote network request.
     */
    SPAN_KIND_SERVER(2),

    /**
     * Indicates that the span describes a request to some remote service.
     */
    SPAN_KIND_CLIENT(3),

    /**
     * Indicates that the span describes a producer sending a message to a broker.
     * Unlike CLIENT and SERVER, there is often no direct critical path latency relationship
     * between producer and consumer spans. A PRODUCER span ends when the message was accepted
     * by the broker while the logical processing of the message might span a much longer time.
     */
    SPAN_KIND_PRODUCER(4),

    /**
     * Indicates that the span describes consumer receiving a message from a broker.
     * Like the PRODUCER kind, there is often no direct critical path latency relationship
     * between producer and consumer spans.
     */
    SPAN_KIND_CONSUMER(5);

    public static final ProtoAdapter<SpanKind> ADAPTER = new ProtoAdapter_SpanKind();

    private final int value;

    SpanKind(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static SpanKind fromValue(int value) {
      switch (value) {
        case 0: return SPAN_KIND_UNSPECIFIED;
        case 1: return SPAN_KIND_INTERNAL;
        case 2: return SPAN_KIND_SERVER;
        case 3: return SPAN_KIND_CLIENT;
        case 4: return SPAN_KIND_PRODUCER;
        case 5: return SPAN_KIND_CONSUMER;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }

    private static final class ProtoAdapter_SpanKind extends EnumAdapter<SpanKind> {
      ProtoAdapter_SpanKind() {
        super(SpanKind.class, Syntax.PROTO_3, SpanKind.SPAN_KIND_UNSPECIFIED);
      }

      @Override
      protected SpanKind fromValue(int value) {
        return SpanKind.fromValue(value);
      }
    }
  }

  /**
   * Event is a time-stamped annotation of the span, consisting of user-supplied
   * text description and key-value pairs.
   */
  public static final class Event extends Message<Event, Event.Builder> {
    public static final ProtoAdapter<Event> ADAPTER = new ProtoAdapter_Event();

    private static final long serialVersionUID = 0L;

    /**
     * time_unix_nano is the time the event occurred.
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#FIXED64",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "timeUnixNano"
    )
    public final long time_unix_nano;

    /**
     * name of the event.
     * This field is semantically required to be set to non-empty string.
     */
    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#STRING",
        label = WireField.Label.OMIT_IDENTITY
    )
    public final String name;

    /**
     * attributes is a collection of attribute key/value pairs on the event.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    @WireField(
        tag = 3,
        adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
        label = WireField.Label.REPEATED
    )
    public final List<KeyValue> attributes;

    /**
     * dropped_attributes_count is the number of dropped attributes. If the value is 0,
     * then no attributes were dropped.
     */
    @WireField(
        tag = 4,
        adapter = "com.squareup.wire.ProtoAdapter#UINT32",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "droppedAttributesCount"
    )
    public final int dropped_attributes_count;

    public Event(long time_unix_nano, String name, List<KeyValue> attributes,
        int dropped_attributes_count) {
      this(time_unix_nano, name, attributes, dropped_attributes_count, ByteString.EMPTY);
    }

    public Event(long time_unix_nano, String name, List<KeyValue> attributes,
        int dropped_attributes_count, ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      this.time_unix_nano = time_unix_nano;
      if (name == null) {
        throw new IllegalArgumentException("name == null");
      }
      this.name = name;
      this.attributes = Internal.immutableCopyOf("attributes", attributes);
      this.dropped_attributes_count = dropped_attributes_count;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.time_unix_nano = time_unix_nano;
      builder.name = name;
      builder.attributes = Internal.copyOf(attributes);
      builder.dropped_attributes_count = dropped_attributes_count;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof Event)) return false;
      Event o = (Event) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(time_unix_nano, o.time_unix_nano)
          && Internal.equals(name, o.name)
          && attributes.equals(o.attributes)
          && Internal.equals(dropped_attributes_count, o.dropped_attributes_count);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + Long.hashCode(time_unix_nano);
        result = result * 37 + (name != null ? name.hashCode() : 0);
        result = result * 37 + attributes.hashCode();
        result = result * 37 + Integer.hashCode(dropped_attributes_count);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append(", time_unix_nano=").append(time_unix_nano);
      if (name != null) builder.append(", name=").append(Internal.sanitize(name));
      if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
      builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
      return builder.replace(0, 2, "Event{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<Event, Builder> {
      public long time_unix_nano;

      public String name;

      public List<KeyValue> attributes;

      public int dropped_attributes_count;

      public Builder() {
        time_unix_nano = 0L;
        name = "";
        attributes = Internal.newMutableList();
        dropped_attributes_count = 0;
      }

      /**
       * time_unix_nano is the time the event occurred.
       */
      public Builder time_unix_nano(long time_unix_nano) {
        this.time_unix_nano = time_unix_nano;
        return this;
      }

      /**
       * name of the event.
       * This field is semantically required to be set to non-empty string.
       */
      public Builder name(String name) {
        this.name = name;
        return this;
      }

      /**
       * attributes is a collection of attribute key/value pairs on the event.
       * Attribute keys MUST be unique (it is not allowed to have more than one
       * attribute with the same key).
       */
      public Builder attributes(List<KeyValue> attributes) {
        Internal.checkElementsNotNull(attributes);
        this.attributes = attributes;
        return this;
      }

      /**
       * dropped_attributes_count is the number of dropped attributes. If the value is 0,
       * then no attributes were dropped.
       */
      public Builder dropped_attributes_count(int dropped_attributes_count) {
        this.dropped_attributes_count = dropped_attributes_count;
        return this;
      }

      @Override
      public Event build() {
        return new Event(time_unix_nano, name, attributes, dropped_attributes_count, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_Event extends ProtoAdapter<Event> {
      public ProtoAdapter_Event() {
        super(FieldEncoding.LENGTH_DELIMITED, Event.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span.Event", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
      }

      @Override
      public int encodedSize(Event value) {
        int result = 0;
        if (!Objects.equals(value.time_unix_nano, 0L)) {
          result += ProtoAdapter.FIXED64.encodedSizeWithTag(1, value.time_unix_nano);
        }
        if (!Objects.equals(value.name, "")) {
          result += ProtoAdapter.STRING.encodedSizeWithTag(2, value.name);
        }
        result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(3, value.attributes);
        if (!Objects.equals(value.dropped_attributes_count, 0)) {
          result += ProtoAdapter.UINT32.encodedSizeWithTag(4, value.dropped_attributes_count);
        }
        result += value.unknownFields().size();
        return result;
      }

      @Override
      public void encode(ProtoWriter writer, Event value) throws IOException {
        if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 1, value.time_unix_nano);
        if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.name);
        KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
        if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 4, value.dropped_attributes_count);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public void encode(ReverseProtoWriter writer, Event value) throws IOException {
        writer.writeBytes(value.unknownFields());
        if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 4, value.dropped_attributes_count);
        KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 3, value.attributes);
        if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.name);
        if (!Objects.equals(value.time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 1, value.time_unix_nano);
      }

      @Override
      public Event decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
            case 2: builder.name(ProtoAdapter.STRING.decode(reader)); break;
            case 3: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
            case 4: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
            default: {
              reader.readUnknownField(tag);
            }
          }
        }
        builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
        return builder.build();
      }

      @Override
      public Event redact(Event value) {
        Builder builder = value.newBuilder();
        Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  /**
   * A pointer from the current span to another span in the same trace or in a
   * different trace. For example, this can be used in batching operations,
   * where a single batch handler processes multiple requests from different
   * traces or when the handler receives a request from a different project.
   */
  public static final class Link extends Message<Link, Link.Builder> {
    public static final ProtoAdapter<Link> ADAPTER = new ProtoAdapter_Link();

    private static final long serialVersionUID = 0L;

    /**
     * A unique identifier of a trace that this linked span is part of. The ID is a
     * 16-byte array.
     */
    @WireField(
        tag = 1,
        adapter = "com.squareup.wire.ProtoAdapter#BYTES",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "traceId"
    )
    public final ByteString trace_id;

    /**
     * A unique identifier for the linked span. The ID is an 8-byte array.
     */
    @WireField(
        tag = 2,
        adapter = "com.squareup.wire.ProtoAdapter#BYTES",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "spanId"
    )
    public final ByteString span_id;

    /**
     * The trace_state associated with the link.
     */
    @WireField(
        tag = 3,
        adapter = "com.squareup.wire.ProtoAdapter#STRING",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "traceState"
    )
    public final String trace_state;

    /**
     * attributes is a collection of attribute key/value pairs on the link.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     */
    @WireField(
        tag = 4,
        adapter = "io.opentelemetry.proto.common.v1.KeyValue#ADAPTER",
        label = WireField.Label.REPEATED
    )
    public final List<KeyValue> attributes;

    /**
     * dropped_attributes_count is the number of dropped attributes. If the value is 0,
     * then no attributes were dropped.
     */
    @WireField(
        tag = 5,
        adapter = "com.squareup.wire.ProtoAdapter#UINT32",
        label = WireField.Label.OMIT_IDENTITY,
        jsonName = "droppedAttributesCount"
    )
    public final int dropped_attributes_count;

    /**
     * Flags, a bit field. 8 least significant bits are the trace
     * flags as defined in W3C Trace Context specification. Readers
     * MUST not assume that 24 most significant bits will be zero.
     * When creating new spans, the most-significant 24-bits MUST be
     * zero.  To read the 8-bit W3C trace flag (use flags &
     * SPAN_FLAGS_TRACE_FLAGS_MASK).  [Optional].
     *
     * See https://www.w3.org/TR/trace-context-2/#trace-flags for the flag definitions.
     */
    @WireField(
        tag = 6,
        adapter = "com.squareup.wire.ProtoAdapter#FIXED32",
        label = WireField.Label.OMIT_IDENTITY
    )
    public final int flags;

    public Link(ByteString trace_id, ByteString span_id, String trace_state,
        List<KeyValue> attributes, int dropped_attributes_count, int flags) {
      this(trace_id, span_id, trace_state, attributes, dropped_attributes_count, flags, ByteString.EMPTY);
    }

    public Link(ByteString trace_id, ByteString span_id, String trace_state,
        List<KeyValue> attributes, int dropped_attributes_count, int flags,
        ByteString unknownFields) {
      super(ADAPTER, unknownFields);
      if (trace_id == null) {
        throw new IllegalArgumentException("trace_id == null");
      }
      this.trace_id = trace_id;
      if (span_id == null) {
        throw new IllegalArgumentException("span_id == null");
      }
      this.span_id = span_id;
      if (trace_state == null) {
        throw new IllegalArgumentException("trace_state == null");
      }
      this.trace_state = trace_state;
      this.attributes = Internal.immutableCopyOf("attributes", attributes);
      this.dropped_attributes_count = dropped_attributes_count;
      this.flags = flags;
    }

    @Override
    public Builder newBuilder() {
      Builder builder = new Builder();
      builder.trace_id = trace_id;
      builder.span_id = span_id;
      builder.trace_state = trace_state;
      builder.attributes = Internal.copyOf(attributes);
      builder.dropped_attributes_count = dropped_attributes_count;
      builder.flags = flags;
      builder.addUnknownFields(unknownFields());
      return builder;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof Link)) return false;
      Link o = (Link) other;
      return unknownFields().equals(o.unknownFields())
          && Internal.equals(trace_id, o.trace_id)
          && Internal.equals(span_id, o.span_id)
          && Internal.equals(trace_state, o.trace_state)
          && attributes.equals(o.attributes)
          && Internal.equals(dropped_attributes_count, o.dropped_attributes_count)
          && Internal.equals(flags, o.flags);
    }

    @Override
    public int hashCode() {
      int result = super.hashCode;
      if (result == 0) {
        result = unknownFields().hashCode();
        result = result * 37 + (trace_id != null ? trace_id.hashCode() : 0);
        result = result * 37 + (span_id != null ? span_id.hashCode() : 0);
        result = result * 37 + (trace_state != null ? trace_state.hashCode() : 0);
        result = result * 37 + attributes.hashCode();
        result = result * 37 + Integer.hashCode(dropped_attributes_count);
        result = result * 37 + Integer.hashCode(flags);
        super.hashCode = result;
      }
      return result;
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      if (trace_id != null) builder.append(", trace_id=").append(trace_id);
      if (span_id != null) builder.append(", span_id=").append(span_id);
      if (trace_state != null) builder.append(", trace_state=").append(Internal.sanitize(trace_state));
      if (!attributes.isEmpty()) builder.append(", attributes=").append(attributes);
      builder.append(", dropped_attributes_count=").append(dropped_attributes_count);
      builder.append(", flags=").append(flags);
      return builder.replace(0, 2, "Link{").append('}').toString();
    }

    public static final class Builder extends Message.Builder<Link, Builder> {
      public ByteString trace_id;

      public ByteString span_id;

      public String trace_state;

      public List<KeyValue> attributes;

      public int dropped_attributes_count;

      public int flags;

      public Builder() {
        trace_id = ByteString.EMPTY;
        span_id = ByteString.EMPTY;
        trace_state = "";
        attributes = Internal.newMutableList();
        dropped_attributes_count = 0;
        flags = 0;
      }

      /**
       * A unique identifier of a trace that this linked span is part of. The ID is a
       * 16-byte array.
       */
      public Builder trace_id(ByteString trace_id) {
        this.trace_id = trace_id;
        return this;
      }

      /**
       * A unique identifier for the linked span. The ID is an 8-byte array.
       */
      public Builder span_id(ByteString span_id) {
        this.span_id = span_id;
        return this;
      }

      /**
       * The trace_state associated with the link.
       */
      public Builder trace_state(String trace_state) {
        this.trace_state = trace_state;
        return this;
      }

      /**
       * attributes is a collection of attribute key/value pairs on the link.
       * Attribute keys MUST be unique (it is not allowed to have more than one
       * attribute with the same key).
       */
      public Builder attributes(List<KeyValue> attributes) {
        Internal.checkElementsNotNull(attributes);
        this.attributes = attributes;
        return this;
      }

      /**
       * dropped_attributes_count is the number of dropped attributes. If the value is 0,
       * then no attributes were dropped.
       */
      public Builder dropped_attributes_count(int dropped_attributes_count) {
        this.dropped_attributes_count = dropped_attributes_count;
        return this;
      }

      /**
       * Flags, a bit field. 8 least significant bits are the trace
       * flags as defined in W3C Trace Context specification. Readers
       * MUST not assume that 24 most significant bits will be zero.
       * When creating new spans, the most-significant 24-bits MUST be
       * zero.  To read the 8-bit W3C trace flag (use flags &
       * SPAN_FLAGS_TRACE_FLAGS_MASK).  [Optional].
       *
       * See https://www.w3.org/TR/trace-context-2/#trace-flags for the flag definitions.
       */
      public Builder flags(int flags) {
        this.flags = flags;
        return this;
      }

      @Override
      public Link build() {
        return new Link(trace_id, span_id, trace_state, attributes, dropped_attributes_count, flags, super.buildUnknownFields());
      }
    }

    private static final class ProtoAdapter_Link extends ProtoAdapter<Link> {
      public ProtoAdapter_Link() {
        super(FieldEncoding.LENGTH_DELIMITED, Link.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span.Link", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
      }

      @Override
      public int encodedSize(Link value) {
        int result = 0;
        if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
          result += ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id);
        }
        if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
          result += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.span_id);
        }
        if (!Objects.equals(value.trace_state, "")) {
          result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.trace_state);
        }
        result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(4, value.attributes);
        if (!Objects.equals(value.dropped_attributes_count, 0)) {
          result += ProtoAdapter.UINT32.encodedSizeWithTag(5, value.dropped_attributes_count);
        }
        if (!Objects.equals(value.flags, 0)) {
          result += ProtoAdapter.FIXED32.encodedSizeWithTag(6, value.flags);
        }
        result += value.unknownFields().size();
        return result;
      }

      @Override
      public void encode(ProtoWriter writer, Link value) throws IOException {
        if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
        if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
        if (!Objects.equals(value.trace_state, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
        KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.attributes);
        if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 5, value.dropped_attributes_count);
        if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 6, value.flags);
        writer.writeBytes(value.unknownFields());
      }

      @Override
      public void encode(ReverseProtoWriter writer, Link value) throws IOException {
        writer.writeBytes(value.unknownFields());
        if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 6, value.flags);
        if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 5, value.dropped_attributes_count);
        KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 4, value.attributes);
        if (!Objects.equals(value.trace_state, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
        if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
        if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
      }

      @Override
      public Link decode(ProtoReader reader) throws IOException {
        Builder builder = new Builder();
        long token = reader.beginMessage();
        for (int tag; (tag = reader.nextTag()) != -1;) {
          switch (tag) {
            case 1: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
            case 2: builder.span_id(ProtoAdapter.BYTES.decode(reader)); break;
            case 3: builder.trace_state(ProtoAdapter.STRING.decode(reader)); break;
            case 4: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
            case 5: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
            case 6: builder.flags(ProtoAdapter.FIXED32.decode(reader)); break;
            default: {
              reader.readUnknownField(tag);
            }
          }
        }
        builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
        return builder.build();
      }

      @Override
      public Link redact(Link value) {
        Builder builder = value.newBuilder();
        Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
        builder.clearUnknownFields();
        return builder.build();
      }
    }
  }

  private static final class ProtoAdapter_Span extends ProtoAdapter<Span> {
    public ProtoAdapter_Span() {
      super(FieldEncoding.LENGTH_DELIMITED, Span.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Span", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
    }

    @Override
    public int encodedSize(Span value) {
      int result = 0;
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(1, value.trace_id);
      }
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(2, value.span_id);
      }
      if (!Objects.equals(value.trace_state, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(3, value.trace_state);
      }
      if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) {
        result += ProtoAdapter.BYTES.encodedSizeWithTag(4, value.parent_span_id);
      }
      if (!Objects.equals(value.flags, 0)) {
        result += ProtoAdapter.FIXED32.encodedSizeWithTag(16, value.flags);
      }
      if (!Objects.equals(value.name, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(5, value.name);
      }
      if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) {
        result += SpanKind.ADAPTER.encodedSizeWithTag(6, value.kind);
      }
      if (!Objects.equals(value.start_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(7, value.start_time_unix_nano);
      }
      if (!Objects.equals(value.end_time_unix_nano, 0L)) {
        result += ProtoAdapter.FIXED64.encodedSizeWithTag(8, value.end_time_unix_nano);
      }
      result += KeyValue.ADAPTER.asRepeated().encodedSizeWithTag(9, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(10, value.dropped_attributes_count);
      }
      result += Event.ADAPTER.asRepeated().encodedSizeWithTag(11, value.events);
      if (!Objects.equals(value.dropped_events_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(12, value.dropped_events_count);
      }
      result += Link.ADAPTER.asRepeated().encodedSizeWithTag(13, value.links);
      if (!Objects.equals(value.dropped_links_count, 0)) {
        result += ProtoAdapter.UINT32.encodedSizeWithTag(14, value.dropped_links_count);
      }
      if (!Objects.equals(value.status, null)) {
        result += Status.ADAPTER.encodedSizeWithTag(15, value.status);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Span value) throws IOException {
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
      if (!Objects.equals(value.trace_state, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
      if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.parent_span_id);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 16, value.flags);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
      if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) SpanKind.ADAPTER.encodeWithTag(writer, 6, value.kind);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 7, value.start_time_unix_nano);
      if (!Objects.equals(value.end_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 8, value.end_time_unix_nano);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.dropped_attributes_count);
      Event.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.events);
      if (!Objects.equals(value.dropped_events_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 12, value.dropped_events_count);
      Link.ADAPTER.asRepeated().encodeWithTag(writer, 13, value.links);
      if (!Objects.equals(value.dropped_links_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 14, value.dropped_links_count);
      if (!Objects.equals(value.status, null)) Status.ADAPTER.encodeWithTag(writer, 15, value.status);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Span value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.status, null)) Status.ADAPTER.encodeWithTag(writer, 15, value.status);
      if (!Objects.equals(value.dropped_links_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 14, value.dropped_links_count);
      Link.ADAPTER.asRepeated().encodeWithTag(writer, 13, value.links);
      if (!Objects.equals(value.dropped_events_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 12, value.dropped_events_count);
      Event.ADAPTER.asRepeated().encodeWithTag(writer, 11, value.events);
      if (!Objects.equals(value.dropped_attributes_count, 0)) ProtoAdapter.UINT32.encodeWithTag(writer, 10, value.dropped_attributes_count);
      KeyValue.ADAPTER.asRepeated().encodeWithTag(writer, 9, value.attributes);
      if (!Objects.equals(value.end_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 8, value.end_time_unix_nano);
      if (!Objects.equals(value.start_time_unix_nano, 0L)) ProtoAdapter.FIXED64.encodeWithTag(writer, 7, value.start_time_unix_nano);
      if (!Objects.equals(value.kind, SpanKind.SPAN_KIND_UNSPECIFIED)) SpanKind.ADAPTER.encodeWithTag(writer, 6, value.kind);
      if (!Objects.equals(value.name, "")) ProtoAdapter.STRING.encodeWithTag(writer, 5, value.name);
      if (!Objects.equals(value.flags, 0)) ProtoAdapter.FIXED32.encodeWithTag(writer, 16, value.flags);
      if (!Objects.equals(value.parent_span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 4, value.parent_span_id);
      if (!Objects.equals(value.trace_state, "")) ProtoAdapter.STRING.encodeWithTag(writer, 3, value.trace_state);
      if (!Objects.equals(value.span_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 2, value.span_id);
      if (!Objects.equals(value.trace_id, ByteString.EMPTY)) ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.trace_id);
    }

    @Override
    public Span decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.trace_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 2: builder.span_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 3: builder.trace_state(ProtoAdapter.STRING.decode(reader)); break;
          case 4: builder.parent_span_id(ProtoAdapter.BYTES.decode(reader)); break;
          case 5: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 6: {
            try {
              builder.kind(SpanKind.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 7: builder.start_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 8: builder.end_time_unix_nano(ProtoAdapter.FIXED64.decode(reader)); break;
          case 9: builder.attributes.add(KeyValue.ADAPTER.decode(reader)); break;
          case 10: builder.dropped_attributes_count(ProtoAdapter.UINT32.decode(reader)); break;
          case 11: builder.events.add(Event.ADAPTER.decode(reader)); break;
          case 12: builder.dropped_events_count(ProtoAdapter.UINT32.decode(reader)); break;
          case 13: builder.links.add(Link.ADAPTER.decode(reader)); break;
          case 14: builder.dropped_links_count(ProtoAdapter.UINT32.decode(reader)); break;
          case 15: builder.status(Status.ADAPTER.decode(reader)); break;
          case 16: builder.flags(ProtoAdapter.FIXED32.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Span redact(Span value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.attributes, KeyValue.ADAPTER);
      Internal.redactElements(builder.events, Event.ADAPTER);
      Internal.redactElements(builder.links, Link.ADAPTER);
      if (builder.status != null) builder.status = Status.ADAPTER.redact(builder.status);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
