// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.trace.v1.Status in opentelemetry/proto/trace/v1/trace.proto
package io.opentelemetry.proto.trace.v1;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Objects;
import okio.ByteString;

/**
 * The Status type defines a logical error model that is suitable for different
 * programming environments, including REST APIs and RPC APIs.
 */
public final class Status extends Message<Status, Status.Builder> {
  public static final ProtoAdapter<Status> ADAPTER = new ProtoAdapter_Status();

  private static final long serialVersionUID = 0L;

  /**
   * A developer-facing human readable error message.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final String message;

  /**
   * The status code.
   */
  @WireField(
      tag = 3,
      adapter = "io.opentelemetry.proto.trace.v1.Status$StatusCode#ADAPTER",
      label = WireField.Label.OMIT_IDENTITY
  )
  public final StatusCode code;

  public Status(String message, StatusCode code) {
    this(message, code, ByteString.EMPTY);
  }

  public Status(String message, StatusCode code, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    if (message == null) {
      throw new IllegalArgumentException("message == null");
    }
    this.message = message;
    if (code == null) {
      throw new IllegalArgumentException("code == null");
    }
    this.code = code;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.message = message;
    builder.code = code;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof Status)) return false;
    Status o = (Status) other;
    return unknownFields().equals(o.unknownFields())
        && Internal.equals(message, o.message)
        && Internal.equals(code, o.code);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + (message != null ? message.hashCode() : 0);
      result = result * 37 + (code != null ? code.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (message != null) builder.append(", message=").append(Internal.sanitize(message));
    if (code != null) builder.append(", code=").append(code);
    return builder.replace(0, 2, "Status{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<Status, Builder> {
    public String message;

    public StatusCode code;

    public Builder() {
      message = "";
      code = StatusCode.STATUS_CODE_UNSET;
    }

    /**
     * A developer-facing human readable error message.
     */
    public Builder message(String message) {
      this.message = message;
      return this;
    }

    /**
     * The status code.
     */
    public Builder code(StatusCode code) {
      this.code = code;
      return this;
    }

    @Override
    public Status build() {
      return new Status(message, code, super.buildUnknownFields());
    }
  }

  /**
   * For the semantics of status codes see
   * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/trace/api.md#set-status
   */
  public enum StatusCode implements WireEnum {
    /**
     * The default status.
     */
    STATUS_CODE_UNSET(0),

    /**
     * The Span has been validated by an Application developer or Operator to
     * have completed successfully.
     */
    STATUS_CODE_OK(1),

    /**
     * The Span contains an error.
     */
    STATUS_CODE_ERROR(2);

    public static final ProtoAdapter<StatusCode> ADAPTER = new ProtoAdapter_StatusCode();

    private final int value;

    StatusCode(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static StatusCode fromValue(int value) {
      switch (value) {
        case 0: return STATUS_CODE_UNSET;
        case 1: return STATUS_CODE_OK;
        case 2: return STATUS_CODE_ERROR;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }

    private static final class ProtoAdapter_StatusCode extends EnumAdapter<StatusCode> {
      ProtoAdapter_StatusCode() {
        super(StatusCode.class, Syntax.PROTO_3, StatusCode.STATUS_CODE_UNSET);
      }

      @Override
      protected StatusCode fromValue(int value) {
        return StatusCode.fromValue(value);
      }
    }
  }

  private static final class ProtoAdapter_Status extends ProtoAdapter<Status> {
    public ProtoAdapter_Status() {
      super(FieldEncoding.LENGTH_DELIMITED, Status.class, "type.googleapis.com/opentelemetry.proto.trace.v1.Status", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
    }

    @Override
    public int encodedSize(Status value) {
      int result = 0;
      if (!Objects.equals(value.message, "")) {
        result += ProtoAdapter.STRING.encodedSizeWithTag(2, value.message);
      }
      if (!Objects.equals(value.code, StatusCode.STATUS_CODE_UNSET)) {
        result += StatusCode.ADAPTER.encodedSizeWithTag(3, value.code);
      }
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, Status value) throws IOException {
      if (!Objects.equals(value.message, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message);
      if (!Objects.equals(value.code, StatusCode.STATUS_CODE_UNSET)) StatusCode.ADAPTER.encodeWithTag(writer, 3, value.code);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, Status value) throws IOException {
      writer.writeBytes(value.unknownFields());
      if (!Objects.equals(value.code, StatusCode.STATUS_CODE_UNSET)) StatusCode.ADAPTER.encodeWithTag(writer, 3, value.code);
      if (!Objects.equals(value.message, "")) ProtoAdapter.STRING.encodeWithTag(writer, 2, value.message);
    }

    @Override
    public Status decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 2: builder.message(ProtoAdapter.STRING.decode(reader)); break;
          case 3: {
            try {
              builder.code(StatusCode.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public Status redact(Status value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
