// Code generated by Wire protocol buffer compiler, do not edit.
// Source: opentelemetry.proto.trace.v1.TracesData in opentelemetry/proto/trace/v1/trace.proto
package io.opentelemetry.proto.trace.v1;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.ReverseProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import okio.ByteString;

/**
 * TracesData represents the traces data that can be stored in a persistent storage,
 * OR can be embedded by other protocols that transfer OTLP traces data but do
 * not implement the OTLP protocol.
 *
 * The main difference between this message and collector protocol is that
 * in this message there will not be any "control" or "metadata" specific to
 * OTLP protocol.
 *
 * When new fields are added into this message, the OTLP request MUST be updated
 * as well.
 */
public final class TracesData extends Message<TracesData, TracesData.Builder> {
  public static final ProtoAdapter<TracesData> ADAPTER = new ProtoAdapter_TracesData();

  private static final long serialVersionUID = 0L;

  /**
   * An array of ResourceSpans.
   * For data coming from a single resource this array will typically contain
   * one element. Intermediary nodes that receive data from multiple origins
   * typically batch the data before forwarding further and in that case this
   * array will contain multiple elements.
   */
  @WireField(
      tag = 1,
      adapter = "io.opentelemetry.proto.trace.v1.ResourceSpans#ADAPTER",
      label = WireField.Label.REPEATED,
      jsonName = "resourceSpans"
  )
  public final List<ResourceSpans> resource_spans;

  public TracesData(List<ResourceSpans> resource_spans) {
    this(resource_spans, ByteString.EMPTY);
  }

  public TracesData(List<ResourceSpans> resource_spans, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.resource_spans = Internal.immutableCopyOf("resource_spans", resource_spans);
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.resource_spans = Internal.copyOf(resource_spans);
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof TracesData)) return false;
    TracesData o = (TracesData) other;
    return unknownFields().equals(o.unknownFields())
        && resource_spans.equals(o.resource_spans);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + resource_spans.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    if (!resource_spans.isEmpty()) builder.append(", resource_spans=").append(resource_spans);
    return builder.replace(0, 2, "TracesData{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<TracesData, Builder> {
    public List<ResourceSpans> resource_spans;

    public Builder() {
      resource_spans = Internal.newMutableList();
    }

    /**
     * An array of ResourceSpans.
     * For data coming from a single resource this array will typically contain
     * one element. Intermediary nodes that receive data from multiple origins
     * typically batch the data before forwarding further and in that case this
     * array will contain multiple elements.
     */
    public Builder resource_spans(List<ResourceSpans> resource_spans) {
      Internal.checkElementsNotNull(resource_spans);
      this.resource_spans = resource_spans;
      return this;
    }

    @Override
    public TracesData build() {
      return new TracesData(resource_spans, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_TracesData extends ProtoAdapter<TracesData> {
    public ProtoAdapter_TracesData() {
      super(FieldEncoding.LENGTH_DELIMITED, TracesData.class, "type.googleapis.com/opentelemetry.proto.trace.v1.TracesData", Syntax.PROTO_3, null, "opentelemetry/proto/trace/v1/trace.proto");
    }

    @Override
    public int encodedSize(TracesData value) {
      int result = 0;
      result += ResourceSpans.ADAPTER.asRepeated().encodedSizeWithTag(1, value.resource_spans);
      result += value.unknownFields().size();
      return result;
    }

    @Override
    public void encode(ProtoWriter writer, TracesData value) throws IOException {
      ResourceSpans.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.resource_spans);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public void encode(ReverseProtoWriter writer, TracesData value) throws IOException {
      writer.writeBytes(value.unknownFields());
      ResourceSpans.ADAPTER.asRepeated().encodeWithTag(writer, 1, value.resource_spans);
    }

    @Override
    public TracesData decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.resource_spans.add(ResourceSpans.ADAPTER.decode(reader)); break;
          default: {
            reader.readUnknownField(tag);
          }
        }
      }
      builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token));
      return builder.build();
    }

    @Override
    public TracesData redact(TracesData value) {
      Builder builder = value.newBuilder();
      Internal.redactElements(builder.resource_spans, ResourceSpans.ADAPTER);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
