/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering;

import io.opentelemetry.contrib.disk.buffering.StorageConfiguration;
import io.opentelemetry.contrib.disk.buffering.internal.exporter.ToDiskExporter;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.contrib.disk.buffering.internal.utils.SignalTypes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;

public class MetricToDiskExporter
implements MetricExporter {
    private final ToDiskExporter<MetricData> delegate;
    private final Function<InstrumentType, AggregationTemporality> typeToTemporality;

    public static MetricToDiskExporter create(MetricExporter delegate, StorageConfiguration config, Function<InstrumentType, AggregationTemporality> typeToTemporality) throws IOException {
        ToDiskExporter<MetricData> toDisk = ToDiskExporter.builder().setFolderName(SignalTypes.metrics.name()).setStorageConfiguration(config).setSerializer(SignalSerializer.ofMetrics()).setExportFunction(arg_0 -> ((MetricExporter)delegate).export(arg_0)).build();
        return new MetricToDiskExporter(toDisk, typeToTemporality);
    }

    MetricToDiskExporter(ToDiskExporter<MetricData> delegate, Function<InstrumentType, AggregationTemporality> typeToTemporality) {
        this.delegate = delegate;
        this.typeToTemporality = typeToTemporality;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.delegate.export(metrics);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.delegate.shutdown();
        }
        catch (IOException e) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.typeToTemporality.apply(instrumentType);
    }
}

