/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage.files.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    private int position;
    private int mark = -1;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.position = (int)((long)this.position + result);
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.position += result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark is not supported");
        }
        if (this.mark == -1) {
            throw new IOException("Mark is not set");
        }
        this.in.reset();
        this.position = this.mark;
    }
}

