/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.gcp.auth;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.util.Locale;
import java.util.function.Supplier;

public enum ConfigurableOption {
    GOOGLE_CLOUD_PROJECT("Google Cloud Project ID"),
    GOOGLE_CLOUD_QUOTA_PROJECT("Google Cloud Quota Project ID");

    private final String userReadableName;
    private final String environmentVariableName;
    private final String systemPropertyName;

    private ConfigurableOption(String userReadableName) {
        this.userReadableName = userReadableName;
        this.environmentVariableName = this.name();
        this.systemPropertyName = this.environmentVariableName.toLowerCase(Locale.ENGLISH).replace('_', '.');
    }

    String getEnvironmentVariable() {
        return this.environmentVariableName;
    }

    String getSystemProperty() {
        return this.systemPropertyName;
    }

    String getConfiguredValue() {
        String envVar = System.getenv(this.getEnvironmentVariable());
        String sysProp = System.getProperty(this.getSystemProperty());
        if (envVar != null && !envVar.isEmpty()) {
            return envVar;
        }
        if (sysProp != null && !sysProp.isEmpty()) {
            return sysProp;
        }
        throw new ConfigurationException(String.format("GCP Authentication Extension not configured properly: %s not configured. Configure it by exporting environment variable %s or system property %s", this.userReadableName, this.getEnvironmentVariable(), this.getSystemProperty()));
    }

    String getConfiguredValueWithFallback(Supplier<String> fallback) {
        try {
            return this.getConfiguredValue();
        }
        catch (ConfigurationException e) {
            return fallback.get();
        }
    }
}

