/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.marshal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class Serializer
implements AutoCloseable {
    private static final MarshalerContext.Key ATTRIBUTES_WRITER_KEY = MarshalerContext.key();

    Serializer() {
    }

    public void serializeTraceId(ProtoFieldInfo field, @Nullable String traceId) throws IOException {
        if (traceId == null) {
            return;
        }
        this.writeTraceId(field, traceId);
    }

    public void serializeTraceId(ProtoFieldInfo field, @Nullable String traceId, MarshalerContext context) throws IOException {
        if (traceId == null) {
            return;
        }
        this.writeTraceId(field, traceId, context);
    }

    protected abstract void writeTraceId(ProtoFieldInfo var1, String var2) throws IOException;

    protected void writeTraceId(ProtoFieldInfo field, String traceId, MarshalerContext context) throws IOException {
        this.writeTraceId(field, traceId);
    }

    public void serializeSpanId(ProtoFieldInfo field, @Nullable String spanId) throws IOException {
        if (spanId == null) {
            return;
        }
        this.writeSpanId(field, spanId);
    }

    public void serializeSpanId(ProtoFieldInfo field, @Nullable String spanId, MarshalerContext context) throws IOException {
        if (spanId == null) {
            return;
        }
        this.writeSpanId(field, spanId, context);
    }

    protected abstract void writeSpanId(ProtoFieldInfo var1, String var2) throws IOException;

    protected void writeSpanId(ProtoFieldInfo field, String spanId, MarshalerContext context) throws IOException {
        this.writeSpanId(field, spanId);
    }

    public void serializeBool(ProtoFieldInfo field, boolean value) throws IOException {
        if (!value) {
            return;
        }
        this.writeBool(field, value);
    }

    public abstract void writeBool(ProtoFieldInfo var1, boolean var2) throws IOException;

    public void serializeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) throws IOException {
        if (enumValue.getEnumNumber() == 0) {
            return;
        }
        this.writeEnum(field, enumValue);
    }

    protected abstract void writeEnum(ProtoFieldInfo var1, ProtoEnumInfo var2) throws IOException;

    public void serializeUInt32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeUint32(field, value);
    }

    protected abstract void writeUint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeSInt32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeSInt32(field, value);
    }

    protected abstract void writeSInt32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeint32(field, value);
    }

    protected abstract void writeint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt64(ProtoFieldInfo field, long value) throws IOException {
        if (value == 0L) {
            return;
        }
        this.writeInt64(field, value);
    }

    public abstract void writeInt64(ProtoFieldInfo var1, long var2) throws IOException;

    public void serializeFixed64(ProtoFieldInfo field, long value) throws IOException {
        if (value == 0L) {
            return;
        }
        this.writeFixed64(field, value);
    }

    public void serializeFixed64Optional(ProtoFieldInfo field, long value) throws IOException {
        this.writeFixed64(field, value);
    }

    protected abstract void writeFixed64(ProtoFieldInfo var1, long var2) throws IOException;

    protected abstract void writeFixed64Value(long var1) throws IOException;

    protected abstract void writeUInt64Value(long var1) throws IOException;

    public void serializeByteAsFixed32(ProtoFieldInfo field, byte value) throws IOException {
        this.serializeFixed32(field, value & 0xFF);
    }

    public void serializeFixed32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeFixed32(field, value);
    }

    protected abstract void writeFixed32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeDouble(ProtoFieldInfo field, double value) throws IOException {
        if (value == 0.0) {
            return;
        }
        this.writeDouble(field, value);
    }

    public void serializeDoubleOptional(ProtoFieldInfo field, double value) throws IOException {
        this.writeDouble(field, value);
    }

    public abstract void writeDouble(ProtoFieldInfo var1, double var2) throws IOException;

    protected abstract void writeDoubleValue(double var1) throws IOException;

    public void serializeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        if (utf8Bytes.length == 0) {
            return;
        }
        this.writeString(field, utf8Bytes);
    }

    public void serializeStringWithContext(ProtoFieldInfo field, @Nullable String string, MarshalerContext context) throws IOException {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (context.marshalStringNoAllocation()) {
            this.writeString(field, string, context.getSize(), context);
        } else {
            byte[] valueUtf8 = context.getData(byte[].class);
            this.writeString(field, valueUtf8);
        }
    }

    public abstract void writeString(ProtoFieldInfo var1, byte[] var2) throws IOException;

    public abstract void writeString(ProtoFieldInfo var1, String var2, int var3, MarshalerContext var4) throws IOException;

    public void serializeBytes(ProtoFieldInfo field, byte[] value) throws IOException {
        if (value.length == 0) {
            return;
        }
        this.writeBytes(field, value);
    }

    public abstract void writeBytes(ProtoFieldInfo var1, byte[] var2) throws IOException;

    protected abstract void writeStartMessage(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndMessage() throws IOException;

    public void serializeMessage(ProtoFieldInfo field, Marshaler message) throws IOException {
        this.writeStartMessage(field, message.getBinarySerializedSize());
        message.writeTo(this);
        this.writeEndMessage();
    }

    public <T> void serializeMessageWithContext(ProtoFieldInfo field, T message, StatelessMarshaler<T> marshaler, MarshalerContext context) throws IOException {
        this.writeStartMessage(field, context.getSize());
        marshaler.writeTo(this, message, context);
        this.writeEndMessage();
    }

    public <K, V> void serializeMessageWithContext(ProtoFieldInfo field, K key, V value, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) throws IOException {
        this.writeStartMessage(field, context.getSize());
        marshaler.writeTo(this, key, value, context);
        this.writeEndMessage();
    }

    protected abstract void writeStartRepeatedPrimitive(ProtoFieldInfo var1, int var2, int var3) throws IOException;

    protected abstract void writeEndRepeatedPrimitive() throws IOException;

    protected abstract void writeStartRepeatedVarint(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndRepeatedVarint() throws IOException;

    public void serializeRepeatedFixed64(ProtoFieldInfo field, List<Long> values2) throws IOException {
        if (values2.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.size());
        for (int i = 0; i < values2.size(); ++i) {
            Long value = values2.get(i);
            this.writeFixed64Value(value);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedFixed64(ProtoFieldInfo field, long[] values2) throws IOException {
        if (values2.length == 0) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.length);
        for (long value : values2) {
            this.writeFixed64Value(value);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedUInt64(ProtoFieldInfo field, long[] values2) throws IOException {
        if (values2.length == 0) {
            return;
        }
        int payloadSize = 0;
        for (long v : values2) {
            payloadSize += CodedOutputStream.computeUInt64SizeNoTag(v);
        }
        this.writeStartRepeatedVarint(field, payloadSize);
        for (long value : values2) {
            this.writeUInt64Value(value);
        }
        this.writeEndRepeatedVarint();
    }

    public void serializeRepeatedUInt64(ProtoFieldInfo field, DynamicPrimitiveLongList values2) throws IOException {
        int i;
        if (values2.isEmpty()) {
            return;
        }
        int payloadSize = 0;
        for (i = 0; i < values2.size(); ++i) {
            long v = values2.getLong(i);
            payloadSize += CodedOutputStream.computeUInt64SizeNoTag(v);
        }
        this.writeStartRepeatedVarint(field, payloadSize);
        for (i = 0; i < values2.size(); ++i) {
            long value = values2.getLong(i);
            this.writeUInt64Value(value);
        }
        this.writeEndRepeatedVarint();
    }

    public void serializeRepeatedDouble(ProtoFieldInfo field, List<Double> values2) throws IOException {
        if (values2.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values2.size());
        for (int i = 0; i < values2.size(); ++i) {
            Double value = values2.get(i);
            this.writeDoubleValue(value);
        }
        this.writeEndRepeatedPrimitive();
    }

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, Marshaler[] var2) throws IOException;

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, List<? extends Marshaler> var2) throws IOException;

    public abstract <T> void serializeRepeatedMessageWithContext(ProtoFieldInfo var1, List<? extends T> var2, StatelessMarshaler<T> var3, MarshalerContext var4) throws IOException;

    public <T> void serializeRepeatedMessageWithContext(ProtoFieldInfo field, Collection<? extends T> messages, StatelessMarshaler<T> marshaler, MarshalerContext context, MarshalerContext.Key key) throws IOException {
        if (messages instanceof List) {
            this.serializeRepeatedMessageWithContext(field, (List)messages, marshaler, context);
            return;
        }
        this.writeStartRepeated(field);
        if (!messages.isEmpty()) {
            RepeatedElementWriter writer = context.getInstance(key, () -> new RepeatedElementWriter());
            writer.initialize(field, this, marshaler, context);
            messages.forEach(writer);
        }
        this.writeEndRepeated();
    }

    public <K, V> void serializeRepeatedMessageWithContext(ProtoFieldInfo field, Map<K, V> messages, StatelessMarshaler2<K, V> marshaler, MarshalerContext context, MarshalerContext.Key key) throws IOException {
        this.writeStartRepeated(field);
        if (!messages.isEmpty()) {
            RepeatedElementPairWriter writer = context.getInstance(key, () -> new RepeatedElementPairWriter());
            writer.initialize(field, this, marshaler, context);
            messages.forEach(writer);
        }
        this.writeEndRepeated();
    }

    public void serializeRepeatedMessageWithContext(ProtoFieldInfo field, Attributes attributes, StatelessMarshaler2<AttributeKey<?>, Object> marshaler, MarshalerContext context) throws IOException {
        this.writeStartRepeated(field);
        if (!attributes.isEmpty()) {
            RepeatedElementPairWriter writer = context.getInstance(ATTRIBUTES_WRITER_KEY, () -> new RepeatedElementPairWriter());
            writer.initialize(field, this, marshaler, context);
            attributes.forEach(writer);
        }
        this.writeEndRepeated();
    }

    protected abstract void writeStartRepeated(ProtoFieldInfo var1) throws IOException;

    protected abstract void writeEndRepeated() throws IOException;

    protected abstract void writeStartRepeatedElement(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndRepeatedElement() throws IOException;

    public abstract void writeSerializedMessage(byte[] var1, String var2) throws IOException;

    @Override
    public abstract void close() throws IOException;

    private static class RepeatedElementWriter<T>
    implements Consumer<T> {
        private ProtoFieldInfo field;
        private Serializer output;
        private StatelessMarshaler<T> marshaler;
        private MarshalerContext context;

        private RepeatedElementWriter() {
        }

        void initialize(ProtoFieldInfo field, Serializer output, StatelessMarshaler<T> marshaler, MarshalerContext context) {
            this.field = field;
            this.output = output;
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(T element) {
            try {
                this.output.writeStartRepeatedElement(this.field, this.context.getSize());
                this.marshaler.writeTo(this.output, element, this.context);
                this.output.writeEndRepeatedElement();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class RepeatedElementPairWriter<K, V>
    implements BiConsumer<K, V> {
        private ProtoFieldInfo field;
        private Serializer output;
        private StatelessMarshaler2<K, V> marshaler;
        private MarshalerContext context;

        private RepeatedElementPairWriter() {
        }

        void initialize(ProtoFieldInfo field, Serializer output, StatelessMarshaler2<K, V> marshaler, MarshalerContext context) {
            this.field = field;
            this.output = output;
            this.marshaler = marshaler;
            this.context = context;
        }

        @Override
        public void accept(K key, V value) {
            try {
                this.output.writeStartRepeatedElement(this.field, this.context.getSize());
                this.marshaler.writeTo(this.output, key, value, this.context);
                this.output.writeEndRepeatedElement();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

