/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.incubator.logs.AnyValue;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import io.opentelemetry.proto.common.v1.internal.ArrayValue;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

final class ArrayAnyValueMarshaler
extends MarshalerWithSize {
    private final Marshaler value;

    private ArrayAnyValueMarshaler(ArrayValueMarshaler value) {
        super(ArrayAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize createAnyValue(List<AnyValue<?>> values2) {
        return ArrayAnyValueMarshaler.createInternal(values2, AnyValueMarshaler::create);
    }

    static MarshalerWithSize createString(List<String> values2) {
        return ArrayAnyValueMarshaler.createInternal(values2, StringAnyValueMarshaler::create);
    }

    static MarshalerWithSize createBool(List<Boolean> values2) {
        return ArrayAnyValueMarshaler.createInternal(values2, BoolAnyValueMarshaler::create);
    }

    static MarshalerWithSize createInt(List<Long> values2) {
        return ArrayAnyValueMarshaler.createInternal(values2, IntAnyValueMarshaler::create);
    }

    static MarshalerWithSize createDouble(List<Double> values2) {
        return ArrayAnyValueMarshaler.createInternal(values2, DoubleAnyValueMarshaler::create);
    }

    private static <T, M extends MarshalerWithSize> MarshalerWithSize createInternal(List<T> values2, Function<T, M> initializer) {
        int len = values2.size();
        Marshaler[] marshalers = new Marshaler[len];
        for (int i = 0; i < len; ++i) {
            marshalers[i] = (Marshaler)initializer.apply(values2.get(i));
        }
        return new ArrayAnyValueMarshaler(new ArrayValueMarshaler(marshalers));
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, this.value);
    }

    private static int calculateSize(Marshaler value) {
        return MarshalerUtil.sizeMessage(io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, value);
    }

    private static class ArrayValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        private ArrayValueMarshaler(Marshaler[] values2) {
            super(ArrayValueMarshaler.calculateSize(values2));
            this.values = values2;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(ArrayValue.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values2) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ArrayValue.VALUES, (Marshaler[])values2);
        }
    }
}

