/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven.handler;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.maven.MavenGoal;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandler;
import io.opentelemetry.maven.semconv.MavenOtelSemanticAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GoogleJibBuildHandler
implements MojoGoalExecutionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GoogleJibBuildHandler.class);

    GoogleJibBuildHandler() {
    }

    @Override
    public List<MavenGoal> getSupportedGoals() {
        return Collections.singletonList(MavenGoal.create("com.google.cloud.tools", "jib-maven-plugin", "build"));
    }

    @Override
    public void enrichSpan(SpanBuilder spanBuilder, ExecutionEvent executionEvent) {
        String imageName;
        spanBuilder.setSpanKind(SpanKind.CLIENT);
        Xpp3Dom pluginNode = executionEvent.getMojoExecution().getConfiguration();
        if (pluginNode == null) {
            logger.debug("OpenTelemetry: GoogleJibBuildHandler: config node not found");
            return;
        }
        Xpp3Dom toNode = pluginNode.getChild("to");
        if (pluginNode == null) {
            logger.debug("OpenTelemetry: GoogleJibBuildHandler: 'to' node not found");
            return;
        }
        Xpp3Dom imageNode = toNode.getChild("image");
        if (pluginNode == null) {
            logger.debug("OpenTelemetry: GoogleJibBuildHandler: 'to/image' node not found");
            return;
        }
        String imageNameAndTagValue = imageNode.getValue();
        if (imageNameAndTagValue == null) {
            logger.debug("OpenTelemetry: GoogleJibBuildHandler: value of node 'to/image' is null");
            return;
        }
        ArrayList<String> imageTags = new ArrayList<String>();
        int colonIdx = imageNameAndTagValue.indexOf(58);
        if (colonIdx == -1) {
            imageName = imageNameAndTagValue;
        } else {
            imageName = imageNameAndTagValue.substring(0, colonIdx);
            imageTags.add(imageNameAndTagValue.substring(colonIdx + 1));
        }
        Xpp3Dom tagsNode = toNode.getChild("tags");
        Xpp3Dom[] tagNodes = tagsNode == null ? new Xpp3Dom[]{} : tagsNode.getChildren("tag");
        Arrays.stream(tagNodes).map(Xpp3Dom::getValue).forEach(imageTags::add);
        if (imageTags.isEmpty()) {
            imageTags.add(executionEvent.getProject().getVersion());
        }
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_IMAGE_NAME, imageName);
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_IMAGE_TAGS, imageTags);
        String registryHostname = imageName.indexOf(47) == -1 ? "docker.io" : imageName.substring(0, imageName.indexOf(47));
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.MAVEN_BUILD_CONTAINER_REGISTRY_URL, "https://" + registryHostname);
        spanBuilder.setAttribute(UrlAttributes.URL_FULL, "https://" + registryHostname);
        spanBuilder.setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, "POST");
        spanBuilder.setAttribute(MavenOtelSemanticAttributes.PEER_SERVICE, registryHostname);
    }
}

