/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.maven.handler;

import io.opentelemetry.maven.MavenGoal;
import io.opentelemetry.maven.handler.GoogleJibBuildHandler;
import io.opentelemetry.maven.handler.MavenDeployHandler;
import io.opentelemetry.maven.handler.MojoGoalExecutionHandler;
import io.opentelemetry.maven.handler.SnykMonitorHandler;
import io.opentelemetry.maven.handler.SnykTestHandler;
import io.opentelemetry.maven.handler.SpringBootBuildImageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class MojoGoalExecutionHandlerConfiguration {
    public static Map<MavenGoal, MojoGoalExecutionHandler> loadMojoGoalExecutionHandler(ClassLoader classLoader) {
        List<MojoGoalExecutionHandler> builtInHandlers = Arrays.asList(new GoogleJibBuildHandler(), new MavenDeployHandler(), new SnykMonitorHandler(), new SnykTestHandler(), new SpringBootBuildImageHandler());
        ArrayList spiHandlers = new ArrayList();
        ServiceLoader.load(MojoGoalExecutionHandler.class, classLoader).forEach(spiHandlers::add);
        HashMap<MavenGoal, MojoGoalExecutionHandler> mojoGoalExecutionHandlers = new HashMap<MavenGoal, MojoGoalExecutionHandler>();
        Stream.concat(builtInHandlers.stream(), spiHandlers.stream()).forEach(handler -> handler.getSupportedGoals().forEach(goal -> {
            MojoGoalExecutionHandler previousHandler = mojoGoalExecutionHandlers.put((MavenGoal)goal, (MojoGoalExecutionHandler)handler);
            if (previousHandler != null) {
                throw new IllegalStateException("More than one handler found for maven goal " + goal + ": " + previousHandler + ", " + handler);
            }
        }));
        return mojoGoalExecutionHandlers;
    }

    private MojoGoalExecutionHandlerConfiguration() {
    }
}

