/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefaultGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final Logger internalLogger = Logger.getLogger(DefaultGrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final String type;
    private final ManagedChannel managedChannel;
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final long timeoutNanos;
    private final BoundLongCounter seen;
    private final BoundLongCounter success;
    private final BoundLongCounter failed;

    DefaultGrpcExporter(String type, ManagedChannel channel, MarshalerServiceStub<T, ?, ?> stub, long timeoutNanos, boolean compressionEnabled) {
        this.type = type;
        Meter meter = GlobalMeterProvider.get().get("io.opentelemetry.exporters.otlp-grpc");
        Attributes attributes = Attributes.builder().put("type", type).build();
        this.seen = meter.counterBuilder("otlp.exporter.seen").build().bind(attributes);
        LongCounter exported = meter.counterBuilder("otlp.exported.exported").build();
        this.success = exported.bind(attributes.toBuilder().put("success", true).build());
        this.failed = exported.bind(attributes.toBuilder().put("success", false).build());
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        Codec codec = compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        this.stub = (MarshalerServiceStub)stub.withCompression(codec.getMessageEncoding());
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        this.seen.add(numItems);
        final CompletableResultCode result = new CompletableResultCode();
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        Futures.addCallback(stub.export(exportRequest), new FutureCallback<Object>(){

            @Override
            public void onSuccess(@Nullable Object unused) {
                DefaultGrpcExporter.this.success.add(numItems);
                result.succeed();
            }

            @Override
            public void onFailure(Throwable t2) {
                DefaultGrpcExporter.this.failed.add(numItems);
                Status status = Status.fromThrowable(t2);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        DefaultGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + t2.getMessage());
                        break;
                    }
                    case UNAVAILABLE: {
                        DefaultGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + t2.getMessage());
                        break;
                    }
                    default: {
                        DefaultGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + DefaultGrpcExporter.this.type + "s. Error message: " + t2.getMessage());
                    }
                }
                if (DefaultGrpcExporter.this.logger.isLoggable(Level.FINEST)) {
                    DefaultGrpcExporter.this.logger.log(Level.FINEST, "Failed to export " + DefaultGrpcExporter.this.type + "s. Details follow: " + t2);
                }
                result.fail();
            }
        }, MoreExecutors.directExecutor());
        return result;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        this.seen.unbind();
        this.success.unbind();
        this.failed.unbind();
        return ManagedChannelUtil.shutdownChannel(this.managedChannel);
    }
}

